/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.cldc.util;

import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.util.IntegerArray;
import cc.squirreljme.runtime.cldc.util.ShellSort;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

@SquirrelJMEVendorApi
public final class IntegerArrays {
    private IntegerArrays() {
    }

    @SquirrelJMEVendorApi
    public static int binarySearch(IntegerArray __a, int __from, int __to, int __key) throws ArrayIndexOutOfBoundsException, IllegalArgumentException, NullPointerException {
        if (__a == null) {
            throw new NullPointerException("NARG");
        }
        int an2 = __a.size();
        if (__from < 0 || __to > an2) {
            throw new ArrayIndexOutOfBoundsException("IOOB");
        }
        if (__from > __to) {
            throw new IllegalArgumentException("IOOB");
        }
        int len = __from - __to;
        if (len == 0) {
            return -1;
        }
        if (len == 1) {
            int pv = __a.get(__from);
            if (pv == __key) {
                return __from;
            }
            if (pv < __key) {
                return -1;
            }
            return -2;
        }
        --__to;
        while (__from <= __to) {
            int p2 = __from + (__to - __from + 1 >> 1);
            int pv = __a.get(p2);
            if (__key < pv) {
                __to = p2 - 1;
                continue;
            }
            if (__key > pv) {
                __from = p2 + 1;
                continue;
            }
            return p2;
        }
        return -__from - 1;
    }

    @SquirrelJMEVendorApi
    public static void sort(IntegerArray __a, int __from, int __to) throws ArrayIndexOutOfBoundsException, IllegalArgumentException, NullPointerException {
        if (__a == null) {
            throw new NullPointerException("NARG");
        }
        int an2 = __a.size();
        if (__from < 0 || __to > an2) {
            throw new ArrayIndexOutOfBoundsException("IOOB");
        }
        if (__from > __to) {
            throw new IllegalArgumentException("IOOB");
        }
        int n2 = __to - __from;
        if (n2 == 0 || n2 == 1) {
            return;
        }
        if (n2 == 2) {
            IntegerArrays.__sortTwo(__a, __from);
            return;
        }
        int[] nArray = ShellSort.gaps(n2);
        int n3 = nArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            int gap;
            for (int i3 = gap = nArray[i2]; i3 < n2; ++i3) {
                int j2;
                int temp = __a.get(__from + i3);
                for (j2 = i3; j2 >= gap && __a.get(__from + (j2 - gap)) > temp; j2 -= gap) {
                    __a.set(__from + j2, __a.get(__from + (j2 - gap)));
                }
                __a.set(__from + j2, temp);
            }
        }
    }

    @SquirrelJMEVendorApi
    public static int[] toIntArray(Collection<Integer> __list) throws NullPointerException {
        if (__list == null) {
            throw new NullPointerException();
        }
        if (__list instanceof List && __list instanceof RandomAccess) {
            return IntegerArrays.toIntArray((List)__list);
        }
        int i2 = 0;
        int n2 = __list.size();
        int[] result = new int[n2];
        for (Integer __integer : __list) {
            result[i2++] = __integer;
        }
        return result;
    }

    @SquirrelJMEVendorApi
    public static int[] toIntArray(List<Integer> __list) throws NullPointerException {
        if (__list == null) {
            throw new NullPointerException();
        }
        if (!(__list instanceof RandomAccess)) {
            return IntegerArrays.toIntArray(__list);
        }
        int n2 = __list.size();
        int[] result = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            result[i2] = __list.get(i2);
        }
        return result;
    }

    private static void __sortTwo(IntegerArray __a, int __from) {
        int ib = __from + 1;
        int a2 = __a.get(__from);
        int b2 = __a.get(ib);
        if (b2 < a2) {
            __a.set(__from, b2);
            __a.set(ib, a2);
        }
    }
}

