/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.cldc.util;

import cc.squirreljme.jvm.mle.ObjectShelf;
import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

@SquirrelJMEVendorApi
public final class IntegerList
extends AbstractList<Integer>
implements RandomAccess {
    private static final int _GROW_SIZE = 8;
    private volatile int[] _values;
    private volatile int _size;

    @SquirrelJMEVendorApi
    public IntegerList() {
    }

    @SquirrelJMEVendorApi
    public IntegerList(Collection<Integer> __v) throws NullPointerException {
        if (__v == null) {
            throw new NullPointerException("NARG");
        }
        int n2 = __v.size();
        int i2 = 0;
        int[] values = new int[n2];
        for (Integer v2 : __v) {
            values[i2++] = v2;
        }
        this._values = values;
        this._size = n2;
    }

    @SquirrelJMEVendorApi
    public IntegerList(int ... __v) throws NullPointerException {
        if (__v == null) {
            throw new NullPointerException("NARG");
        }
        __v = (int[])__v.clone();
        this._values = __v;
        this._size = __v.length;
    }

    @Override
    public boolean add(Integer __a) throws NullPointerException {
        if (__a == null) {
            throw new NullPointerException("NARG");
        }
        return this.addInteger(__a);
    }

    @Override
    public void add(int __i, Integer __v) throws NullPointerException {
        if (__v == null) {
            throw new NullPointerException("NARG");
        }
        this.addInteger(__i, __v);
    }

    @SquirrelJMEVendorApi
    public boolean addInteger(int __v) {
        this.addInteger(this._size, __v);
        return true;
    }

    @SquirrelJMEVendorApi
    public void addInteger(int __i, int __v) throws IndexOutOfBoundsException {
        if (__i < 0 || __i > this._size) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        boolean realloced = false;
        int size = this._size;
        int[] values = this._values;
        int nvalues = values == null ? 0 : values.length;
        realloced = size + 1 > nvalues;
        if (realloced) {
            values = values == null ? new int[8] : Arrays.copyOf(values, nvalues + 8);
        }
        for (int o2 = size; o2 > __i; ++o2) {
            values[o2] = values[o2 - 1];
        }
        values[__i] = __v;
        ++size;
        if (realloced) {
            this._values = values;
        }
        this._size = size;
    }

    @Override
    public void clear() {
        this._values = null;
        this._size = 0;
    }

    @Override
    public boolean contains(Object __a) {
        if (!(__a instanceof Integer)) {
            return false;
        }
        return this.containsInteger((Integer)__a);
    }

    @SquirrelJMEVendorApi
    public boolean containsInteger(int __v) {
        return this.indexOfInteger(__v) >= 0;
    }

    @Override
    public Integer get(int __i) throws IndexOutOfBoundsException {
        return this.getInteger(__i);
    }

    public int getInteger(int __i) throws IndexOutOfBoundsException {
        if (__i < 0 || __i >= this._size) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        return this._values[__i];
    }

    @Override
    public int indexOf(Object __a) {
        if (!(__a instanceof Integer)) {
            return -1;
        }
        return this.indexOfInteger((Integer)__a);
    }

    @SquirrelJMEVendorApi
    public int indexOfInteger(int __v) {
        int[] values = this._values;
        int n2 = values.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (values[i2] != __v) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this._size == 0;
    }

    @Override
    public int lastIndexOf(Object __a) {
        if (!(__a instanceof Integer)) {
            return -1;
        }
        return this.lastIndexOfInteger((Integer)__a);
    }

    @SquirrelJMEVendorApi
    public int lastIndexOfInteger(int __v) {
        int[] values = this._values;
        int n2 = values.length;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            if (values[i2] != __v) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public boolean remove(Object __a) {
        if (!(__a instanceof Integer)) {
            return false;
        }
        int dx = this.indexOf(__a);
        if (dx < 0) {
            return false;
        }
        this.remove(dx);
        return true;
    }

    @Override
    public Integer remove(int __a) {
        throw Debugging.todo();
    }

    @Override
    public Integer set(int __i, Integer __v) throws NullPointerException {
        if (__v == null) {
            throw new NullPointerException("NARG");
        }
        return this.setInteger(__i, __v);
    }

    @SquirrelJMEVendorApi
    public int setInteger(int __i, int __v) throws IndexOutOfBoundsException {
        if (__i < 0 || __i >= this._size) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        int[] values = this._values;
        int rv = values[__i];
        values[__i] = __v;
        return rv;
    }

    @Override
    public int size() {
        return this._size;
    }

    @SquirrelJMEVendorApi
    public int[] toIntegerArray() {
        int[] values = this._values;
        int size = this._size;
        if (size == 0) {
            return new int[0];
        }
        int[] rv = new int[size];
        ObjectShelf.arrayCopy(values, 0, rv, 0, size);
        return rv;
    }
}

