/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.cldc.util;

import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.util.ReferenceIterator;
import cc.squirreljme.runtime.cldc.util.ReferenceListIterator;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;

@SquirrelJMEVendorApi
public abstract class ReferenceList<T>
extends AbstractList<T> {
    @SquirrelJMEVendorApi
    protected final List<Reference<T>> source;

    ReferenceList(List<Reference<T>> __list) throws NullPointerException {
        if (__list == null) {
            throw new NullPointerException("NARG");
        }
        this.source = __list;
    }

    @Override
    public void add(int __index, T __item) {
        List<Reference<T>> source = this.source;
        if (__item == null) {
            source.add(__index, null);
        } else if (__item instanceof Reference) {
            source.add(__index, (Reference)__item);
        } else {
            source.add(__index, new WeakReference<T>(__item));
        }
    }

    @Override
    public void clear() {
        this.source.clear();
    }

    @Override
    public T get(int __i) throws IndexOutOfBoundsException {
        Reference<T> ref = this.source.get(__i);
        if (ref == null) {
            return null;
        }
        T rv = ref.get();
        if (rv == null) {
            throw new IllegalStateException("GCGC");
        }
        return rv;
    }

    @Override
    public Iterator<T> iterator() {
        return new ReferenceIterator<T>(this.source.iterator());
    }

    @Override
    public ListIterator<T> listIterator() {
        return new ReferenceListIterator<T>(this.source.listIterator());
    }

    @Override
    public ListIterator<T> listIterator(int __i) {
        return new ReferenceListIterator<T>(this.source.listIterator(__i));
    }

    @Override
    public T remove(int __i) {
        Reference<T> item = this.source.remove(__i);
        if (item == null) {
            return null;
        }
        T rv = item.get();
        if (rv == null) {
            throw new IllegalStateException("GCGC");
        }
        return rv;
    }

    @Override
    public T set(int __i, T __v) {
        List<Reference<T>> source = this.source;
        Reference item = __v == null ? (Reference)source.set(__i, null) : (__v instanceof Reference ? source.set(__i, (Reference)__v) : (Reference)source.set(__i, new WeakReference<T>(__v)));
        Object rv = item.get();
        if (rv == null) {
            throw new IllegalStateException("GCGC");
        }
        return rv;
    }

    @Override
    public int size() {
        return this.source.size();
    }

    @SquirrelJMEVendorApi
    public static <T> ReferenceList<T> of(List<Reference<T>> __list) throws NullPointerException {
        if (__list == null) {
            throw new NullPointerException("NARG");
        }
        if (__list instanceof ReferenceList) {
            return (ReferenceList)__list;
        }
        if (__list instanceof RandomAccess) {
            return new __RandomAccess__<T>(__list);
        }
        return new __IteratorAccess__<T>(__list);
    }

    private static final class __RandomAccess__<T>
    extends ReferenceList<T>
    implements RandomAccess {
        __RandomAccess__(List<Reference<T>> __list) throws NullPointerException {
            super(__list);
        }
    }

    private static final class __IteratorAccess__<T>
    extends ReferenceList<T> {
        __IteratorAccess__(List<Reference<T>> __list) throws NullPointerException {
            super(__list);
        }
    }
}

