/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.cldc.util;

import cc.squirreljme.jvm.mle.ObjectShelf;
import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.util.AbstractIntegerArray;
import cc.squirreljme.runtime.cldc.util.IntegerArray;
import cc.squirreljme.runtime.cldc.util.IntegerIntegerArray;
import cc.squirreljme.runtime.cldc.util.NaturalComparator;
import cc.squirreljme.runtime.cldc.util.UnsignedByteIntegerArray;
import cc.squirreljme.runtime.cldc.util.UnsignedShortIntegerArray;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;

@SquirrelJMEVendorApi
public class ShellSort {
    private static final int[] _GAPS = new int[]{1750, 701, 301, 132, 57, 23, 10, 4, 1};
    private static final int[] _TINY = new int[]{1};

    @SquirrelJMEVendorApi
    public static int[] gaps(int __n) throws IllegalArgumentException {
        if (__n < 0) {
            throw new IllegalArgumentException("ZZ5e");
        }
        if (__n < 4) {
            return _TINY;
        }
        int[] gaps = _GAPS;
        int n2 = gaps.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (__n <= gaps[i2]) continue;
            if (i2 == 0) {
                return gaps;
            }
            int subLen = n2 - i2;
            int[] rv = new int[subLen];
            ObjectShelf.arrayCopy(gaps, i2, rv, 0, subLen);
            return rv;
        }
        return _TINY;
    }

    @SquirrelJMEVendorApi
    public static <T> void sort(List<T> __a, int __from, int __to, Comparator<? super T> __comp) throws IndexOutOfBoundsException, IllegalArgumentException, NullPointerException {
        int n2;
        if (__a == null) {
            throw new NullPointerException("NARG");
        }
        int an2 = __a.size();
        if (__from < 0 || __to > an2) {
            throw new ArrayIndexOutOfBoundsException("IOOB");
        }
        if (__from > __to) {
            throw new IllegalArgumentException("IOOB");
        }
        if (__comp == null) {
            __comp = NaturalComparator.instance();
        }
        if ((n2 = __to - __from) == 0 || n2 == 1) {
            return;
        }
        if (!(__a instanceof RandomAccess)) {
            ShellSort.__nonRandom(__a, __from, __comp, n2);
            return;
        }
        if (n2 == 2) {
            ShellSort.__sortTwo(__a, __from, __comp);
            return;
        }
        IntegerArray index = ShellSort.__indexStore(n2);
        int[] nArray = ShellSort.gaps(n2);
        int n3 = nArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            int gap;
            for (int i3 = gap = nArray[i2]; i3 < n2; ++i3) {
                int j2;
                int holeFrom = __from + i3;
                T temp = __a.get(holeFrom);
                int tempDx = index.get(holeFrom);
                for (j2 = i3; j2 >= gap; j2 -= gap) {
                    int from = __from + (j2 - gap);
                    int to = __from + j2;
                    int comp = __comp.compare(__a.get(from), temp);
                    if (comp == 0) {
                        comp = index.get(from) - tempDx;
                    }
                    if (comp <= 0) break;
                    __a.set(to, __a.get(from));
                    index.set(to, index.get(from));
                }
                int holeTo = __from + j2;
                __a.set(holeTo, temp);
                index.set(holeTo, tempDx);
            }
        }
    }

    private static IntegerArray __indexStore(int __n) {
        AbstractIntegerArray rv = __n < 256 ? new UnsignedByteIntegerArray(new byte[__n]) : (__n < 65536 ? new UnsignedShortIntegerArray(new short[__n]) : new IntegerIntegerArray(new int[__n]));
        for (int i2 = 0; i2 < __n; ++i2) {
            rv.set(i2, i2);
        }
        return rv;
    }

    private static <T> void __nonRandom(List<T> __list, int __from, Comparator<? super T> __comp, int __n) {
        ArrayList<T> dup = new ArrayList<T>(__n);
        ListIterator<T> it = __list.listIterator(__from);
        for (int o2 = 0; o2 < __n; ++o2) {
            dup.add(it.next());
        }
        ShellSort.sort(dup, 0, __n, __comp);
        for (int i2 = __n - 1; i2 >= 0; --i2) {
            it.previous();
            it.set(dup.get(i2));
        }
    }

    private static <T> void __sortTwo(List<T> __list, int __from, Comparator<? super T> __comp) {
        int ia = __from;
        int ib = __from + 1;
        T a2 = __list.get(ia);
        T b2 = __list.get(ib);
        if (__comp.compare(b2, a2) < 0) {
            __list.set(ia, b2);
            __list.set(ib, a2);
        }
    }
}

