/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.cldc.util;

import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.util.NaturalComparator;
import cc.squirreljme.runtime.cldc.util.__SortedTreeData__;
import cc.squirreljme.runtime.cldc.util.__SortedTreeEntrySet__;
import cc.squirreljme.runtime.cldc.util.__SortedTreeNode__;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;

@SquirrelJMEVendorApi
public class SortedTreeMap<K, V>
extends AbstractMap<K, V> {
    private static final boolean _LEFT = false;
    private static final boolean _RIGHT = true;
    final Comparator<K> _compare;
    private Reference<Set<Map.Entry<K, V>>> _entryset;
    __SortedTreeNode__<K, V> _root;
    __SortedTreeData__<K, V> _min;
    int _size;

    @SquirrelJMEVendorApi
    public SortedTreeMap() {
        this(NaturalComparator.instance());
    }

    @SquirrelJMEVendorApi
    public SortedTreeMap(Map<? extends Comparable<K>, ? extends V> __m) throws NullPointerException {
        this(NaturalComparator.instance(), __m);
    }

    @SquirrelJMEVendorApi
    public SortedTreeMap(Comparator<? extends K> __comp) throws NullPointerException {
        if (__comp == null) {
            throw new NullPointerException("NARG");
        }
        this._compare = __comp;
    }

    @SquirrelJMEVendorApi
    public SortedTreeMap(Comparator<? extends K> __comp, Map<? extends K, ? extends V> __m) throws NullPointerException {
        if (__comp == null || __m == null) {
            throw new NullPointerException("NARG");
        }
        this._compare = __comp;
        this.putAll(__m);
    }

    @Override
    public void clear() {
        this._root = null;
        this._min = null;
        this._size = 0;
    }

    @Override
    public boolean containsKey(Object __o) {
        return null != this.__findNode(__o);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> rv;
        Reference<Set<Map.Entry<K, V>>> ref = this._entryset;
        if (ref == null || null == (rv = ref.get())) {
            rv = new __SortedTreeEntrySet__(this);
            this._entryset = new WeakReference(rv);
        }
        return rv;
    }

    @Override
    public V get(Object __k) {
        __SortedTreeNode__<K, V> node = this.__findNode(__k);
        if (node == null) {
            return null;
        }
        return node._data._value;
    }

    @Override
    public V put(K __k, V __v) {
        __Found__ found = new __Found__();
        __SortedTreeNode__<K, V> now = this.__insert(null, this._root, found, __k, __v);
        now.__makeBlack();
        this._root = now;
        return found._oldvalue;
    }

    @Override
    public V remove(Object __k) {
        __Found__ found = new __Found__();
        __SortedTreeNode__<Object, V> newroot = this.__remove(this._root, found, __k);
        this._root = newroot;
        if (newroot != null) {
            newroot._isred = false;
        }
        return found._oldvalue;
    }

    @Override
    public int size() {
        return this._size;
    }

    private __SortedTreeNode__<K, V> __correctNodes(__SortedTreeNode__<K, V> __at) throws NullPointerException {
        if (__at == null) {
            throw new NullPointerException("NARG");
        }
        if (this.__isRed(__at._right)) {
            __at = this.__rotate(__at, false);
        }
        if (this.__isRed(__at._left) && this.__isRed(__at._left._left)) {
            __at = this.__rotate(__at, true);
        }
        if (this.__isRed(__at._left) && this.__isRed(__at._right)) {
            this.__flipColor(__at);
        }
        return __at;
    }

    final __SortedTreeNode__<K, V> __findNode(Object __o) {
        __SortedTreeNode__<K, V> rover = this._root;
        if (rover == null) {
            return null;
        }
        return this.__findNode(rover, __o);
    }

    final __SortedTreeNode__<K, V> __findNode(__SortedTreeNode__<K, V> __at, Object __k) {
        Comparator<K> compare = this._compare;
        while (__at != null) {
            Object against = __at._data._key;
            int res = compare.compare(__k, against);
            if (res == 0) {
                return __at;
            }
            if (res < 0) {
                __at = __at._left;
                continue;
            }
            __at = __at._right;
        }
        return null;
    }

    private void __flipColor(__SortedTreeNode__<K, V> __at) throws NullPointerException {
        if (__at == null) {
            throw new NullPointerException("NARG");
        }
        __at._isred = !__at._isred;
        __at._left._isred = !__at._left._isred;
        __at._right._isred = !__at._right._isred;
    }

    private __SortedTreeNode__<K, V> __insert(__SortedTreeNode__<K, V> __from, __SortedTreeNode__<K, V> __at, __Found__ __found, K __k, V __v) {
        if (__at == null) {
            __SortedTreeData__<K, V> oldmin;
            __SortedTreeData__<K, V> data = new __SortedTreeData__<K, V>(this, __k, __v);
            __at = new __SortedTreeNode__();
            __at._data = data;
            data._node = __at;
            if (__from != null) {
                __SortedTreeData__ fd = __from._data;
                if (data.__compare(fd) < 0) {
                    __SortedTreeData__ pp = fd._prev;
                    if (pp != null) {
                        pp._next = data;
                    }
                    data._prev = pp;
                    data._next = fd;
                    fd._prev = data;
                } else {
                    __SortedTreeData__ nn = fd._next;
                    if (nn != null) {
                        nn._prev = data;
                    }
                    data._prev = fd;
                    data._next = nn;
                    fd._next = data;
                }
            }
            if ((oldmin = this._min) == null || data.__compare(oldmin) < 0) {
                this._min = data;
            }
            ++this._size;
            return __at;
        }
        int comp = this._compare.compare(__k, __at._data._key);
        if (comp == 0) {
            __found._oldvalue = __at._data._value;
            __at._data._value = __v;
        } else if (comp < 0) {
            __at._left = this.__insert(__at, __at._left, __found, __k, __v);
        } else {
            __at._right = this.__insert(__at, __at._right, __found, __k, __v);
        }
        return this.__correctNodes(__at);
    }

    private boolean __isRed(__SortedTreeNode__<K, V> __n) {
        if (__n == null) {
            return false;
        }
        return __n._isred;
    }

    private __SortedTreeNode__<K, V> __min(__SortedTreeNode__<K, V> __at) {
        while (__at._left != null) {
            __at = __at._left;
        }
        return __at;
    }

    private __SortedTreeNode__<K, V> __moveRed(__SortedTreeNode__<K, V> __at, boolean __r) {
        this.__flipColor(__at);
        if (__r) {
            if (this.__isRed(__at._left._left)) {
                __at = this.__rotate(__at, true);
                this.__flipColor(__at);
            }
        } else if (this.__isRed(__at._right._left)) {
            __at._right = this.__rotate(__at._right, true);
            __at = this.__rotate(__at, false);
            this.__flipColor(__at);
        }
        return __at;
    }

    private __SortedTreeNode__<K, V> __remove(__SortedTreeNode__<K, V> __at, __Found__ __found, K __k) {
        Comparator<K> compare = this._compare;
        int comp = compare.compare(__k, __at._data._key);
        if (comp < 0) {
            if (!this.__isRed(__at._left) && !this.__isRed(__at._left._left)) {
                __at = this.__moveRed(__at, false);
            }
            __at._left = this.__remove(__at._left, __found, __k);
        } else {
            if (this.__isRed(__at._left)) {
                __at = this.__rotate(__at, true);
                comp = compare.compare(__k, __at._data._key);
            }
            if (comp == 0 && __at._right == null) {
                this.__unlink(__at, __found);
                return null;
            }
            if (!this.__isRed(__at._right) && !this.__isRed(__at._right._left)) {
                __at = this.__moveRed(__at, true);
                comp = compare.compare(__k, __at._data._key);
            }
            if (comp == 0) {
                __SortedTreeNode__ right = __at._right;
                __SortedTreeNode__ minright = this.__min(right);
                this.__unlink(__at, __found);
                __at._data = minright._data;
                this.__removeMin(right, null, false);
            } else {
                __at._right = this.__remove(__at._right, __found, __k);
            }
        }
        return this.__correctNodes(__at);
    }

    private __SortedTreeNode__<K, V> __removeMin(__SortedTreeNode__<K, V> __at, __Found__ __found, boolean __unlink) {
        if (__at._left == null) {
            if (__unlink) {
                this.__unlink(__at, __found);
            }
            return null;
        }
        if (!this.__isRed(__at._left) && !this.__isRed(__at._left._left)) {
            __at = this.__moveRed(__at, false);
        }
        __at._left = this.__removeMin(__at, __found, __unlink);
        return this.__correctNodes(__at);
    }

    private __SortedTreeNode__<K, V> __rotate(__SortedTreeNode__<K, V> __at, boolean __r) throws NullPointerException {
        if (__at == null) {
            throw new NullPointerException("NARG");
        }
        if (__r) {
            __SortedTreeNode__ x2 = __at._left;
            __at._left = x2._right;
            x2._right = __at;
            x2._isred = x2._right._isred;
            x2._right._isred = true;
            return x2;
        }
        __SortedTreeNode__ x3 = __at._right;
        __at._right = x3._left;
        x3._left = __at;
        x3._isred = x3._left._isred;
        x3._left._isred = true;
        return x3;
    }

    private void __unlink(__SortedTreeNode__<K, V> __at, __Found__ __found) {
        __SortedTreeData__ unlink = __at._data;
        if (__found != null) {
            __found._oldvalue = unlink._value;
        }
        __SortedTreeData__ prev = unlink._prev;
        __SortedTreeData__ next = unlink._next;
        if (next != null) {
            next._prev = prev;
        }
        if (prev != null) {
            prev._next = next;
        }
        if (this._min == unlink) {
            this._min = next;
        }
        unlink._value = null;
        unlink._node = null;
        unlink._prev = null;
        unlink._next = null;
        --this._size;
    }

    private final class __Found__ {
        V _oldvalue;

        __Found__() {
        }
    }
}

