/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.cldc.util;

import cc.squirreljme.jvm.mle.RuntimeShelf;
import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

@SquirrelJMEVendorApi
public final class StreamUtils {
    private StreamUtils() {
    }

    @SquirrelJMEVendorApi
    public static byte[] buffer(InputStream __in) throws IOException, NullPointerException {
        return new byte[StreamUtils.bufferSize(__in)];
    }

    @SquirrelJMEVendorApi
    public static int bufferSize(InputStream __in) throws IOException, NullPointerException {
        int initCap;
        switch (RuntimeShelf.memoryProfile()) {
            case -1: {
                initCap = 4096;
                break;
            }
            default: {
                initCap = 16384;
            }
        }
        int avail = -1;
        if (__in != null) {
            avail = Math.max(-1, __in.available());
        }
        int allocSize = avail <= 512 ? initCap : Math.min(initCap, Integer.highestOneBit(avail + 1));
        return allocSize;
    }

    @SquirrelJMEVendorApi
    public static void copy(byte[] __in, OutputStream __out) throws IOException, NullPointerException {
        if (__in == null || __out == null) {
            throw new NullPointerException("NARG");
        }
        try (ByteArrayInputStream in = new ByteArrayInputStream(__in);){
            StreamUtils.copy(in, __out, StreamUtils.buffer(null));
        }
    }

    @SquirrelJMEVendorApi
    public static void copy(InputStream __in, OutputStream __out) throws IOException, NullPointerException {
        if (__in == null || __out == null) {
            throw new NullPointerException("NARG");
        }
        StreamUtils.copy(__in, __out, StreamUtils.buffer(__in));
    }

    @SquirrelJMEVendorApi
    public static void copy(InputStream __in, OutputStream __out, byte[] __tempBuf) throws IOException, NullPointerException {
        int rc;
        if (__in == null || __out == null || __tempBuf == null) {
            throw new NullPointerException("NARG");
        }
        int chunk = __tempBuf.length;
        while ((rc = __in.read(__tempBuf)) >= 0) {
            __out.write(__tempBuf, 0, rc);
        }
    }

    @SquirrelJMEVendorApi
    public static byte[] readAll(InputStream __in) throws IOException, NullPointerException {
        return StreamUtils.readAll(StreamUtils.bufferSize(__in), __in);
    }

    @SquirrelJMEVendorApi
    public static byte[] readAll(int __size, InputStream __in) throws IllegalArgumentException, IOException, NullPointerException {
        if (__in == null) {
            throw new NullPointerException("NARG");
        }
        if (__size <= 0) {
            throw new IllegalArgumentException("ZERO");
        }
        byte[] buf = new byte[__size];
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(__size);){
            int rc;
            while ((rc = __in.read(buf, 0, __size)) >= 0) {
                baos.write(buf, 0, rc);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    @SquirrelJMEVendorApi
    public static List<String> readAllLines(InputStream __in, String __charset) throws IOException, NullPointerException {
        String ln;
        if (__in == null || __charset == null) {
            throw new NullPointerException("NARG");
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(__in, __charset));
        ArrayList<String> result = new ArrayList<String>();
        while ((ln = in.readLine()) != null) {
            if ((ln = ln.trim()).isEmpty()) continue;
            result.add(ln);
        }
        return result;
    }

    @SquirrelJMEVendorApi
    public static int readMostly(InputStream __in, byte[] __b) throws IOException, NullPointerException {
        if (__in == null || __b == null) {
            throw new NullPointerException("NARG");
        }
        return StreamUtils.readMostly(__in, __b, 0, __b.length);
    }

    @SquirrelJMEVendorApi
    public static int readMostly(InputStream __in, byte[] __b, int __o, int __l) throws IndexOutOfBoundsException, IOException, NullPointerException {
        int rv;
        int rc;
        if (__in == null || __b == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l < 0 || __o + __l > __b.length) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        for (rv = 0; rv < __l; rv += rc) {
            rc = __in.read(__b, __o + rv, __l - rv);
            if (rc >= 0) continue;
            if (rv != 0) break;
            return -1;
        }
        return rv;
    }
}

