/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.gcf;

import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.runtime.gcf.FileAddress;
import cc.squirreljme.runtime.gcf.HTTPUrlCharacterSet;
import cc.squirreljme.runtime.gcf.HTTPUtils;
import cc.squirreljme.runtime.gcf.IPAddress;
import cc.squirreljme.runtime.gcf.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import net.multiphasicapps.collections.EmptyList;
import net.multiphasicapps.collections.UnmodifiableList;
import org.intellij.lang.annotations.Language;

public final class HTTPAddress
implements SocketAddress {
    public final IPAddress ipaddr;
    public final FileAddress file;
    public final String query;
    public final String fragment;
    public final List<String> parameters;

    public HTTPAddress(IPAddress __ip, FileAddress __file, List<String> __parameters, String __query, String __frag) throws NullPointerException {
        if (__ip == null || __file == null) {
            throw new NullPointerException("NARG");
        }
        if (__parameters != null) {
            __parameters = new ArrayList<String>(__parameters);
            for (String param : __parameters) {
                if (param != null) continue;
                throw new NullPointerException("NARG");
            }
        }
        this.ipaddr = __ip;
        this.file = __file;
        this.query = __query;
        this.fragment = __frag;
        this.parameters = __parameters == null ? EmptyList.empty() : UnmodifiableList.of(__parameters);
    }

    @Override
    public final boolean equals(Object __o) {
        throw Debugging.todo();
    }

    @Override
    public final int hashCode() {
        throw Debugging.todo();
    }

    @Override
    public final String toString() {
        throw Debugging.todo();
    }

    public static HTTPAddress fromUriPart(@Language(value="http-url-reference") String __p) throws IllegalArgumentException, NullPointerException {
        int hashAt;
        if (__p == null) {
            throw new NullPointerException("NARG");
        }
        Debugging.debugNote("Decode %s", __p);
        if (!__p.startsWith("//")) {
            throw new IllegalArgumentException("EC02 " + __p);
        }
        int sl = (__p = __p.substring(2)).indexOf(47);
        if (sl < 0) {
            return new HTTPAddress(IPAddress.of(__p), FileAddress.of("/"), null, null, null);
        }
        IPAddress ipaddr = IPAddress.of(__p.substring(0, sl));
        __p = __p.substring(sl);
        int nextParam = __p.indexOf(59);
        int nextQuery = __p.indexOf(63);
        int nextFrag = __p.indexOf(35);
        int endPos = nextParam >= 0 ? nextParam : (nextQuery >= 0 ? nextQuery : (nextFrag >= 0 ? nextFrag : __p.length()));
        FileAddress fileAddress = FileAddress.of(__p.substring(0, endPos));
        int el = (__p = __p.substring(endPos)).indexOf(59);
        if (el >= 0) {
            throw Debugging.todo();
        }
        List<String> parameters = null;
        int ql = __p.indexOf(63);
        String query = ql >= 0 ? HTTPUtils.stringDecode(HTTPUrlCharacterSet.QUERY_OR_FRAGMENT, (hashAt = __p.indexOf(35, ql + 1)) < 0 ? __p.substring(ql + 1) : __p.substring(ql + 1, hashAt)) : null;
        int fl = __p.indexOf(35);
        String fragment = fl >= 0 ? HTTPUtils.stringDecode(HTTPUrlCharacterSet.QUERY_OR_FRAGMENT, __p.substring(fl + 1)) : null;
        return new HTTPAddress(ipaddr, fileAddress, parameters, query, fragment);
    }

    public static HTTPAddress fromUriPartUnchecked(String __part) throws NullPointerException {
        if (__part == null) {
            throw new NullPointerException("NARG");
        }
        try {
            return HTTPAddress.fromUriPart(__part);
        }
        catch (IllegalArgumentException e2) {
            e2.printStackTrace();
            return null;
        }
    }
}

