/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.gcf;

import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.runtime.gcf.HTTPAddress;
import cc.squirreljme.runtime.gcf.HTTPAgentConnector;
import cc.squirreljme.runtime.gcf.HTTPResponse;
import cc.squirreljme.runtime.gcf.HTTPSignalListener;
import cc.squirreljme.runtime.gcf.HTTPState;
import cc.squirreljme.runtime.gcf.HTTPStateTracker;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.StreamConnection;

public final class HTTPAgent
implements HTTPSignalListener {
    protected final HTTPAddress address;
    protected final HTTPStateTracker tracker;
    protected final HTTPAgentConnector connector;
    HTTPResponse _response;

    public HTTPAgent(HTTPAddress __addr, HTTPStateTracker __t, HTTPAgentConnector __connector) throws NullPointerException {
        if (__addr == null || __t == null) {
            throw new NullPointerException("NARG");
        }
        this.address = __addr;
        this.tracker = __t;
        this.connector = __connector;
    }

    @Override
    public final void requestReady(byte[] __data) throws IOException, NullPointerException {
        byte[] response;
        if (__data == null) {
            throw new NullPointerException("NARG");
        }
        Debugging.debugNote(" -> %d", __data.length);
        try (StreamConnection socket = this.connector.connectStream(this.address);
             OutputStream out = socket.openOutputStream();
             InputStream in = socket.openInputStream();){
            out.write(__data, 0, __data.length);
            out.flush();
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream(Math.max(1024, in.available()));){
                int rc;
                byte[] buf = new byte[512];
                while ((rc = in.read(buf)) >= 0) {
                    baos.write(buf, 0, rc);
                }
                response = baos.toByteArray();
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
            throw e2;
        }
        this._response = HTTPResponse.parse(response);
        this.tracker._state = HTTPState.CONNECTED;
    }
}

