/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.gcf;

import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.runtime.gcf.HTTPAddress;
import cc.squirreljme.runtime.gcf.HTTPSignalListener;
import cc.squirreljme.runtime.gcf.HTTPState;
import cc.squirreljme.runtime.gcf.HTTPStateTracker;
import cc.squirreljme.runtime.midlet.ApplicationHandler;
import cc.squirreljme.runtime.midlet.ApplicationInterface;
import cc.squirreljme.runtime.midlet.ApplicationType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.Map;

public final class HTTPRequestBuilder
extends OutputStream {
    private static final String _MIDLET_USER_AGENT = "SquirrelJME/0.3.0 Configuration/CLDC-1.0 Configuration/CLDC-1.1 Configuration/CLDC-1.8 Profile/MIDP-1.0 Profile/MIDP-2.0 Profile/MIDP-2.1 Profile/MIDP-3.0 Profile/MEEP-8.0";
    protected final HTTPAddress address;
    protected final HTTPSignalListener listener;
    protected final HTTPStateTracker tracker;
    private final ByteArrayOutputStream _bytes = new ByteArrayOutputStream();
    private final Map<String, String> _rqprops = new LinkedHashMap<String, String>();
    private String _rqmethod = "GET";

    public HTTPRequestBuilder(HTTPAddress __addr, HTTPStateTracker __st, HTTPSignalListener __l) throws NullPointerException {
        if (__l == null || __st == null || __addr == null) {
            throw new NullPointerException("NARG");
        }
        this.listener = __l;
        this.tracker = __st;
        this.address = __addr;
    }

    @Override
    public final void close() throws IOException {
        if (this.tracker._state != HTTPState.SETUP) {
            return;
        }
        this.listener.requestReady(this.getBytes());
    }

    @Override
    public final void flush() throws IOException {
        if (this.tracker._state != HTTPState.SETUP) {
            throw new IOException("EC04");
        }
        Debugging.todoNote("Implement HTTP Flush", new Object[0]);
    }

    public final byte[] getBytes() throws IOException {
        HTTPAddress address = this.address;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);){
            byte[] bytes = this._bytes.toByteArray();
            try (PrintStream ps = new PrintStream((OutputStream)baos, true, "utf-8");){
                ps.printf("%s %s HTTP/1.1\r\n", this._rqmethod, address.file);
                LinkedHashMap<String, String> rqp = new LinkedHashMap<String, String>(this._rqprops);
                rqp.put("host", address.ipaddr.hostname);
                String ua = (String)rqp.get("user-agent");
                rqp.put("user-agent", HTTPRequestBuilder.buildUserAgent(ua));
                if (bytes != null) {
                    rqp.put("content-length", Integer.toString(bytes.length));
                }
                for (Map.Entry e2 : rqp.entrySet()) {
                    ps.printf("%s: %s\r\n", e2.getKey(), e2.getValue());
                }
                ps.print("\r\n");
                ps.flush();
            }
            if (bytes != null) {
                baos.write(bytes, 0, bytes.length);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public final void setRequestMethod(String __m) throws IOException, NullPointerException {
        if (__m == null) {
            throw new NullPointerException("NARG");
        }
        this._rqmethod = __m.toUpperCase();
    }

    public final void setRequestProperty(String __k, String __v) throws IOException {
        if (__k == null) {
            throw new NullPointerException("NARG");
        }
        __k = __k.toLowerCase();
        Map<String, String> rqprops = this._rqprops;
        if (__v == null) {
            rqprops.remove(__k);
        } else {
            rqprops.put(__k, __v);
        }
    }

    @Override
    public final void write(int __b) throws IOException {
        if (this.tracker._state != HTTPState.SETUP) {
            throw new IOException("EC05");
        }
        this._bytes.write(__b);
    }

    @Override
    public final void write(byte[] __a) throws IOException, NullPointerException {
        this.write(__a, 0, __a.length);
    }

    @Override
    public final void write(byte[] __a, int __o, int __l) throws IndexOutOfBoundsException, IOException, NullPointerException {
        if (__a == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l < 0 || __o + __l > __a.length) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        if (this.tracker._state != HTTPState.SETUP) {
            throw new IOException("EC06");
        }
        this._bytes.write(__a, __o, __l);
    }

    public static String buildUserAgent(String __existing) {
        ApplicationInterface<?> appInterface = ApplicationHandler.currentInterface();
        ApplicationType appType = appInterface == null ? null : appInterface.type();
        StringBuilder result = new StringBuilder(32);
        switch (appType == null ? ApplicationType.MIDLET : appType) {
            case NTT_DOCOMO_DOJA: 
            case NTT_DOCOMO_STAR: {
                result.append("DoCoMo/2.0 ");
                result.append("SJME");
                result.append(0);
                result.append("M");
                result.append(3);
                result.append("R");
                result.append(0);
                result.append('(');
                result.append("c999");
                result.append(';');
                if (appType == ApplicationType.NTT_DOCOMO_STAR) {
                    result.append("SJ");
                } else {
                    result.append("TJ");
                }
                result.append(')');
                break;
            }
            default: {
                if (__existing != null) {
                    result.append(__existing);
                    result.append(' ');
                }
                result.append(_MIDLET_USER_AGENT);
            }
        }
        return result.toString();
    }
}

