/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.gcf;

import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.runtime.gcf.HTTPResponseHeader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public final class HTTPResponse {
    public final HTTPResponseHeader header;
    private final byte[] _data;

    public HTTPResponse(HTTPResponseHeader __h, byte[] __d) throws NullPointerException {
        if (__h == null || __d == null) {
            throw new NullPointerException("NARG");
        }
        this.header = __h;
        this._data = (byte[])__d.clone();
    }

    public final InputStream inputStream() {
        return new ByteArrayInputStream(this._data);
    }

    public static final HTTPResponse parse(byte[] __b) throws IOException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        return HTTPResponse.parse(new ByteArrayInputStream(__b));
    }

    public static final HTTPResponse parse(InputStream __in) throws IOException, NullPointerException {
        byte[] bytes;
        int length;
        if (__in == null) {
            throw new NullPointerException("NARG");
        }
        HTTPResponseHeader header = HTTPResponseHeader.parse(__in);
        try {
            String rl = header.header("content-length");
            length = rl != null ? Integer.parseInt(rl, 10) : -1;
        }
        catch (NumberFormatException e2) {
            throw new IOException("EC07", e2);
        }
        if (length >= 0) {
            int rc;
            bytes = new byte[length];
            for (int at2 = 0; at2 < length; at2 += rc) {
                rc = __in.read(bytes, at2, length - at2);
                if (rc >= 0) continue;
                throw new IOException("EC08 " + at2 + " " + length);
            }
        } else {
            byte[] buf = new byte[512];
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);){
                int rc;
                while ((rc = __in.read(buf)) >= 0) {
                    baos.write(buf, 0, rc);
                }
                bytes = baos.toByteArray();
            }
        }
        Debugging.debugNote(" <- %d", bytes.length);
        return new HTTPResponse(header, bytes);
    }
}

