/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.gcf;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;

public final class HTTPResponseHeader {
    public final int code;
    public final String message;
    private final Map<String, String> _headers;

    public HTTPResponseHeader(int __rcode, String __rmesg, Map<String, String> __hkvs) throws NullPointerException {
        if (__rmesg == null || __hkvs == null) {
            throw new NullPointerException("NARG");
        }
        this.code = __rcode;
        this.message = __rmesg;
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> e2 : __hkvs.entrySet()) {
            String k2 = e2.getKey();
            String v2 = e2.getValue();
            if (k2 == null || v2 == null) {
                throw new NullPointerException("NARG");
            }
            headers.put(k2.trim().toLowerCase(), v2.trim().toLowerCase());
        }
        this._headers = headers;
    }

    public final String header(String __k) throws NullPointerException {
        if (__k == null) {
            throw new NullPointerException("NARG");
        }
        return this._headers.get(__k.toLowerCase());
    }

    public static final HTTPResponseHeader parse(InputStream __in) throws IOException, NullPointerException {
        if (__in == null) {
            throw new NullPointerException("NARG");
        }
        int rcode = -1;
        String rmesg = "";
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        StringBuilder sb = new StringBuilder();
        int ln = 0;
        while (true) {
            int c2;
            sb.setLength(0);
            boolean cr2 = false;
            while ((c2 = __in.read()) >= 0) {
                if (c2 == 13) {
                    cr2 = true;
                    continue;
                }
                if (cr2 && c2 == 10) break;
                sb.append((char)c2);
                cr2 = false;
            }
            if (sb.length() <= 0) break;
            String line = sb.toString();
            if (ln == 0) {
                if (!line.startsWith("HTTP/1.0 ") && !line.startsWith("HTTP/1.1 ")) {
                    throw new IOException("EC09 " + line);
                }
                line = line.substring(9);
                try {
                    int sp = line.indexOf(32);
                    if (sp >= 0) {
                        rcode = Integer.parseInt(line.substring(0, sp), 10);
                        rmesg = line.substring(sp + 1);
                    }
                    rcode = Integer.parseInt(line.substring(0, sp), 10);
                    rmesg = "";
                }
                catch (NumberFormatException e2) {
                    throw new IOException("EC0a " + line);
                }
            } else {
                int lc = line.indexOf(58);
                if (lc < 0) {
                    throw new IOException("EC0b " + line);
                }
                headers.put(line.substring(0, lc), line.substring(lc + 1));
            }
            ++ln;
        }
        return new HTTPResponseHeader(rcode, rmesg, headers);
    }
}

