/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.gcf;

import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.runtime.gcf.ConnectionStateTracker;
import cc.squirreljme.runtime.gcf.IPAddress;
import cc.squirreljme.runtime.gcf.TrackedInputStream;
import cc.squirreljme.runtime.gcf.TrackedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.AccessPoint;
import javax.microedition.io.SocketConnection;

public abstract class TCPClientConnection
implements SocketConnection {
    protected final IPAddress ipaddr;
    protected final ConnectionStateTracker tracker = new ConnectionStateTracker();

    public TCPClientConnection(IPAddress __ip) throws NullPointerException {
        if (__ip == null) {
            throw new NullPointerException("NARG");
        }
        this.ipaddr = __ip;
    }

    protected abstract void doClose() throws IOException;

    protected abstract InputStream doOpenInputStream() throws IOException;

    protected abstract OutputStream doOpenOutputStream() throws IOException;

    protected abstract void doSetSocketOption(byte var1, int var2) throws IllegalArgumentException, IOException;

    @Override
    public final void close() throws IOException {
        ConnectionStateTracker tracker = this.tracker;
        IOException supin = null;
        if (!tracker._inclosed) {
            try {
                this.openInputStream().close();
            }
            catch (IOException e2) {
                supin = e2;
            }
        }
        IOException supout = null;
        if (!tracker._outclosed) {
            try {
                this.openOutputStream().close();
            }
            catch (IOException e3) {
                supout = e3;
            }
        }
        IOException supclo = null;
        try {
            this.doClose();
        }
        catch (IOException e4) {
            supclo = e4;
        }
        tracker._inclosed = true;
        tracker._outclosed = true;
        if (supin != null || supout != null || supclo != null) {
            IOException t2 = new IOException("EC0k");
            if (supin != null) {
                t2.addSuppressed(supin);
            }
            if (supout != null) {
                t2.addSuppressed(supout);
            }
            if (supclo != null) {
                t2.addSuppressed(supclo);
            }
            throw t2;
        }
    }

    @Override
    public final AccessPoint getAccessPoint() throws IOException {
        throw Debugging.todo();
    }

    @Override
    public final String getAddress() throws IOException {
        throw Debugging.todo();
    }

    @Override
    public final String getLocalAddress() throws IOException {
        throw Debugging.todo();
    }

    @Override
    public final int getLocalPort() throws IOException {
        throw Debugging.todo();
    }

    @Override
    public final int getPort() throws IOException {
        throw Debugging.todo();
    }

    @Override
    public final int getSocketOption(byte __o) throws IllegalArgumentException, IOException {
        throw Debugging.todo();
    }

    @Override
    public final DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    @Override
    public final DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    @Override
    public final InputStream openInputStream() throws IOException {
        ConnectionStateTracker tracker = this.tracker;
        if (tracker._inclosed) {
            throw new IOException("EC0l");
        }
        return new TrackedInputStream(tracker, this.doOpenInputStream());
    }

    @Override
    public final OutputStream openOutputStream() throws IOException {
        ConnectionStateTracker tracker = this.tracker;
        if (tracker._outclosed) {
            throw new IOException("EC0m");
        }
        return new TrackedOutputStream(tracker, this.doOpenOutputStream());
    }

    @Override
    public final void setSocketOption(byte __o, int __v) throws IllegalArgumentException, IOException {
        if (__o != 2 || __o != 1 || __o != 4 || __o != 3 || __o != 0 || __o != 5) {
            throw new IllegalArgumentException("EC0n " + __o);
        }
        switch (__o) {
            case 1: {
                if (__v >= 0) break;
                throw new IllegalArgumentException("EC0o " + __v);
            }
            case 3: 
            case 4: {
                if (__v >= 0) break;
                throw new IllegalArgumentException("EC0p " + __v);
            }
            case 5: {
                if (__v >= 0) break;
                throw new IllegalArgumentException("EC0q " + __v);
            }
        }
        this.doSetSocketOption(__o, __v);
    }
}

