/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.launcher.ui;

import cc.squirreljme.jvm.launch.Application;
import cc.squirreljme.jvm.launch.SuiteScanner;
import cc.squirreljme.jvm.mle.BucketShelf;
import cc.squirreljme.jvm.mle.RuntimeShelf;
import cc.squirreljme.jvm.mle.brackets.TaskBracket;
import cc.squirreljme.jvm.mle.exceptions.MLECallError;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.runtime.launcher.ui.SearchOrder;
import cc.squirreljme.runtime.launcher.ui.SplashScreen;
import cc.squirreljme.runtime.launcher.ui.__ActiveTask__;
import cc.squirreljme.runtime.launcher.ui.__ProgressListener__;
import cc.squirreljme.runtime.launcher.ui.__ReControlTask__;
import cc.squirreljme.runtime.launcher.ui.__RefreshState__;
import cc.squirreljme.runtime.launcher.ui.__Refresher__;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class MidletMain
extends MIDlet {
    public static final String AUTOLAUNCH_PROPERTY = "cc.squirreljme.autolaunch";
    public static final Command EXIT_COMMAND = new Command("Exit", 7, 1);
    public static final Command ABOUT_COMMAND = new Command("About", 5, 2);
    public static final Command BROWSE_LIBRARY_COMMAND = new Command("Browse Library", 8, 99);
    static final Timer _TIMER = new Timer("LauncherRecoverThread");
    static volatile Display _MAIN_DISPLAY;
    protected final List programList = new List("SquirrelJME Launcher", 3);
    private final __ActiveTask__ _activeTask = new __ActiveTask__();
    final ArrayList<Application> _listedSuites = new ArrayList();
    private final __RefreshState__ _refreshState = new __RefreshState__();
    private volatile long _endTime;
    private volatile String _autoLaunch;
    volatile boolean _refreshLock;

    public MidletMain() {
        String al2 = null;
        try {
            al2 = System.getProperty(AUTOLAUNCH_PROPERTY);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this._autoLaunch = al2;
    }

    @Override
    protected void destroyApp(boolean __uc) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(SplashScreen __refreshCanvas) {
        Object programList;
        MidletMain midletMain = this;
        synchronized (midletMain) {
            if (this._refreshLock) {
                return;
            }
            this._refreshLock = true;
        }
        __RefreshState__ refreshState = this._refreshState;
        Display mainDisplay = _MAIN_DISPLAY;
        try {
            __ProgressListener__ handler;
            programList = this.programList;
            ((Displayable)programList).setTitle("Querying Suites...");
            ((List)programList).deleteAll();
            MidletMain midletMain2 = this;
            synchronized (midletMain2) {
                ArrayList<Application> listedSuites = this._listedSuites;
                listedSuites.clear();
                handler = new __ProgressListener__((List)programList, listedSuites, __refreshCanvas, refreshState, mainDisplay);
            }
            new SuiteScanner(true).scanSuites(handler);
            ((Displayable)programList).setTitle("SquirrelJME Launcher");
        }
        finally {
            programList = this;
            synchronized (programList) {
                this._refreshLock = false;
            }
        }
        if (mainDisplay != null) {
            String autoLaunch;
            long endTime = this._endTime;
            long nowTime = System.nanoTime();
            while (nowTime < endTime) {
                try {
                    Debugging.debugNote("Stalling...");
                    Thread.sleep((endTime - nowTime) / 1000000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                nowTime = System.nanoTime();
            }
            Displayable current = mainDisplay.getCurrent();
            if (current == null || current instanceof SplashScreen) {
                mainDisplay.setCurrent(this.programList);
            }
            if ((autoLaunch = this._autoLaunch) != null) {
                this._autoLaunch = null;
                Debugging.debugNote("Auto-launching " + autoLaunch + "...");
                this.__launch(autoLaunch);
            }
        }
    }

    @Override
    protected void startApp() {
        Display display;
        _MAIN_DISPLAY = display = Display.getDisplay(this);
        List programList = this.programList;
        programList.addCommand(EXIT_COMMAND);
        programList.addCommand(ABOUT_COMMAND);
        programList.addCommand(BROWSE_LIBRARY_COMMAND);
        __CommandHandler__ ch2 = new __CommandHandler__();
        programList.setCommandListener(ch2);
        this._endTime = System.nanoTime() + 1000000000L;
        SplashScreen spl = new SplashScreen(display.getWidth(), display.getHeight(), this._refreshState);
        __Refresher__ refresher = new __Refresher__(this, spl);
        refresher.start();
        if (display.getCurrent() == null) {
            display.setCurrent(spl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __launch(Application __p) throws NullPointerException {
        __ActiveTask__ activeTask;
        if (__p == null) {
            throw new NullPointerException("NARG");
        }
        this.programList.setTitle("Launching " + __p.displayName() + "...");
        __ActiveTask__ __ActiveTask__2 = activeTask = this._activeTask;
        synchronized (__ActiveTask__2) {
            activeTask._task = __p.launch();
        }
        this.programList.setTitle("SquirrelJME Launcher");
        _TIMER.schedule((TimerTask)new __ReControlTask__(_MAIN_DISPLAY, activeTask), 2000L, 2000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __launch(int __p) {
        Application app;
        MidletMain midletMain = this;
        synchronized (midletMain) {
            ArrayList<Application> programs = this._listedSuites;
            if (__p < 0 || __p >= programs.size()) {
                return;
            }
            app = programs.get(__p);
        }
        this.__launch(app);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __launch(String __p) throws NullPointerException {
        Application[] apps;
        if (__p == null) {
            throw new NullPointerException("NARG");
        }
        MidletMain midletMain = this;
        synchronized (midletMain) {
            ArrayList<Application> arrayList = this._listedSuites;
            apps = arrayList.toArray(new Application[arrayList.size()]);
        }
        HashMap<SearchOrder, Application> found = new HashMap<SearchOrder, Application>();
        for (Application application : apps) {
            if (Objects.equals(__p, application.displayName())) {
                found.put(SearchOrder.DISPLAY_NAME, application);
                continue;
            }
            if (Objects.equals(__p, application.entryPoint().entryPoint())) {
                found.put(SearchOrder.MAIN_CLASS, application);
                continue;
            }
            if (Objects.equals(__p, application.entryPoint().name())) {
                found.put(SearchOrder.SUITE_NAME, application);
                continue;
            }
            if (!Objects.equals(__p, application.squirrelJMEName())) continue;
            found.put(SearchOrder.SQUIRRELJME_NAME, application);
        }
        for (SearchOrder searchOrder : SearchOrder.values()) {
            Application app = (Application)found.get((Object)searchOrder);
            if (app == null) continue;
            this.__launch(app);
            return;
        }
        try {
            this.__launch(Integer.parseInt(__p));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private final class __CommandHandler__
    implements CommandListener {
        private __CommandHandler__() {
        }

        @Override
        public final void commandAction(Command __c, Displayable __d) {
            if (__c == List.SELECT_COMMAND) {
                List list = (List)__d;
                int selDx = list.getSelectedIndex();
                if (list.size() <= 0 || selDx < 0) {
                    return;
                }
                MidletMain.this.__launch(selDx);
            } else if (__c == EXIT_COMMAND) {
                MidletMain.this.programList.setTitle("Exiting...");
                TaskBracket task = ((MidletMain)MidletMain.this)._activeTask._task;
                if (task != null) {
                    Debugging.todoNote("Kill task on exit.");
                }
                System.exit(0);
            } else if (__c == ABOUT_COMMAND) {
                Debugging.todoNote("Show about screen.");
            } else if (__c == BROWSE_LIBRARY_COMMAND) {
                try {
                    RuntimeShelf.browseLocal(true, BucketShelf.path(BucketShelf.bucket(1)));
                }
                catch (MLECallError __e) {
                    __e.printStackTrace();
                }
            }
        }
    }
}

