/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.launcher.ui;

import cc.squirreljme.jvm.mle.scritchui.ScritchLAFInterface;
import cc.squirreljme.runtime.launcher.ui.SplashScreen;
import cc.squirreljme.runtime.lcdui.mle.PencilGraphics;
import cc.squirreljme.runtime.lcdui.scritchui.DisplayManager;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SplashScreenImage {
    public static final String COPYRIGHT = "https://squirreljme.cc/\n(C) 2013-2025 Stephanie Gawroriski\nTM  2016-2025 Stephanie Gawroriski\nLicense: Mozilla Public License 2.0!\nDonate to me on Patreon:\n*** https://www.patreon.com/SquirrelJME! ***";
    public static final int HEIGHT = 320;
    public static final int WIDTH = 240;
    private final Font _verFont;
    public final int endColor;
    public final int startColor;
    final int _verHeight;
    private final Font _copyFont;
    private final int _copyX;
    private final int _copyY;
    private final int _loadingBarY;
    private final int _loadingStrX;
    private final int _loadingStrY;

    public SplashScreenImage() {
        ScritchLAFInterface laf = DisplayManager.instance().scritch().environment().lookAndFeel();
        this.startColor = 0xFF000000 | laf.lafElementColor(null, 9);
        this.endColor = 0xFF000000 | laf.lafElementColor(null, 10);
        int width = 240;
        int height = 320;
        int centerX = width / 2;
        int centerY = height / 2;
        Font verFont = Font.getFont("sansserif", 0, 16);
        int verHeight = verFont.getPixelSize();
        this._verFont = verFont;
        this._verHeight = verHeight;
        this._copyFont = Font.getFont("sansserif", 0, 12);
        this._copyX = 2;
        this._copyY = height - this._copyFont.getHeight() * 6;
        int loadingBarY = centerY + height / 8 + verHeight / 2;
        if (loadingBarY + 16 >= this._copyY) {
            loadingBarY = this._copyY - 24;
        }
        this._loadingBarY = loadingBarY;
        this._loadingStrX = centerX;
        this._loadingStrY = loadingBarY + verHeight / 2;
    }

    public int[] generateSplash() {
        int np = 76800;
        int[] image = new int[np];
        Graphics g2 = PencilGraphics.hardwareGraphics(1, 240, 320, image, null, 0, 0, 240, 320);
        try (InputStream relaxedIn = SplashScreen.class.getResourceAsStream("relaxedpixel.xpm");
             InputStream logoIn = SplashScreen.class.getResourceAsStream("logo.xpm");){
            Image relaxedPixel = Image.createImage(relaxedIn);
            Image logoPixel = Image.createImage(logoIn);
            SplashScreenImage.drawGradient(g2, this.startColor, this.endColor, 240, 320);
            g2.setBlendingMode(0);
            g2.drawImage(relaxedPixel, 120, 320, 33);
            g2.drawImage(logoPixel, 120, 0, 17);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        this.drawCopyright(g2, false);
        return image;
    }

    public void drawCopyright(Graphics __g, boolean __swip) throws NullPointerException {
        if (__g == null) {
            throw new NullPointerException("NARG");
        }
        __g.setAlphaColor(255, 0, 0, 0);
        __g.setFont(this._verFont);
        __g.drawString("0.3.0", 238, 48, 24);
        if (__swip) {
            __g.drawString("SquirrelJME", 2, 2, 20);
            __g.drawString("Loading...", this._loadingStrX, this._loadingStrY, 3);
        }
        __g.setFont(this._copyFont);
        int copyX = this._copyX;
        int copyY = this._copyY;
        __g.setColor(0);
        __g.drawString(COPYRIGHT, copyX - 1, copyY, 36);
        __g.drawString(COPYRIGHT, copyX + 1, copyY, 36);
        __g.drawString(COPYRIGHT, copyX, copyY - 1, 36);
        __g.drawString(COPYRIGHT, copyX, copyY + 1, 36);
        __g.setColor(0xFFFFFF);
        __g.drawString(COPYRIGHT, copyX, copyY, 36);
    }

    public static void drawGradient(Graphics __g, int __startColor, int __endColor, int __width, int __height) {
        int atR = (__startColor >>> 16 & 0xFF) << 8;
        int atG = (__startColor >>> 8 & 0xFF) << 8;
        int atB = (__startColor & 0xFF) << 8;
        int addR = (((__endColor >>> 16 & 0xFF) << 8) - atR) / __height;
        int addG = (((__endColor >>> 8 & 0xFF) << 8) - atG) / __height;
        int addB = (((__endColor & 0xFF) << 8) - atB) / __height;
        for (int y2 = 0; y2 < __height; ++y2) {
            __g.setAlphaColor(255, atR >>> 8, atG >>> 8, atB >>> 8);
            __g.drawLine(0, y2, __width, y2);
            atR += addR;
            atG += addG;
            atB += addB;
        }
    }
}

