/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.launcher.ui;

import cc.squirreljme.jvm.launch.Application;
import cc.squirreljme.jvm.launch.SuiteScanListener;
import cc.squirreljme.runtime.launcher.ui.SplashScreen;
import cc.squirreljme.runtime.launcher.ui.__ApplicationComparator__;
import cc.squirreljme.runtime.launcher.ui.__RefreshState__;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import org.freedesktop.tango.TangoIconLoader;

final class __ProgressListener__
implements SuiteScanListener {
    private static final short _SCALE_SHIFT = 8;
    private static final short _SCALE_MASK = 255;
    protected final ArrayList<Application> listedSuites;
    protected final List programList;
    protected final Display mainDisplay;
    private final Comparator<Application> _comparator = new __ApplicationComparator__();
    protected final SplashScreen refreshCanvas;
    protected final __RefreshState__ refreshState;
    private final Set<Integer> _processedIndex;
    protected volatile Image _defaultIcon;

    public __ProgressListener__(List __programList, ArrayList<Application> __listedSuites, SplashScreen __refreshCanvas, __RefreshState__ __refreshState, Display __mainDisplay) throws NullPointerException {
        if (__programList == null || __listedSuites == null) {
            throw new NullPointerException("NARG");
        }
        this.programList = __programList;
        this.listedSuites = __listedSuites;
        this.refreshCanvas = __refreshCanvas;
        this.refreshState = __refreshState;
        this.mainDisplay = __mainDisplay;
        this._processedIndex = new HashSet<Integer>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scanned(Application __app, int __dx, int __total) {
        if (__app.isNoLauncher()) {
            return;
        }
        ArrayList<Application> listedSuites = this.listedSuites;
        List programList = this.programList;
        this.__counter(__dx, __total);
        Image icon = null;
        try (InputStream iconData = __app.iconStream();){
            icon = iconData != null ? Image.createImage(iconData) : this.__defaultIcon();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        if (icon != null) {
            int prefH;
            int prefW;
            Display mainDisplay = this.mainDisplay;
            if (mainDisplay == null) {
                try {
                    mainDisplay = Display.getDisplays(0)[0];
                }
                catch (IllegalStateException ignored) {
                    mainDisplay = null;
                }
            }
            if (mainDisplay != null) {
                prefW = mainDisplay.getBestImageWidth(1);
                prefH = mainDisplay.getBestImageHeight(1);
            } else {
                prefH = 16;
                prefW = 16;
            }
            if (icon.getWidth() > prefW || icon.getHeight() > prefH) {
                try {
                    boolean isDefault = icon == this._defaultIcon;
                    icon = __ProgressListener__.__scaleIcon(icon, prefW, prefH);
                    if (isDefault) {
                        this._defaultIcon = icon;
                    }
                }
                catch (IndexOutOfBoundsException e3) {
                    e3.printStackTrace();
                }
            }
        }
        ArrayList<Application> arrayList = listedSuites;
        synchronized (arrayList) {
            int at2;
            if (listedSuites.isEmpty()) {
                at2 = 0;
            } else {
                at2 = Collections.binarySearch(listedSuites, __app, this._comparator);
                if (at2 < 0) {
                    at2 = -(at2 + 1);
                }
            }
            listedSuites.add(at2, __app);
            List list = programList;
            synchronized (list) {
                programList.insert(at2, __app.displayName(), icon);
            }
        }
    }

    @Override
    public void skipped(int __dx, int __total) {
        this.__counter(__dx, __total);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __counter(int __dx, int __total) {
        int processed;
        SplashScreen refreshCanvas = this.refreshCanvas;
        __RefreshState__ refreshState = this.refreshState;
        Set<Integer> processedIndex = this._processedIndex;
        __ProgressListener__ __ProgressListener__2 = this;
        synchronized (__ProgressListener__2) {
            processedIndex.add(__dx);
            processed = processedIndex.size();
        }
        String updateMessage = String.format("Querying Suites (Found %d of %d)...", processed, __total);
        List programList = this.programList;
        Object object = programList;
        synchronized (object) {
            programList.setTitle(updateMessage);
        }
        object = refreshState;
        synchronized (object) {
            refreshState.set(updateMessage, processed, __total);
            if (refreshCanvas != null) {
                SplashScreen splashScreen = refreshCanvas;
                synchronized (splashScreen) {
                    refreshCanvas.requestRepaint();
                }
            }
        }
    }

    private Image __defaultIcon() throws IOException {
        Image defaultIcon = this._defaultIcon;
        if (defaultIcon != null) {
            return defaultIcon;
        }
        try (InputStream in = TangoIconLoader.loadIcon(16, "application-x-executable");){
            if (in == null) {
                Image image = null;
                return image;
            }
            this._defaultIcon = defaultIcon = Image.createImage(in);
            Image image = defaultIcon;
            return image;
        }
    }

    private static Image __scaleIcon(Image __icon, int __prefW, int __prefH) throws NullPointerException {
        if (__icon == null) {
            throw new NullPointerException("NARG");
        }
        int srcW = __icon.getWidth();
        int srcH = __icon.getHeight();
        int scaleX = (srcW << 8) / __prefW;
        int scaleY = (srcH << 8) / __prefH;
        int[] src = new int[srcW * srcH];
        __icon.getRGB(src, 0, srcW, 0, 0, srcW, srcH);
        int[] dest = new int[__prefW * __prefH];
        int destY = 0;
        int baseSrcY = 0;
        while (destY < __prefH) {
            int srcI = srcW * (baseSrcY & 0xFFFFFF00);
            int destI = __prefW * destY;
            int endDestI = destI + __prefW;
            while (destI < endDestI) {
                dest[destI] = src[srcI >>> 8];
                ++destI;
                srcI += scaleX;
            }
            ++destY;
            baseSrcY += scaleY;
        }
        return Image.createRGBImage(dest, __prefW, __prefH, __icon.hasAlpha());
    }
}

