/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.lcdui.gfx;

import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.lcdui.gfx.ProxyGraphics;
import cc.squirreljme.runtime.lcdui.gfx.ProxyGraphicsTarget;
import cc.squirreljme.runtime.lcdui.gfx.SingleBuffer;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

@SquirrelJMEVendorApi
public final class DoubleBuffer {
    private final ProxyGraphicsTarget _offScreenProxy = new ProxyGraphicsTarget(Image.createImage(1, 1).getGraphics());
    private final SingleBuffer _offScreen;
    private final SingleBuffer _onScreen;
    private volatile int _lastWidth = -1;
    private volatile int _lastHeight = -1;

    @SquirrelJMEVendorApi
    public DoubleBuffer(int __resizeFillColor) {
        this._offScreen = new SingleBuffer(__resizeFillColor);
        this._onScreen = new SingleBuffer(__resizeFillColor);
    }

    @SquirrelJMEVendorApi
    public void clear() {
        this._offScreen.clear();
    }

    @SquirrelJMEVendorApi
    public void flush() {
        this._onScreen.copyFrom(this._offScreen, 0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @SquirrelJMEVendorApi
    public void flush(int __x, int __y, int __w, int __h) {
        this._onScreen.copyFrom(this._offScreen, __x, __y, __w, __h);
    }

    @SquirrelJMEVendorApi
    public Graphics getGraphics(int __width, int __height) throws IllegalArgumentException {
        if (__width <= 0 || __height <= 0) {
            throw new IllegalArgumentException("EB32");
        }
        ProxyGraphicsTarget proxy = this._offScreenProxy;
        ProxyGraphics rv = new ProxyGraphics(proxy, __width, __height);
        int lastWidth = this._lastWidth;
        int lastHeight = this._lastHeight;
        if (__width == lastWidth && __height == lastHeight) {
            return rv;
        }
        proxy.setGraphics(this._offScreen.getGraphics(__width, __height));
        this._lastWidth = __width;
        this._lastHeight = __height;
        return rv;
    }

    @SquirrelJMEVendorApi
    public int height() {
        return Math.max(0, this._lastHeight);
    }

    @SquirrelJMEVendorApi
    public void paint(Graphics __g) {
        this._onScreen.paint(__g);
    }

    @SquirrelJMEVendorApi
    public int width() {
        return Math.max(0, this._lastWidth);
    }
}

