/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.lcdui.gfx;

import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.runtime.lcdui.gfx.ProxyGraphicsTarget;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Text;

public final class ProxyGraphics
extends Graphics {
    protected final ProxyGraphicsTarget target;
    private int _argbColor;
    private int _blendingMode;
    private int _clipHeight;
    private int _clipWidth;
    private int _clipX;
    private int _clipY;
    private Font _font;
    private int _strokeStyle;
    private int _transX;
    private int _transY;

    public ProxyGraphics(ProxyGraphicsTarget __target, int __width, int __height) throws NullPointerException {
        if (__target == null) {
            throw new NullPointerException("NARG");
        }
        this.target = __target;
        this._clipWidth = __width;
        this._clipHeight = __height;
    }

    @Override
    public void clipRect(int __a, int __b, int __c, int __d) {
        throw Debugging.todo();
    }

    @Override
    public void copyArea(int __a, int __b, int __c, int __d, int __e, int __f, int __g) {
        this.__graphics().copyArea(__a, __b, __c, __d, __e, __f, __g);
    }

    @Override
    public void drawArc(int __a, int __b, int __c, int __d, int __e, int __f) {
        this.__graphics().drawArc(__a, __b, __c, __d, __e, __f);
    }

    @Override
    public void drawARGB16(short[] __data, int __off, int __scanlen, int __x, int __y, int __w, int __h) {
        this.__graphics().drawARGB16(__data, __off, __scanlen, __x, __y, __w, __h);
    }

    @Override
    public void drawChar(char __a, int __b, int __c, int __d) {
        this.__graphics().drawChar(__a, __b, __c, __d);
    }

    @Override
    public void drawChars(char[] __a, int __b, int __c, int __d, int __e, int __f) {
        this.__graphics().drawChars(__a, __b, __c, __d, __e, __f);
    }

    @Override
    public void drawImage(Image __a, int __b, int __c, int __d) {
        this.__graphics().drawImage(__a, __b, __c, __d);
    }

    @Override
    public void drawLine(int __a, int __b, int __c, int __d) {
        this.__graphics().drawLine(__a, __b, __c, __d);
    }

    @Override
    public void drawRGB(int[] __a, int __b, int __c, int __d, int __e, int __f, int __g, boolean __h) {
        this.__graphics().drawRGB(__a, __b, __c, __d, __e, __f, __g, __h);
    }

    @Override
    public void drawRGB16(short[] __data, int __off, int __scanlen, int __x, int __y, int __w, int __h) {
        this.__graphics().drawRGB16(__data, __off, __scanlen, __x, __y, __w, __h);
    }

    @Override
    public void drawRect(int __a, int __b, int __c, int __d) {
        this.__graphics().drawRect(__a, __b, __c, __d);
    }

    @Override
    public void drawRegion(Image __a, int __b, int __c, int __d, int __e, int __f, int __g, int __h, int __i) {
        this.__graphics().drawRegion(__a, __b, __c, __d, __e, __f, __g, __h, __i);
    }

    @Override
    public void drawRegion(Image __src, int __xsrc, int __ysrc, int __w, int __h, int __trans, int __xdest, int __ydest, int __anch, int __wdest, int __hdest) {
        this.__graphics().drawRegion(__src, __xsrc, __ysrc, __w, __h, __trans, __xdest, __ydest, __anch, __wdest, __hdest);
    }

    @Override
    public void drawRoundRect(int __a, int __b, int __c, int __d, int __arcWidth, int __arcHeight) {
        this.__graphics().drawRoundRect(__a, __b, __c, __d, __arcWidth, __arcHeight);
    }

    @Override
    public void drawString(String __a, int __b, int __c, int __d) {
        this.__graphics().drawString(__a, __b, __c, __d);
    }

    @Override
    public void drawSubstring(String __a, int __b, int __c, int __d, int __e, int __f) {
        this.__graphics().drawSubstring(__a, __b, __c, __d, __e, __f);
    }

    @Override
    public void drawText(Text __t, int __x, int __y) {
        this.__graphics().drawText(__t, __x, __y);
    }

    @Override
    public void fillArc(int __a, int __b, int __c, int __d, int __e, int __f) {
        this.__graphics().fillArc(__a, __b, __c, __d, __e, __f);
    }

    @Override
    public void fillRect(int __x, int __y, int __w, int __h) {
        this.__graphics().fillRect(__x, __y, __w, __h);
    }

    @Override
    public void fillRoundRect(int __a, int __b, int __c, int __d, int __arcWidth, int __arcHeight) {
        this.__graphics().fillRoundRect(__a, __b, __c, __d, __arcWidth, __arcHeight);
    }

    @Override
    public void fillTriangle(int __a, int __b, int __c, int __d, int __e, int __f) {
        this.__graphics().fillTriangle(__a, __b, __c, __d, __e, __f);
    }

    @Override
    public int getAlpha() {
        return this._argbColor >> 24 & 0xFF;
    }

    @Override
    public int getAlphaColor() {
        return this._argbColor;
    }

    @Override
    public int getBlendingMode() {
        return this._blendingMode;
    }

    @Override
    public int getBlueComponent() {
        return this._argbColor & 0xFF;
    }

    @Override
    public int getClipHeight() {
        return this._clipHeight;
    }

    @Override
    public int getClipWidth() {
        return this._clipWidth;
    }

    @Override
    public int getClipX() {
        return this._clipX - this._transX;
    }

    @Override
    public int getClipY() {
        return this._clipY - this._transY;
    }

    @Override
    public int getColor() {
        return this._argbColor & 0xFFFFFF;
    }

    @Override
    public int getDisplayColor(int __a) {
        return this.__graphics().getDisplayColor(__a);
    }

    @Override
    public Font getFont() {
        return this.__font();
    }

    @Override
    public int getGrayScale() {
        return ((this._argbColor >> 16 & 0xFF) + (this._argbColor >> 8 & 0xFF) + (this._argbColor & 0xFF)) / 3;
    }

    @Override
    public int getGreenComponent() {
        return this._argbColor >> 8 & 0xFF;
    }

    @Override
    public int getRedComponent() {
        return this._argbColor >> 16 & 0xFF;
    }

    @Override
    public int getStrokeStyle() {
        return this._strokeStyle;
    }

    @Override
    public int getTranslateX() {
        return this._transX;
    }

    @Override
    public int getTranslateY() {
        return this._transY;
    }

    @Override
    public void setAlpha(int __a) {
        this.setAlphaColor(__a, this.getRedComponent(), this.getGreenComponent(), this.getBlueComponent());
    }

    @Override
    public void setAlphaColor(int __argb) {
        this._argbColor = __argb;
    }

    @Override
    public void setAlphaColor(int __a, int __r, int __g, int __b) {
        if (__a < 0 || __a > 255 || __r < 0 || __r > 255 || __g < 0 || __g > 255 || __b < 0 || __b > 255) {
            throw new IllegalArgumentException(String.format("EB2y %d %d %d %d", __a, __r, __g, __b));
        }
        this.setAlphaColor(__a << 24 | __r << 16 | __g << 8 | __b);
    }

    @Override
    public void setBlendingMode(int __m) {
        if (__m != 1 && __m != 0) {
            throw new IllegalArgumentException("EB2x " + __m);
        }
        this._blendingMode = __m;
    }

    @Override
    public void setClip(int __x, int __y, int __w, int __h) {
        int temp;
        int startX = __x + this._transX;
        int startY = __y + this._transY;
        int endX = startX + __w;
        int endY = startY + __h;
        if (endX < startX) {
            temp = endX;
            endX = startX;
            startX = temp;
        }
        if (endY < startY) {
            temp = endY;
            endY = startY;
            startY = temp;
        }
        int clipX = Math.max(0, startX);
        int clipY = Math.max(0, startY);
        int clipEndX = Math.max(0, endX);
        int clipEndY = Math.max(0, endY);
        this._clipX = clipX;
        this._clipY = clipY;
        this._clipWidth = clipEndX - clipX;
        this._clipHeight = clipEndY - clipY;
    }

    @Override
    public void setColor(int __rgb) {
        this.setAlphaColor(this.getAlphaColor() & 0xFF000000 | __rgb & 0xFFFFFF);
    }

    @Override
    public void setColor(int __r, int __g, int __b) {
        this.setAlphaColor(this.getAlpha(), __r, __g, __b);
    }

    @Override
    public void setFont(Font __font) {
        this.__graphics().setFont(__font);
    }

    @Override
    public void setGrayScale(int __v) {
        this.setAlphaColor(this.getAlpha(), __v, __v, __v);
    }

    @Override
    public void setStrokeStyle(int __style) {
        if (__style != 0 && __style != 1) {
            throw new IllegalArgumentException("EB2z");
        }
        this._strokeStyle = __style;
    }

    @Override
    public void translate(int __x, int __y) {
        this._transX += __x;
        this._transY += __y;
    }

    private Font __font() {
        Font rv = this._font;
        if (rv == null) {
            rv = Font.getDefaultFont();
        }
        return rv;
    }

    private Graphics __graphics() {
        Graphics target = this.target._target;
        target.setAlphaColor(this._argbColor);
        target.setBlendingMode(this._blendingMode);
        target.setFont(this.__font());
        target.setStrokeStyle(this._strokeStyle);
        int targetTransX = target.getTranslateX();
        int targetTransY = target.getTranslateY();
        target.setClip(this._clipX - targetTransX, this._clipY - targetTransY, this._clipWidth, this._clipHeight);
        target.translate(this._transX - targetTransX, this._transY - targetTransY);
        return target;
    }
}

