/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.lcdui.gfx;

import cc.squirreljme.jvm.mle.ObjectShelf;
import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.lcdui.mle.PencilGraphics;
import java.util.Arrays;
import javax.microedition.lcdui.Graphics;

@SquirrelJMEVendorApi
public final class SingleBuffer {
    private final int fillColor;
    private volatile int[] _pixels = new int[1];
    private volatile int _width = 1;
    private volatile int _height = 1;

    @SquirrelJMEVendorApi
    public SingleBuffer(int __resizeFillColor) {
        this.fillColor = __resizeFillColor;
    }

    @SquirrelJMEVendorApi
    public void clear() {
        Arrays.fill(this._pixels, this.fillColor);
    }

    @SquirrelJMEVendorApi
    public void copyFrom(SingleBuffer __source, int __x, int __y, int __w, int __h) throws NullPointerException {
        if (__source == null) {
            throw new NullPointerException("NARG");
        }
        if (__x < 0) {
            __x = 0;
        }
        if (__y < 0) {
            __y = 0;
        }
        int[] destPixels = this._pixels;
        int destLimit = destPixels.length;
        int[] srcPixels = __source._pixels;
        int srcWidth = __source._width;
        int srcHeight = __source._height;
        int srcArea = srcWidth * srcHeight;
        int ex = __x + __w;
        int ey = __y + __h;
        if (ex > srcWidth) {
            ex = srcWidth;
        }
        if (ey > srcHeight) {
            ey = srcHeight;
        }
        __w = ex - __x;
        __h = ey - __y;
        if (srcArea > destLimit) {
            this._pixels = Arrays.copyOf(srcPixels, srcArea);
        } else if (__x == 0 && __y == 0 && __w == srcWidth && __h == srcHeight) {
            ObjectShelf.arrayCopy(srcPixels, 0, destPixels, 0, srcArea);
        } else {
            int scanBase = __x;
            int y2 = __y;
            while (y2 < ey) {
                ObjectShelf.arrayCopy(srcPixels, scanBase, destPixels, scanBase, __w);
                ++y2;
                scanBase += srcWidth;
            }
        }
        this._width = srcWidth;
        this._height = srcHeight;
    }

    @SquirrelJMEVendorApi
    public Graphics getGraphics(int __width, int __height) throws IllegalArgumentException {
        if (__width <= 0 || __height <= 0) {
            throw new IllegalArgumentException("EB31");
        }
        int wantedArea = __width * __height;
        int[] pixels = this._pixels;
        int currentLimit = pixels.length;
        if (wantedArea > currentLimit) {
            this._pixels = pixels = new int[wantedArea];
            Arrays.fill(pixels, this.fillColor);
        }
        this._width = __width;
        this._height = __height;
        return PencilGraphics.hardwareGraphics(1, __width, __height, pixels, null, 0, 0, __width, __height);
    }

    @SquirrelJMEVendorApi
    public void paint(Graphics __g) {
        int pw = this._width;
        __g.drawRGB(this._pixels, 0, pw, 0, 0, pw, this._height, false);
    }
}

