/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.lcdui.image;

import cc.squirreljme.jvm.mle.ObjectShelf;
import cc.squirreljme.jvm.mle.callbacks.NativeImageLoadCallback;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.runtime.cldc.util.StreamUtils;
import cc.squirreljme.runtime.lcdui.image.ImageReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import net.multiphasicapps.io.ByteDeque;
import net.multiphasicapps.io.CRC32Calculator;
import net.multiphasicapps.io.ChecksumInputStream;
import net.multiphasicapps.io.SizeLimitedInputStream;
import net.multiphasicapps.io.ZLibDecompressor;

public class PNGReader
implements ImageReader {
    protected final DataInputStream in;
    protected final NativeImageLoadCallback loader;
    private boolean _wantIndexed;
    private int _width;
    private int _scanlen;
    private int _height;
    private int _bitDepth;
    private int _colorType;
    private boolean _adamseven;
    private int[] _argb;
    private int[] _palette;
    private boolean _hasalpha;
    private int _initvy;
    private int _initvx;
    private int _numcolors;
    private int _maxcolors;

    public PNGReader(InputStream __in, NativeImageLoadCallback __loader) throws NullPointerException {
        if (__in == null || __loader == null) {
            throw new NullPointerException("NARG");
        }
        this.in = new DataInputStream(__in);
        this.loader = __loader;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void parse() throws IOException {
        block49: {
            in = this.in;
            loader = this.loader;
            if (in.readUnsignedByte() != 137 || in.readUnsignedByte() != 80 || in.readUnsignedByte() != 78 || in.readUnsignedByte() != 71 || in.readUnsignedByte() != 13 || in.readUnsignedByte() != 10 || in.readUnsignedByte() != 26 || in.readUnsignedByte() != 10) {
                throw new IOException("EB0t");
            }
            imageChunk = null;
            block27: do {
                if ((len = in.readInt()) < 0) {
                    throw new IOException("EB1l");
                }
                crc = new CRC32Calculator(true, true, 79764919, -1, -1);
                lasttype = 0;
                data = new DataInputStream(new SizeLimitedInputStream(new ChecksumInputStream(crc, in), len + 4, true, false));
                var8_14 = null;
                try {
                    lasttype = type = data.readInt();
                    if (type != 1229278788) {
                        switch (type) {
                            case 1229472850: {
                                this.__parseHeader(data);
                                ** break;
lbl20:
                                // 1 sources

                                continue block27;
                            }
                            case 1347179589: {
                                this.__parsePalette(data, len);
                                ** break;
lbl24:
                                // 1 sources

                                continue block27;
                            }
                            case 1229209940: {
                                if (imageChunk != null) {
                                    xtrachunk = PNGReader.__chunkLater(data);
                                    gn = imageChunk.length;
                                    xn = xtrachunk.length;
                                    nl = gn + xn;
                                    imageChunk = Arrays.copyOf(imageChunk, nl);
                                    ObjectShelf.arrayCopy(xtrachunk, 0, imageChunk, gn, xn);
                                    ** break;
lbl34:
                                    // 1 sources

                                    continue block27;
                                }
                                imageChunk = PNGReader.__chunkLater(data);
                                ** break;
lbl37:
                                // 1 sources

                                continue block27;
                            }
                            case 1951551059: {
                                this.__parseAlpha(data, len);
                                ** break;
lbl41:
                                // 1 sources

                                continue block27;
                            }
                            ** default:
lbl43:
                            // 1 sources

                            continue block27;
                        }
                    }
                    break block49;
                }
                catch (Throwable var9_17) {
                    var8_14 = var9_17;
                    throw var9_17;
                }
                finally {
                    if (data != null) {
                        if (var8_14 != null) {
                            try {
                                data.close();
                            }
                            catch (Throwable var10_21) {
                                var8_14.addSuppressed(var10_21);
                            }
                        } else {
                            data.close();
                        }
                    }
                }
            } while ((want = in.readInt()) == (real = crc.checksum()));
            throw new IOException(String.format("EB0u %08x %08x %08x", new Object[]{want, real, lasttype}));
        }
        argb = this._argb;
        if (argb == null) {
            throw new IOException("EB0v");
        }
        if (!this._hasalpha) {
            Arrays.fill(argb, -16777216);
            palette = this._palette;
            if (palette != null) {
                i = 0;
                n = palette.length;
                while (i < n) {
                    v0 = i++;
                    palette[v0] = palette[v0] | -16777216;
                }
            }
        }
        if (Integer.bitCount(bitdepth = this._bitDepth) != 1 || bitdepth > 8) {
            throw new IOException("EB0w " + bitdepth);
        }
        if (this._adamseven) {
            throw new IOException("EB0x");
        }
        if (this._colorType == 3 && this._palette == null) {
            throw new IOException("EB0y");
        }
        colorType = this._colorType;
        data = new ByteArrayInputStream(this.__unfilter(new ZLibDecompressor(new ByteArrayInputStream(imageChunk)), this.__determineUnfilterBpp()));
        var8_14 = null;
        try {
            if (colorType == 0 || colorType == 3) {
                this.__pixelIndexed(data, colorType == 3);
            } else if (colorType == 2 || colorType == 6) {
                this.__pixelsRGB(data, colorType == 6);
            } else {
                this.__pixelsYA(data);
            }
        }
        catch (Throwable var9_19) {
            var8_14 = var9_19;
            throw var9_19;
        }
        finally {
            if (data != null) {
                if (var8_14 != null) {
                    try {
                        data.close();
                    }
                    catch (Throwable var9_18) {
                        var8_14.addSuppressed(var9_18);
                    }
                } else {
                    data.close();
                }
            }
        }
        loader.initialize(this._width, this._height, false, false);
        loader.addImage(argb, 0, argb.length, 0, this._hasalpha);
    }

    private int __determineUnfilterBpp() {
        int colorType = this._colorType;
        int bitDepth = this._bitDepth;
        switch (colorType) {
            case 0: 
            case 3: {
                return PNGReader.__roundNumBitsToByte(bitDepth);
            }
            case 2: {
                return PNGReader.__roundNumBitsToByte(bitDepth * 3);
            }
            case 6: {
                return PNGReader.__roundNumBitsToByte(bitDepth * 4);
            }
        }
        return PNGReader.__roundNumBitsToByte(bitDepth * 2);
    }

    private void __parseAlpha(DataInputStream __in, int __dlen) throws IOException, NullPointerException {
        block6: {
            int val2;
            int numcolors;
            int colortype;
            int[] palette;
            block5: {
                int ign;
                int col;
                if (__in == null) {
                    throw new NullPointerException("NARG");
                }
                palette = this._palette;
                colortype = this._colorType;
                int numpals = palette != null ? palette.length : 0;
                numcolors = this._numcolors;
                this._hasalpha = true;
                if (colortype != 0) break block5;
                boolean at2 = false;
                while (((col = __in.read()) | (ign = __in.read())) >= 0) {
                    for (int p2 = 0; p2 < numpals; ++p2) {
                        if (palette[p2] != col) continue;
                        int n2 = p2;
                        palette[n2] = palette[n2] & 0xFFFFFF;
                    }
                }
                break block6;
            }
            if (colortype != 3) break block6;
            int i2 = 0;
            while (i2 < numcolors && (val2 = __in.read()) >= 0) {
                int n3 = i2++;
                palette[n3] = palette[n3] | (val2 & 0xFF) << 24;
            }
            while (i2 < numcolors) {
                int n4 = i2++;
                palette[n4] = palette[n4] | 0xFF000000;
            }
        }
    }

    private void __parseHeader(DataInputStream __in) throws IOException, NullPointerException {
        if (__in == null) {
            throw new NullPointerException("NARG");
        }
        int width = __in.readInt();
        if (width <= 0) {
            throw new IOException(String.format("EB0z %d", width));
        }
        this._width = width;
        int height = __in.readInt();
        if (height <= 0) {
            throw new IOException(String.format("EB10 %d", height));
        }
        this._height = height;
        Debugging.debugNote("Size: %dx%d%n", width, height);
        int bitdepth = __in.readUnsignedByte();
        int colortype = __in.readUnsignedByte();
        if (Integer.bitCount(bitdepth) != 1 || bitdepth < 0 || bitdepth > 16) {
            throw new IOException(String.format("EB11 %d", bitdepth));
        }
        if (bitdepth < 8 && colortype != 0 && colortype != 3 || bitdepth > 8 && colortype != 3) {
            throw new IOException(String.format("EB12 %d %d", colortype, bitdepth));
        }
        this._bitDepth = bitdepth;
        this._colorType = colortype;
        boolean hasalpha = colortype == 4 || colortype == 6;
        this._hasalpha = hasalpha;
        int channels = colortype == 0 || colortype == 3 ? 1 : (colortype == 2 ? 3 : (colortype == 4 ? 2 : (colortype == 6 ? 4 : 1)));
        this._scanlen = (width * channels * bitdepth + 7) / 8;
        int compressionmethod = __in.readUnsignedByte();
        if (compressionmethod != 0) {
            throw new IOException(String.format("EB13 %d", compressionmethod));
        }
        int filter = __in.readUnsignedByte();
        if (filter != 0) {
            throw new IOException(String.format("EB14 %d", filter));
        }
        int interlace = __in.readUnsignedByte();
        if (interlace != 0 && interlace != 1) {
            throw new IOException(String.format("EB15 %d", interlace));
        }
        this._adamseven = interlace == 1;
        this._argb = new int[width * height];
        if (colortype == 0) {
            int numcolors = 1 << bitdepth;
            int[] palette = new int[numcolors];
            for (int i2 = 0; i2 < numcolors; ++i2) {
                palette[i2] = (int)((double)i2 / (double)numcolors * 255.0) | 0xFF000000;
            }
            this._palette = palette;
        }
    }

    private void __parsePalette(DataInputStream __in, int __len) throws IOException, NullPointerException {
        if (__in == null) {
            throw new NullPointerException("NARG");
        }
        if (this._colorType != 3) {
            return;
        }
        int numColors = __len / 3;
        int maxColors = 1 << this._bitDepth;
        if (numColors > maxColors) {
            numColors = maxColors;
        }
        this._numcolors = numColors;
        this._maxcolors = maxColors;
        int[] palette = new int[maxColors];
        this._palette = palette;
        for (int i2 = 0; i2 < numColors; ++i2) {
            int r2 = __in.readUnsignedByte();
            int g2 = __in.readUnsignedByte();
            int b2 = __in.readUnsignedByte();
            palette[i2] = r2 << 16 | g2 << 8 | b2;
        }
        this._wantIndexed = this.loader.setPalette(palette, 0, maxColors, true, -1);
    }

    private void __pixelIndexed(InputStream __dis, boolean __idx) throws IOException, NullPointerException {
        int v2;
        if (__dis == null) {
            throw new NullPointerException("NARG");
        }
        int[] argb = this._argb;
        int[] palette = this._palette;
        int width = this._width;
        int height = this._height;
        int limit = width * height;
        int bitdepth = this._bitDepth;
        int bitmask = (1 << bitdepth) - 1;
        int numpals = palette != null ? palette.length : 0;
        int hishift = 8 - bitdepth;
        int himask = bitmask << hishift;
        boolean wantIndexed = this._wantIndexed;
        int o2 = 0;
        while ((v2 = __dis.read()) >= 0) {
            int b2 = 0;
            while (b2 < 8 && o2 < limit) {
                int index = ((v2 & himask) >>> hishift) % numpals;
                argb[o2++] = wantIndexed ? index : palette[index];
                b2 += bitdepth;
                v2 <<= bitdepth;
            }
        }
    }

    private void __pixelsRGB(InputStream __dis, boolean __alpha) throws IOException, NullPointerException {
        if (__dis == null) {
            throw new NullPointerException("NARG");
        }
        int[] argb = this._argb;
        int width = this._width;
        int height = this._height;
        int limit = width * height;
        for (int o2 = 0; o2 < limit; ++o2) {
            int a2;
            int r2 = __dis.read() & 0x800000FF;
            int g2 = __dis.read() & 0x800000FF;
            int b2 = __dis.read() & 0x800000FF;
            int n2 = a2 = __alpha ? __dis.read() & 0x800000FF : 255;
            if ((r2 | g2 | b2 | a2) < 0) break;
            argb[o2] = a2 << 24 | r2 << 16 | g2 << 8 | b2;
        }
    }

    private void __pixelsYA(InputStream __dis) throws IOException, NullPointerException {
        int y2;
        int a2;
        if (__dis == null) {
            throw new NullPointerException("NARG");
        }
        int[] argb = this._argb;
        int width = this._width;
        int height = this._height;
        int limit = width * height;
        int o2 = 0;
        while (o2 < limit && ((a2 = __dis.read() & 0x800000FF) | (y2 = __dis.read() & 0x800000FF)) >= 0) {
            argb[o2++] = a2 << 24 | y2 << 16 | y2 << 8 | y2;
        }
    }

    private byte[] __unfilter(InputStream __in, int __bpp) throws IOException, NullPointerException {
        if (__in == null) {
            throw new NullPointerException("NARG");
        }
        int scanLen = this._scanlen;
        int height = this._height;
        byte[] rv = new byte[scanLen * height];
        for (int dy = 0; dy < height; ++dy) {
            int ibase = scanLen * dy;
            int type = __in.read();
            if (type < 0 || type > 4) {
                throw new IOException(String.format("EB16 %d (%d, %d) %d [%d, %d]", type, 0, dy, scanLen, this._width, height));
            }
            for (int dx = 0; dx < scanLen; ++dx) {
                int vX = dx / __bpp;
                int di2 = ibase + dx;
                int x2 = __in.read() & 0xFF;
                int a2 = (vX <= 0 ? 0 : rv[di2 - __bpp]) & 0xFF;
                int b2 = (dy <= 0 ? 0 : rv[di2 - scanLen]) & 0xFF;
                int c2 = (vX <= 0 || dy <= 0 ? 0 : rv[di2 - scanLen - __bpp]) & 0xFF;
                int res = 0;
                switch (type) {
                    case 0: {
                        res = x2;
                        break;
                    }
                    case 1: {
                        res = x2 + a2;
                        break;
                    }
                    case 2: {
                        res = x2 + b2;
                        break;
                    }
                    case 3: {
                        res = x2 + (a2 + b2 >>> 1);
                        break;
                    }
                    case 4: {
                        int p2 = a2 + b2 - c2;
                        int pa = p2 - a2;
                        int pb = p2 - b2;
                        int pc = p2 - c2;
                        pa = pa < 0 ? -pa : pa;
                        pb = pb < 0 ? -pb : pb;
                        int n2 = pc = pc < 0 ? -pc : pc;
                        res = pa <= pb && pa <= pc ? x2 + a2 : (pb <= pc ? x2 + b2 : x2 + c2);
                    }
                }
                rv[di2] = (byte)res;
            }
        }
        return rv;
    }

    private static byte[] __chunkLater(InputStream __in) throws IOException, NullPointerException {
        int rc;
        if (__in == null) {
            throw new NullPointerException("NARG");
        }
        ByteDeque glue = new ByteDeque();
        byte[] buf = StreamUtils.buffer(__in);
        while ((rc = __in.read(buf, 0, buf.length)) >= 0) {
            glue.addLast(buf, 0, rc);
        }
        return glue.toByteArray();
    }

    private static int __roundNumBitsToByte(int __numBits) {
        return (__numBits >>> 3) + ((__numBits & 7) == 0 ? 0 : 1);
    }
}

