/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.lcdui.image;

import cc.squirreljme.jvm.mle.callbacks.NativeImageLoadCallback;
import cc.squirreljme.runtime.lcdui.image.ImageReader;
import cc.squirreljme.runtime.lcdui.image.NotAnXPMColorException;
import cc.squirreljme.runtime.lcdui.image.__CharStripper__;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;

public class XPMReader
implements ImageReader {
    protected final InputStream in;
    private final NativeImageLoadCallback loader;

    public XPMReader(InputStream __is, NativeImageLoadCallback __loader) throws NullPointerException {
        if (__is == null) {
            throw new NullPointerException("NARG");
        }
        this.in = __is;
        this.loader = __loader;
    }

    @Override
    public void parse() throws IOException {
        InputStream in = this.in;
        NativeImageLoadCallback loader = this.loader;
        __CharStripper__ cs2 = new __CharStripper__(new InputStreamReader(in, "utf-8"));
        int[] header = this.__readHeader(cs2);
        int width = Math.max(header[0], 1);
        int height = Math.max(header[1], 1);
        int numcolors = Math.max(header[2], 1);
        int pxchars = Math.max(header[3], 1);
        int hotx = header[4];
        int hoty = header[5];
        int[] codes = new int[numcolors];
        int[] palette = new int[numcolors];
        boolean alpha = this.__readColorTable(cs2, codes, palette, numcolors, pxchars);
        boolean wantIndex = loader.setPalette(palette, 0, numcolors, alpha, -1);
        int area = width * height;
        int[] data = new int[area];
        loader.initialize(width, height, false, false);
        this.__readPixels(cs2, width, height, data, pxchars, codes, palette, wantIndex);
        loader.addImage(data, 0, data.length, 0, alpha);
    }

    private int __decodeColor(CharSequence __cs) {
        if ("none".equalsIgnoreCase(__cs.toString())) {
            return 0;
        }
        int n2 = __cs.length();
        if (n2 <= 0) {
            throw new NotAnXPMColorException(__cs.toString());
        }
        if (__cs.charAt(0) != '#') {
            throw new NotAnXPMColorException(__cs.toString());
        }
        int[] dig = new int[8];
        int i2 = 0;
        for (int j2 = 1; i2 < 8 && j2 < n2; ++i2, ++j2) {
            dig[i2] = Math.max(0, Character.digit(__cs.charAt(j2), 16));
        }
        if (n2 == 4) {
            return 0xFF000000 | dig[0] << 20 | dig[0] << 16 | dig[1] << 12 | dig[1] << 8 | dig[2] << 4 | dig[2];
        }
        if (n2 == 5) {
            return dig[0] << 28 | dig[0] << 24 | dig[1] << 20 | dig[1] << 16 | dig[2] << 12 | dig[2] << 8 | dig[3] << 4 | dig[3];
        }
        if (n2 == 7) {
            return 0xFF000000 | dig[0] << 20 | dig[1] << 16 | dig[2] << 12 | dig[3] << 8 | dig[4] << 4 | dig[5];
        }
        if (n2 == 9) {
            return dig[0] << 28 | dig[1] << 24 | dig[2] << 20 | dig[3] << 16 | dig[4] << 12 | dig[5] << 8 | dig[6] << 4 | dig[7];
        }
        throw new NotAnXPMColorException(__cs.toString());
    }

    private int __locateCode(int __c, int[] __codes, int[] __pal) {
        int at2 = Arrays.binarySearch(__codes, __c);
        if (at2 >= 0) {
            return __pal[at2];
        }
        return 0;
    }

    private boolean __readColorTable(Reader __cs, int[] __codes, int[] __palette, int __numcolors, int __pxchars) throws IOException {
        boolean hasalpha = false;
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < __numcolors; ++i2) {
            int at2;
            int col;
            int s2;
            int e2;
            sb.setLength(0);
            this.__readLine(__cs, sb);
            int n2 = sb.length();
            if (n2 < __pxchars) continue;
            int cx2 = 0;
            if (__pxchars >= 1) {
                cx2 |= sb.charAt(0);
            }
            if (__pxchars >= 2) {
                cx2 |= sb.charAt(1) << 16;
            }
            for (e2 = n2 - 1; e2 >= __pxchars && sb.charAt(e2) <= ' '; --e2) {
            }
            for (s2 = e2 - 1; s2 >= __pxchars && sb.charAt(s2) > ' '; --s2) {
            }
            try {
                col = this.__decodeColor(sb.subSequence(s2 + 1, e2 + 1));
            }
            catch (NotAnXPMColorException ignored) {
                continue;
            }
            if ((col & 0xFF000000) != -16777216) {
                hasalpha = true;
            }
            if ((at2 = Arrays.binarySearch(__codes, 0, i2, cx2)) < 0) {
                at2 = -(at2 + 1);
            }
            for (int j2 = i2; j2 > at2; --j2) {
                __codes[j2] = __codes[j2 - 1];
                __palette[j2] = __palette[j2 - 1];
            }
            __codes[at2] = cx2;
            __palette[at2] = col;
        }
        return hasalpha;
    }

    private int[] __readHeader(Reader __r) throws IOException {
        int[] header = new int[7];
        int i2 = 0;
        while (!this.__readInt(__r, header, Math.min(6, i2))) {
            ++i2;
        }
        return header;
    }

    private boolean __readInt(Reader __r, int[] __v, int __o) throws IOException {
        int val2 = 0;
        boolean neg = false;
        boolean first = true;
        boolean startwhite = true;
        while (true) {
            int c2;
            if ((c2 = __r.read()) != 32 && c2 != 9 && c2 != 13 || !startwhite) {
                startwhite = false;
                if (c2 < 0) {
                    __v[__o] = neg ? -val2 : val2;
                    return true;
                }
                if (first && c2 == 45) {
                    neg = true;
                } else {
                    int dig = Character.digit((char)c2, 10);
                    if (dig < 0) {
                        __v[__o] = neg ? -val2 : val2;
                        return false;
                    }
                    val2 *= 10;
                    val2 += dig;
                }
            }
            first = false;
        }
    }

    private void __readLine(Reader __r, StringBuilder __sb) throws IOException {
        int c2;
        while ((c2 = __r.read()) >= 0) {
            __sb.append((char)c2);
        }
        return;
    }

    private void __readPixels(Reader __cs, int __width, int __height, int[] __data, int __pxchars, int[] __codes, int[] __palette, boolean __wantIndex) throws IOException {
        int lastcode = -1;
        int lastpall = -1;
        block0: for (int y2 = 0; y2 < __height; ++y2) {
            int x2 = 0;
            int z2 = y2 * __width;
            while (true) {
                int code = 0;
                for (int i2 = 0; i2 < __pxchars; ++i2) {
                    int c2 = __cs.read();
                    if (c2 == Integer.MIN_VALUE) continue block0;
                    if (c2 < 0) break block0;
                    if (i2 == 0) {
                        code = c2;
                        continue;
                    }
                    if (i2 != 1) continue;
                    code |= c2 << 16;
                }
                if (__wantIndex) {
                    __data[z2++] = code;
                } else if (code == lastcode) {
                    __data[z2++] = lastpall;
                } else {
                    lastcode = code;
                    lastpall = this.__locateCode(lastcode, __codes, __palette);
                    __data[z2++] = lastpall;
                }
                ++x2;
            }
        }
    }
}

