/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.lcdui.mle;

import cc.squirreljme.jvm.mle.PencilShelf;
import cc.squirreljme.jvm.mle.brackets.PencilBracket;
import cc.squirreljme.jvm.mle.exceptions.MLECallError;
import cc.squirreljme.jvm.mle.scritchui.brackets.ScritchPencilBracket;
import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.runtime.lcdui.mle.PencilFontProvider;
import cc.squirreljme.runtime.lcdui.scritchui.DisplayManager;
import cc.squirreljme.runtime.midlet.MeepRuntime;
import java.io.Closeable;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Text;

@SquirrelJMEVendorApi
public final class PencilGraphics
extends Graphics
implements Closeable {
    @SquirrelJMEVendorApi
    protected final PencilBracket hardware;
    @SquirrelJMEVendorApi
    protected final int surfaceW;
    @SquirrelJMEVendorApi
    protected final int surfaceH;
    @SquirrelJMEVendorApi
    protected final boolean hasAlpha;
    @SquirrelJMEVendorApi
    private final char[] _singleChar = new char[1];
    @SquirrelJMEVendorApi
    private int _argbColor;
    @SquirrelJMEVendorApi
    private int _blendingMode;
    @SquirrelJMEVendorApi
    private int _clipHeight;
    @SquirrelJMEVendorApi
    private int _clipWidth;
    @SquirrelJMEVendorApi
    private int _clipX;
    @SquirrelJMEVendorApi
    private int _clipY;
    @SquirrelJMEVendorApi
    private Font _font;
    @SquirrelJMEVendorApi
    private int _strokeStyle;
    @SquirrelJMEVendorApi
    private volatile boolean _isClosed;

    @SquirrelJMEVendorApi
    private PencilGraphics(int __sw, int __sh, PencilBracket __hardware) throws IllegalArgumentException, NullPointerException {
        if (__hardware == null) {
            throw new NullPointerException("NARG");
        }
        this.hardware = __hardware;
        this.surfaceW = __sw;
        this.surfaceH = __sh;
        this.hasAlpha = PencilShelf.hardwareHasAlpha(__hardware);
        this.setAlphaColor(-16777216);
        this.setBlendingMode(0);
        this.setStrokeStyle(0);
        this.setFont(null);
    }

    @Override
    @SquirrelJMEVendorApi
    public void clipRect(int __x, int __y, int __w, int __h) {
        int temp;
        if (this._isClosed) {
            return;
        }
        int startX = __x + this.getTranslateX();
        int startY = __y + this.getTranslateY();
        int endX = startX + __w;
        int endY = startY + __h;
        if (endX < startX) {
            temp = endX;
            endX = startX;
            startX = temp;
        }
        if (endY < startY) {
            temp = endY;
            endY = startY;
            startY = temp;
        }
        int oldX = this._clipX;
        int oldY = this._clipY;
        int oldEndX = oldX + this._clipWidth;
        int oldEndY = oldY + this._clipHeight;
        int clipX = Math.max(oldX, Math.min(this.surfaceW, Math.max(0, startX)));
        int clipY = Math.max(oldY, Math.min(this.surfaceH, Math.max(0, startY)));
        int clipEndX = Math.min(oldEndX, Math.min(this.surfaceW, Math.max(0, endX)));
        int clipEndY = Math.min(oldEndY, Math.min(this.surfaceH, Math.max(0, endY)));
        this._clipX = clipX;
        this._clipY = clipY;
        this._clipWidth = clipEndX - clipX;
        this._clipHeight = clipEndY - clipY;
        try {
            PencilShelf.hardwareSetClip(this.hardware, clipX - this.getTranslateX(), clipY - this.getTranslateY(), clipEndX - clipX, clipEndY - clipY);
        }
        catch (MLECallError e2) {
            throw e2.throwDistinct();
        }
    }

    @Override
    public void close() throws IOException {
        if (this._isClosed) {
            return;
        }
        this._isClosed = true;
        try {
            PencilShelf.hardwareCloseGraphics(this.hardware);
        }
        catch (MLECallError e2) {
            throw e2.throwDistinct();
        }
    }

    @Override
    @SquirrelJMEVendorApi
    public void copyArea(int __sx, int __sy, int __w, int __h, int __dx, int __dy, int __anchor) throws IllegalArgumentException, IllegalStateException {
        if (this._isClosed) {
            return;
        }
        try {
            PencilShelf.hardwareCopyArea(this.hardware, __sx, __sy, __w, __h, __dx, __dy, __anchor);
        }
        catch (MLECallError e2) {
            throw e2.throwDistinct();
        }
    }

    @Override
    @SquirrelJMEVendorApi
    public void drawArc(int __x, int __y, int __w, int __h, int __startAngle, int __arcAngle) {
        if (this._isClosed) {
            return;
        }
        throw Debugging.todo();
    }

    @Override
    @SquirrelJMEVendorApi
    public void drawARGB16(short[] __data, int __off, int __scanlen, int __x, int __y, int __w, int __h) throws NullPointerException {
        if (this._isClosed) {
            return;
        }
        throw Debugging.todo();
    }

    @Override
    @SquirrelJMEVendorApi
    public void drawChar(char __s, int __x, int __y, int __anchor) {
        if (this._isClosed) {
            return;
        }
        char[] singleChar = this._singleChar;
        singleChar[0] = __s;
        try {
            PencilShelf.hardwareDrawChars(this.hardware, singleChar, 0, 1, __x, __y, __anchor);
        }
        catch (MLECallError e2) {
            throw e2.throwDistinct();
        }
    }

    @Override
    @SquirrelJMEVendorApi
    public void drawChars(char[] __s, int __o, int __l, int __x, int __y, int __anchor) throws IllegalArgumentException, IndexOutOfBoundsException, NullPointerException {
        if (__s == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l > __s.length) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        if (this._isClosed) {
            return;
        }
        try {
            PencilShelf.hardwareDrawChars(this.hardware, __s, __o, __l, __x, __y, __anchor);
        }
        catch (MLECallError e2) {
            throw e2.throwDistinct();
        }
    }

    @Override
    @SquirrelJMEVendorApi
    public void drawImage(Image __i, int __x, int __y, int __anchor) throws IllegalArgumentException, NullPointerException {
        this.drawRegion(__i, 0, 0, __i.getWidth(), __i.getHeight(), 0, __x, __y, __anchor);
    }

    @Override
    @SquirrelJMEVendorApi
    public void drawLine(int __x1, int __y1, int __x2, int __y2) {
        if (this._isClosed) {
            return;
        }
        try {
            PencilShelf.hardwareDrawLine(this.hardware, __x1, __y1, __x2, __y2);
        }
        catch (MLECallError e2) {
            throw e2.throwDistinct();
        }
    }

    @Override
    @SquirrelJMEVendorApi
    public void drawRGB(int[] __data, int __off, int __scanlen, int __x, int __y, int __w, int __h, boolean __alpha) throws NullPointerException {
        if (this._isClosed) {
            return;
        }
        try {
            this.__drawRegion(__data, __off, __scanlen, __alpha, 0, 0, __w, __h, 0, __x, __y, 20, __w, __h, __scanlen, (__data.length - __off) / __scanlen);
        }
        catch (MLECallError e2) {
            throw e2.throwDistinct();
        }
    }

    @Override
    @SquirrelJMEVendorApi
    public void drawRGB16(short[] __data, int __off, int __scanlen, int __x, int __y, int __w, int __h) throws NullPointerException {
        if (this._isClosed) {
            return;
        }
        throw Debugging.todo();
    }

    @Override
    @SquirrelJMEVendorApi
    public void drawRect(int __x, int __y, int __w, int __h) {
        if (this._isClosed) {
            return;
        }
        try {
            PencilShelf.hardwareDrawRect(this.hardware, __x, __y, __w, __h);
        }
        catch (MLECallError e2) {
            throw e2.throwDistinct();
        }
    }

    @Override
    @SquirrelJMEVendorApi
    public void drawRegion(Image __src, int __xsrc, int __ysrc, int __wsrc, int __hsrc, int __trans, int __xdest, int __ydest, int __anch) throws IllegalArgumentException, NullPointerException {
        if (this._isClosed) {
            return;
        }
        this.drawRegion(__src, __xsrc, __ysrc, __wsrc, __hsrc, __trans, __xdest, __ydest, __anch, __wsrc, __hsrc);
    }

    @Override
    @SquirrelJMEVendorApi
    public void drawRegion(Image __src, int __xsrc, int __ysrc, int __wsrc, int __hsrc, int __trans, int __xdest, int __ydest, int __anch, int __wdest, int __hdest) throws IllegalArgumentException, NullPointerException {
        int scanLen;
        int offset;
        int[] buf;
        if (__src == null) {
            throw new NullPointerException("NARG");
        }
        if (this._isClosed) {
            return;
        }
        if (__src.squirreljmeIsDirect()) {
            buf = __src.squirreljmeDirectRGBInt();
            offset = __src.squirreljmeDirectOffset();
            scanLen = __src.squirreljmeDirectScanLen();
        } else {
            int iW = __src.getWidth();
            int iH = __src.getHeight();
            int totalPixels = iW * iH;
            buf = new int[totalPixels];
            offset = 0;
            scanLen = iW;
            __src.getRGB(buf, offset, scanLen, 0, 0, iW, iH);
        }
        try {
            this.__drawRegion(buf, offset, scanLen, __src.hasAlpha(), __xsrc, __ysrc, __wsrc, __hsrc, __trans, __xdest, __ydest, __anch, __wdest, __hdest, __src.getWidth(), __src.getHeight());
        }
        catch (MLECallError e2) {
            throw e2.throwDistinct();
        }
    }

    @Override
    @SquirrelJMEVendorApi
    public void drawRoundRect(int __x, int __y, int __w, int __h, int __arcWidth, int __arcHeight) {
        if (this._isClosed) {
            return;
        }
        throw Debugging.todo();
    }

    @Override
    @SquirrelJMEVendorApi
    public void drawString(String __s, int __x, int __y, int __anchor) throws NullPointerException {
        if (__s == null) {
            throw new NullPointerException("NARG");
        }
        if (this._isClosed) {
            return;
        }
        try {
            PencilShelf.hardwareDrawSubstring(this.hardware, __s, 0, __s.length(), __x, __y, __anchor);
        }
        catch (MLECallError e2) {
            throw e2.throwDistinct();
        }
    }

    @Override
    @SquirrelJMEVendorApi
    public void drawSubstring(String __s, int __o, int __l, int __x, int __y, int __anchor) throws NullPointerException, StringIndexOutOfBoundsException {
        if (__s == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l > __s.length()) {
            throw new StringIndexOutOfBoundsException("IOOB");
        }
        if (this._isClosed) {
            return;
        }
        try {
            PencilShelf.hardwareDrawSubstring(this.hardware, __s, __o, __l, __x, __y, __anchor);
        }
        catch (MLECallError e2) {
            throw e2.throwDistinct();
        }
    }

    @Override
    @SquirrelJMEVendorApi
    public void drawText(Text __t, int __x, int __y) {
        if (this._isClosed) {
            return;
        }
        throw Debugging.todo();
    }

    @Override
    @SquirrelJMEVendorApi
    public void fillArc(int __x, int __y, int __w, int __h, int __startAngle, int __arcAngle) {
        if (this._isClosed) {
            return;
        }
        throw Debugging.todo();
    }

    @Override
    @SquirrelJMEVendorApi
    public void fillRect(int __x, int __y, int __w, int __h) {
        if (this._isClosed) {
            return;
        }
        try {
            PencilShelf.hardwareFillRect(this.hardware, __x, __y, __w, __h);
        }
        catch (MLECallError e2) {
            throw e2.throwDistinct();
        }
    }

    @Override
    @SquirrelJMEVendorApi
    public void fillRoundRect(int __x, int __y, int __w, int __h, int __arcWidth, int __arcHeight) {
        if (this._isClosed) {
            return;
        }
        throw Debugging.todo();
    }

    @Override
    @SquirrelJMEVendorApi
    public void fillTriangle(int __x1, int __y1, int __x2, int __y2, int __x3, int __y3) {
        if (this._isClosed) {
            return;
        }
        try {
            PencilShelf.hardwareFillTriangle(this.hardware, __x1, __y1, __x2, __y2, __x3, __y3);
        }
        catch (MLECallError e2) {
            throw e2.throwDistinct();
        }
    }

    @Override
    @SquirrelJMEVendorApi
    public int getAlpha() {
        return this._argbColor >> 24 & 0xFF;
    }

    @Override
    @SquirrelJMEVendorApi
    public int getAlphaColor() {
        return this._argbColor;
    }

    @Override
    @SquirrelJMEVendorApi
    public int getBlendingMode() {
        return this._blendingMode;
    }

    @Override
    @SquirrelJMEVendorApi
    public int getBlueComponent() {
        return this._argbColor & 0xFF;
    }

    @Override
    @SquirrelJMEVendorApi
    public int getClipHeight() {
        return this._clipHeight;
    }

    @Override
    @SquirrelJMEVendorApi
    public int getClipWidth() {
        return this._clipWidth;
    }

    @Override
    @SquirrelJMEVendorApi
    public int getClipX() {
        return this._clipX - this.getTranslateX();
    }

    @Override
    @SquirrelJMEVendorApi
    public int getClipY() {
        return this._clipY - this.getTranslateY();
    }

    @Override
    @SquirrelJMEVendorApi
    public int getColor() {
        return this._argbColor & 0xFFFFFF;
    }

    @Override
    @SquirrelJMEVendorApi
    public int getDisplayColor(int __rgb) {
        throw Debugging.todo();
    }

    @Override
    @SquirrelJMEVendorApi
    public Font getFont() {
        return this._font;
    }

    @Override
    @SquirrelJMEVendorApi
    public int getGrayScale() {
        return ((this._argbColor >> 16 & 0xFF) + (this._argbColor >> 8 & 0xFF) + (this._argbColor & 0xFF)) / 3;
    }

    @Override
    @SquirrelJMEVendorApi
    public int getGreenComponent() {
        return this._argbColor >> 8 & 0xFF;
    }

    @Override
    @SquirrelJMEVendorApi
    public int getRedComponent() {
        return this._argbColor >> 16 & 0xFF;
    }

    @Override
    @SquirrelJMEVendorApi
    public int getStrokeStyle() {
        return this._strokeStyle;
    }

    @Override
    @SquirrelJMEVendorApi
    public int getTranslateX() {
        if (this._isClosed) {
            return 0;
        }
        return PencilShelf.hardwareTranslateXY(this.hardware, false);
    }

    @Override
    @SquirrelJMEVendorApi
    public int getTranslateY() {
        if (this._isClosed) {
            return 0;
        }
        return PencilShelf.hardwareTranslateXY(this.hardware, true);
    }

    @Override
    @SquirrelJMEVendorApi
    public void setAlpha(int __a) throws IllegalArgumentException {
        if (this._isClosed) {
            return;
        }
        this.setAlphaColor(__a, this.getRedComponent(), this.getGreenComponent(), this.getBlueComponent());
    }

    @Override
    @SquirrelJMEVendorApi
    public void setAlphaColor(int __argb) {
        if (this._isClosed) {
            return;
        }
        if (MeepRuntime.versionBefore(3, 0)) {
            __argb |= 0xFF000000;
        }
        this._argbColor = __argb;
        PencilShelf.hardwareSetAlphaColor(this.hardware, __argb);
    }

    @Override
    @SquirrelJMEVendorApi
    public void setAlphaColor(int __a, int __r, int __g, int __b) throws IllegalArgumentException {
        if (__a < 0 || __a > 255 || __r < 0 || __r > 255 || __g < 0 || __g > 255 || __b < 0 || __b > 255) {
            throw new IllegalArgumentException(String.format("EB3t %d %d %d %d", __a, __r, __g, __b));
        }
        if (this._isClosed) {
            return;
        }
        this.setAlphaColor(__a << 24 | __r << 16 | __g << 8 | __b);
    }

    @Override
    @SquirrelJMEVendorApi
    public void setBlendingMode(int __m) throws IllegalArgumentException {
        if (__m != 1 && __m != 0 || __m == 1 && !this.hasAlpha) {
            throw new IllegalArgumentException("EB3u " + __m);
        }
        if (this._isClosed) {
            return;
        }
        this._blendingMode = __m;
        try {
            PencilShelf.hardwareSetBlendingMode(this.hardware, __m);
        }
        catch (MLECallError e2) {
            throw e2.throwDistinct();
        }
    }

    @Override
    @SquirrelJMEVendorApi
    public void setClip(int __x, int __y, int __w, int __h) {
        int temp;
        if (this._isClosed) {
            return;
        }
        int startX = __x + this.getTranslateX();
        int startY = __y + this.getTranslateY();
        int endX = startX + __w;
        int endY = startY + __h;
        if (endX < startX) {
            temp = endX;
            endX = startX;
            startX = temp;
        }
        if (endY < startY) {
            temp = endY;
            endY = startY;
            startY = temp;
        }
        int clipX = Math.min(this.surfaceW, Math.max(0, startX));
        int clipY = Math.min(this.surfaceH, Math.max(0, startY));
        int clipEndX = Math.min(this.surfaceW, Math.max(0, endX));
        int clipEndY = Math.min(this.surfaceH, Math.max(0, endY));
        this._clipX = clipX;
        this._clipY = clipY;
        this._clipWidth = clipEndX - clipX;
        this._clipHeight = clipEndY - clipY;
        try {
            PencilShelf.hardwareSetClip(this.hardware, __x, __y, __w, __h);
        }
        catch (MLECallError e2) {
            throw e2.throwDistinct();
        }
    }

    @Override
    @SquirrelJMEVendorApi
    public void setColor(int __rgb) {
        if (this._isClosed) {
            return;
        }
        this.setAlphaColor(this.getAlphaColor() & 0xFF000000 | __rgb & 0xFFFFFF);
    }

    @Override
    @SquirrelJMEVendorApi
    public void setColor(int __r, int __g, int __b) throws IllegalArgumentException {
        if (this._isClosed) {
            return;
        }
        this.setAlphaColor(this.getAlpha(), __r, __g, __b);
    }

    @Override
    @SquirrelJMEVendorApi
    public void setFont(Font __font) {
        if (this._isClosed) {
            return;
        }
        if (__font == null) {
            __font = Font.getDefaultFont();
        }
        this._font = __font;
        try {
            PencilShelf.hardwareSetFont(this.hardware, ((PencilFontProvider)__font).__squirreljmePencilFont());
        }
        catch (MLECallError e2) {
            throw e2.throwDistinct();
        }
    }

    @Override
    @SquirrelJMEVendorApi
    public void setGrayScale(int __v) {
        if (this._isClosed) {
            return;
        }
        this.setAlphaColor(this.getAlpha(), __v, __v, __v);
    }

    @Override
    @SquirrelJMEVendorApi
    public void setStrokeStyle(int __style) throws IllegalArgumentException {
        if (__style != 0 && __style != 1) {
            throw new IllegalArgumentException("EB3v");
        }
        if (this._isClosed) {
            return;
        }
        this._strokeStyle = __style;
        try {
            PencilShelf.hardwareSetStrokeStyle(this.hardware, __style);
        }
        catch (MLECallError e2) {
            throw e2.throwDistinct();
        }
    }

    @Override
    @SquirrelJMEVendorApi
    public void translate(int __x, int __y) {
        if (this._isClosed) {
            return;
        }
        try {
            PencilShelf.hardwareTranslate(this.hardware, __x, __y);
        }
        catch (MLECallError e2) {
            throw e2.throwDistinct();
        }
    }

    @SquirrelJMEVendorApi
    private void __drawRegion(int[] __data, int __off, int __scanlen, boolean __alpha, int __xsrc, int __ysrc, int __wsrc, int __hsrc, int __trans, int __xdest, int __ydest, int __anch, int __wdest, int __hdest, int __origImgWidth, int __origImgHeight) throws NullPointerException {
        if (__data == null) {
            throw new NullPointerException("NARG");
        }
        if (this._isClosed) {
            return;
        }
        PencilShelf.hardwareDrawXRGB32Region(this.hardware, __data, __off, __scanlen, __alpha, __xsrc, __ysrc, __wsrc, __hsrc, __trans, __xdest, __ydest, __anch, __wdest, __hdest, __origImgWidth, __origImgHeight);
    }

    @SquirrelJMEVendorApi
    public static Graphics hardwareGraphics(int __pf, int __bw, int __bh, Object __buf, int[] __pal, int __sx, int __sy, int __sw, int __sh) throws NullPointerException {
        return new PencilGraphics(__sw, __sh, DisplayManager.instance().scritch().hardwareGraphics(__pf, __bw, __bh, __buf, __pal, __sx, __sy, __sw, __sh));
    }

    @SquirrelJMEVendorApi
    public static Graphics of(ScritchPencilBracket __hw, int __sw, int __sh) throws NullPointerException {
        if (__hw == null) {
            throw new NullPointerException("NARG");
        }
        return new PencilGraphics(__sw, __sh, __hw);
    }
}

