/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.lcdui.scritchui;

import cc.squirreljme.jvm.mle.RuntimeShelf;
import cc.squirreljme.jvm.mle.scritchui.ScritchInterface;
import cc.squirreljme.jvm.mle.scritchui.brackets.ScritchScreenBracket;
import cc.squirreljme.jvm.mle.scritchui.brackets.ScritchWindowBracket;
import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.util.StringUtils;
import cc.squirreljme.runtime.lcdui.scritchui.DisplayFixedFlatScale;
import cc.squirreljme.runtime.lcdui.scritchui.DisplayFloatScale;
import cc.squirreljme.runtime.midlet.ActiveMidlet;
import javax.microedition.midlet.MIDlet;

@SquirrelJMEVendorApi
public abstract class DisplayScale {
    @SquirrelJMEVendorApi
    public static final String SCALE_PROPERTY = "cc.squirreljme.scale";
    @SquirrelJMEVendorApi
    public static final String SCALE_ENV = "SQUIRRELJME_SCALE";
    @SquirrelJMEVendorApi
    public static final String FRAME_PROPERTY = "cc.squirreljme.frame";
    @SquirrelJMEVendorApi
    public static final String FRAME_ENV = "SQUIRRELJME_FRAME";
    @SquirrelJMEVendorApi
    public static final byte SCALE_DEFAULT = 2;

    @SquirrelJMEVendorApi
    public abstract boolean requiresBuffer();

    @SquirrelJMEVendorApi
    public abstract int screenX(int var1);

    @SquirrelJMEVendorApi
    public abstract int screenY(int var1);

    @SquirrelJMEVendorApi
    public abstract int textureH();

    @SquirrelJMEVendorApi
    public abstract int textureMaxH();

    @SquirrelJMEVendorApi
    public abstract int textureMaxW();

    @SquirrelJMEVendorApi
    public abstract int textureW();

    @SquirrelJMEVendorApi
    public abstract int textureX(int var1);

    @SquirrelJMEVendorApi
    public abstract int textureY(int var1);

    @SquirrelJMEVendorApi
    public static DisplayScale applicationScale(ScritchInterface __scritch, ScritchScreenBracket __screen, ScritchWindowBracket __window) throws NullPointerException {
        DisplayScale rv;
        String override = System.getProperty(FRAME_PROPERTY);
        if (override == null) {
            override = RuntimeShelf.systemEnv(FRAME_ENV);
        }
        if (override != null && !override.isEmpty() && (rv = DisplayScale.__xyOverride(override)) != null) {
            return rv;
        }
        MIDlet midlet = ActiveMidlet.optional();
        if (midlet != null && (rv = DisplayScale.__midlet(midlet)) != null) {
            return rv;
        }
        String doJaSize = System.getProperty("cc.squirreljme.imode.adf.DrawArea");
        if (doJaSize != null && (rv = DisplayScale.__dojaDrawArea(doJaSize)) != null) {
            return rv;
        }
        String dojaTargetDevice = System.getProperty("cc.squirreljme.imode.adf.TargetDevice");
        if (dojaTargetDevice != null && dojaTargetDevice.isEmpty() && (rv = DisplayScale.__dojaTargetDevice(dojaTargetDevice.toLowerCase())) != null) {
            return rv;
        }
        String dojaProfile = System.getProperty("cc.squirreljme.imode.profile");
        if (dojaProfile != null && !dojaProfile.isEmpty() && (rv = DisplayScale.__dojaProfile(dojaProfile.trim().toLowerCase())) != null) {
            return rv;
        }
        return new DisplayFixedFlatScale(240, 320);
    }

    @SquirrelJMEVendorApi
    public static DisplayScale currentScale(ScritchInterface __scritch, ScritchScreenBracket __screen, ScritchWindowBracket __window) throws NullPointerException {
        int[] coord;
        DisplayScale appScale = DisplayScale.applicationScale(__scritch, __screen, __window);
        String override = System.getProperty(SCALE_PROPERTY);
        if (override == null) {
            override = RuntimeShelf.systemEnv(SCALE_ENV);
        }
        int useW = 0;
        int useH = 0;
        int useScale = 2;
        if (override != null && !override.isEmpty()) {
            try {
                int s2 = override.indexOf(120);
                if (s2 >= 0) {
                    useW = Integer.parseInt(override.substring(0, s2), 10);
                    useH = Integer.parseInt(override.substring(s2 + 1), 10);
                } else {
                    useScale = Integer.parseInt(override, 10);
                }
            }
            catch (NumberFormatException s2) {
                // empty catch block
            }
        }
        if ((coord = new int[]{0, 0, useW > 0 ? useW : appScale.textureW() * Math.max(1, useScale), useH > 0 ? useH : appScale.textureH() * Math.max(1, useScale)})[2] != appScale.textureW() || coord[3] != appScale.textureH()) {
            return new DisplayFloatScale(appScale, coord[2], coord[3]);
        }
        return appScale;
    }

    private static DisplayFixedFlatScale __dojaDrawArea(String __v) throws NullPointerException {
        if (__v == null) {
            throw new NullPointerException("NARG");
        }
        int x2 = __v.indexOf(120);
        if (x2 >= 1) {
            try {
                int width = Math.max(96, Integer.parseInt(__v.substring(0, x2), 10));
                int height = Math.max(72, Integer.parseInt(__v.substring(x2 + 1), 10));
                return new DisplayFixedFlatScale(width, height);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static DisplayScale __dojaTargetDevice(String __devices) throws NullPointerException {
        if (__devices == null) {
            throw new NullPointerException("NARG");
        }
        for (String device : StringUtils.basicSplit(',', __devices)) {
            if ((device = device.trim().toLowerCase()).isEmpty()) continue;
            switch (device) {
                case "so503i": 
                case "so503is": {
                    return new DisplayFixedFlatScale(120, 120);
                }
                case "f503i": 
                case "f503is": 
                case "n2001": 
                case "n2002": 
                case "n503i": 
                case "n503is": 
                case "p2002": 
                case "p503i": 
                case "p503is": {
                    return new DisplayFixedFlatScale(120, 130);
                }
                case "so504i": {
                    return new DisplayFixedFlatScale(128, 128);
                }
                case "d503i": 
                case "d503is": {
                    return new DisplayFixedFlatScale(132, 126);
                }
                case "d2101v": {
                    return new DisplayFixedFlatScale(132, 130);
                }
                case "f504i": 
                case "f504is": {
                    return new DisplayFixedFlatScale(132, 136);
                }
                case "d504i": 
                case "p504i": 
                case "p504is": {
                    return new DisplayFixedFlatScale(132, 144);
                }
                case "n504i": 
                case "n504is": {
                    return new DisplayFixedFlatScale(160, 180);
                }
                case "nm850ig": 
                case "t2101v": {
                    return new DisplayFixedFlatScale(176, 144);
                }
                case "n600i": {
                    return new DisplayFixedFlatScale(176, 180);
                }
                case "f2051": 
                case "f2102v": 
                case "p2101v": {
                    return new DisplayFixedFlatScale(176, 182);
                }
                case "l600i": 
                case "l601i": 
                case "n2051": 
                case "n2102v": 
                case "n2701": 
                case "p2102v": {
                    return new DisplayFixedFlatScale(176, 198);
                }
                case "sh2101v": {
                    return new DisplayFixedFlatScale(240, 160);
                }
                case "sh505i": 
                case "sh505is": 
                case "sh506ic": 
                case "sh900i": {
                    return new DisplayFixedFlatScale(240, 252);
                }
                case "p505i": 
                case "p505is": 
                case "p506ic": 
                case "p506icii": {
                    return new DisplayFixedFlatScale(240, 266);
                }
                case "m702ig": 
                case "m702is": {
                    return new DisplayFixedFlatScale(240, 267);
                }
                case "f505i": 
                case "f505igps": 
                case "f506i": {
                    return new DisplayFixedFlatScale(240, 268);
                }
                case "d505i": 
                case "d505is": 
                case "d506i": 
                case "d900i": 
                case "n506i": 
                case "n506is": 
                case "n506isii": {
                    return new DisplayFixedFlatScale(240, 270);
                }
            }
        }
        return null;
    }

    private static DisplayScale __dojaProfile(String __profile) throws NullPointerException {
        if (__profile == null) {
            throw new NullPointerException("NARG");
        }
        if (__profile.equalsIgnoreCase("DoJa-1.0")) {
            return new DisplayFixedFlatScale(240, 160);
        }
        return new DisplayFixedFlatScale(240, 240);
    }

    private static DisplayScale __midlet(MIDlet __midlet, String __key, boolean __swap, char __delim) throws NullPointerException {
        if (__midlet == null) {
            throw new NullPointerException("NARG");
        }
        String value = __midlet.getAppProperty(__key);
        if (value == null) {
            return null;
        }
        return new DisplayFixedFlatScale(DisplayScale.__parse(value, __delim, __swap), DisplayScale.__parse(value, __delim, !__swap));
    }

    private static DisplayScale __midlet(MIDlet __midlet) throws NullPointerException {
        if (__midlet == null) {
            throw new NullPointerException("NARG");
        }
        DisplayScale rv = DisplayScale.__midlet(__midlet, "X-SquirrelJME-Resolution", false, 'x');
        if (rv != null) {
            return rv;
        }
        rv = DisplayScale.__midlet(__midlet, "MIDxlet-ScreenSize", false, ',');
        if (rv != null) {
            return rv;
        }
        rv = DisplayScale.__midlet(__midlet, "MIDxlet-Application-Resolution", false, ',');
        if (rv != null) {
            return rv;
        }
        rv = DisplayScale.__midlet(__midlet, "MIDxlet-Application-Range", true, ',');
        if (rv != null) {
            return rv;
        }
        rv = DisplayScale.__midlet(__midlet, "Nokia-MIDlet-Original-Display-Size", false, ',');
        if (rv != null) {
            return rv;
        }
        rv = DisplayScale.__midlet(__midlet, "Nokia-MIDlet-Target-Display-Size", false, ',');
        if (rv != null) {
            return rv;
        }
        rv = DisplayScale.__midlet(__midlet, "SEMC-Screen-Size", false, ',');
        if (rv != null) {
            return rv;
        }
        return null;
    }

    private static int __parse(String __s, char __delim, boolean __height) throws NullPointerException {
        if (__s == null) {
            throw new NullPointerException("NARG");
        }
        int at2 = __s.indexOf(__delim);
        if (at2 >= 0) {
            try {
                int v2 = !__height ? Integer.parseInt(__s.substring(0, at2), 10) : Integer.parseInt(__s.substring(at2 + 1), 10);
                if (v2 >= 32 && v2 <= 1024) {
                    return v2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return __height ? 320 : 240;
    }

    private static DisplayFixedFlatScale __xyOverride(String __v) throws NullPointerException {
        if (__v == null) {
            throw new NullPointerException("NARG");
        }
        int useW = -1;
        int useH = -1;
        int s2 = __v.indexOf(120);
        if (s2 >= 0) {
            try {
                useW = Integer.parseInt(__v.substring(0, s2), 10);
                useH = Integer.parseInt(__v.substring(s2 + 1), 10);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (useW > 0 && useH > 0) {
            return new DisplayFixedFlatScale(useW, useH);
        }
        return null;
    }
}

