/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.runtime.midlet;

import cc.squirreljme.jvm.mle.JarPackageShelf;
import cc.squirreljme.jvm.mle.RawJarPackageBracketInputStream;
import cc.squirreljme.jvm.mle.brackets.JarPackageBracket;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import net.multiphasicapps.collections.UnmodifiableCollection;

public enum ManifestSourceType {
    JAD{

        @Override
        public InputStream manifestStream(JarPackageBracket __ourJar) throws IOException, NullPointerException {
            String assumedJad;
            if (__ourJar == null) {
                throw new NullPointerException("NARG");
            }
            String ourPath = JarPackageShelf.libraryPath(__ourJar);
            if (ourPath.endsWith(".jar") || ourPath.endsWith(".JAR")) {
                boolean caps = ourPath.endsWith(".JAR");
                assumedJad = ourPath.substring(0, ourPath.length() - 4) + (caps ? ".JAD" : ".jad");
            } else {
                assumedJad = ourPath + ".jad";
            }
            for (JarPackageBracket otherJar : JarPackageShelf.libraries()) {
                String otherPath = JarPackageShelf.libraryPath(otherJar);
                if (!assumedJad.equals(otherPath)) continue;
                return JarPackageShelf.openResource(otherJar, "META-INF/MANIFEST.MF");
            }
            return null;
        }
    }
    ,
    KJX_EMBEDDED_JAD{

        @Override
        public String encoding() {
            return "shift-jis";
        }

        @Override
        public InputStream manifestStream(JarPackageBracket __ourJar) throws IOException, NullPointerException {
            if (__ourJar == null) {
                throw new NullPointerException("NARG");
            }
            String ourPath = JarPackageShelf.libraryPath(__ourJar);
            if (!ourPath.endsWith(".kjx") && !ourPath.endsWith(".KJX")) {
                return null;
            }
            try (DataInputStream raw = new DataInputStream(new RawJarPackageBracketInputStream(__ourJar));){
                byte[] magic = new byte[3];
                raw.readFully(magic);
                if (magic[0] != 75 || magic[1] != 74 || magic[2] != 88) {
                    throw new IOException("ZZ4j");
                }
                int jadPos = raw.readUnsignedByte();
                int kjxNameLen = raw.readUnsignedByte();
                raw.skipBytes(kjxNameLen);
                int jadLen = raw.readUnsignedShort();
                int jadNameLen = raw.readUnsignedByte();
                raw.skipBytes(jadNameLen);
                int currentAt = 5 + kjxNameLen + 2 + 1 + jadNameLen;
                if (currentAt < jadPos) {
                    raw.skipBytes(jadPos - currentAt);
                }
                byte[] jad = new byte[jadLen];
                raw.readFully(jad);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(jad);
                return byteArrayInputStream;
            }
        }
    }
    ,
    JAR{

        @Override
        public InputStream manifestStream(JarPackageBracket __ourJar) throws IOException, NullPointerException {
            if (__ourJar == null) {
                throw new NullPointerException("NARG");
            }
            return JarPackageShelf.openResource(__ourJar, "META-INF/MANIFEST.MF");
        }
    };

    public static final Collection<ManifestSourceType> VALUES;
    public static final int COUNT;

    public abstract InputStream manifestStream(JarPackageBracket var1) throws IOException, NullPointerException;

    public String encoding() {
        return "utf-8";
    }

    static {
        VALUES = UnmodifiableCollection.of(Arrays.asList(ManifestSourceType.values()));
        COUNT = VALUES.size();
    }
}

