/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.vm;

import cc.squirreljme.vm.RawVMClassLibrary;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class DataContainerLibrary
implements RawVMClassLibrary {
    public static final String RESOURCE_NAME = "$DATA$";
    protected final Path path;

    public DataContainerLibrary(Path __path) throws NullPointerException {
        if (__path == null) {
            throw new NullPointerException("NARG");
        }
        this.path = __path;
    }

    public final InputStream asStream() throws IOException {
        return this.resourceAsStream(RESOURCE_NAME);
    }

    @Override
    public String[] listResources() {
        return new String[]{RESOURCE_NAME};
    }

    @Override
    public String name() {
        return this.path.getFileName().toString();
    }

    @Override
    public Path path() {
        return this.path;
    }

    @Override
    public void rawData(int __jarOffset, byte[] __b, int __o, int __l) throws IllegalStateException, IndexOutOfBoundsException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        int bufLen = __b.length;
        int libLen = this.rawSize();
        if (__jarOffset < 0 || __jarOffset + __l < 0 || __jarOffset + __l > libLen || __o < 0 || __l < 0 || __o + __l < 0 || __o + __l > bufLen) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        try (InputStream in = Files.newInputStream(this.path, StandardOpenOption.READ);){
            for (int at2 = 0; at2 < __jarOffset; ++at2) {
                if (in.read() >= 0) continue;
                throw new IllegalStateException("FEOF");
            }
            if (in.read(__b, __o, __l) != __l) {
                throw new IllegalStateException("SHRT");
            }
        }
        catch (IOException __e) {
            throw new IllegalStateException(__e);
        }
    }

    @Override
    public int rawSize() throws IllegalStateException {
        try {
            return (int)Math.min(Integer.MAX_VALUE, Files.size(this.path));
        }
        catch (IOException __e) {
            throw new IllegalStateException(__e);
        }
    }

    @Override
    public InputStream resourceAsStream(String __rc) throws IOException, NullPointerException {
        if (__rc == null) {
            throw new NullPointerException("NARG");
        }
        if (!RESOURCE_NAME.equals(__rc)) {
            return null;
        }
        return Files.newInputStream(this.path, StandardOpenOption.READ);
    }

    public final String toString() {
        return this.path.toString();
    }
}

