/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.vm.nanocoat;

import cc.squirreljme.emulator.NativeBinding;
import cc.squirreljme.emulator.profiler.ProfilerSnapshot;
import cc.squirreljme.emulator.vm.ArraySuiteManager;
import cc.squirreljme.emulator.vm.VMException;
import cc.squirreljme.emulator.vm.VMFactory;
import cc.squirreljme.emulator.vm.VMSuiteManager;
import cc.squirreljme.emulator.vm.VMThreadModel;
import cc.squirreljme.emulator.vm.VirtualMachine;
import cc.squirreljme.jdwp.host.JDWPHostFactory;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.vm.DataContainerLibrary;
import cc.squirreljme.vm.JarClassLibrary;
import cc.squirreljme.vm.NameOverrideClassLibrary;
import cc.squirreljme.vm.ResourceBasedClassLibrary;
import cc.squirreljme.vm.VMClassLibrary;
import cc.squirreljme.vm.nanocoat.NanoCoatVirtualMachine;
import cc.squirreljme.vm.standalone.hosted.HostedJDWPProxy;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class NanoCoatFactory
extends VMFactory {
    public NanoCoatFactory() {
        super("nanocoat");
    }

    @Override
    protected VirtualMachine createVM(ProfilerSnapshot __profiler, JDWPHostFactory __jdwp, VMThreadModel __threadModel, VMSuiteManager __suiteManager, VMClassLibrary[] __classpath, String __mainClass, Map<String, String> __sysProps, String[] __args) throws IllegalArgumentException, NullPointerException, VMException {
        StringBuilder cp2;
        boolean isWindows = System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("windows");
        Path execPath = NativeBinding.libFromResources(isWindows ? "squirreljme.exe" : "squirreljme", false);
        if (!Files.isExecutable((Path)execPath)) {
            try {
                HashSet<PosixFilePermission> bits = new HashSet<PosixFilePermission>(Files.getPosixFilePermissions((Path)execPath, (LinkOption[])new LinkOption[0]));
                bits.add(PosixFilePermission.OWNER_EXECUTE);
                Files.setPosixFilePermissions((Path)execPath, bits);
            }
            catch (IOException | UnsupportedOperationException bits) {
                // empty catch block
            }
        }
        ArrayList<String> execArgs = new ArrayList<String>();
        if (__jdwp != null) {
            HostedJDWPProxy jdwp = new HostedJDWPProxy(__jdwp);
            execArgs.add(String.format("-Xjdwp:localhost:%d", jdwp.port));
        }
        if (__threadModel != null) {
            switch (__threadModel) {
                case SINGLE_THREAD_COOP: {
                    execArgs.add("-Xthread:coop");
                    break;
                }
                case SINGLE_THREAD_PREEMPT: {
                    execArgs.add("-Xthread:shared");
                    break;
                }
                case MULTI_THREAD: {
                    execArgs.add("-Xthread:multi");
                }
            }
        }
        LinkedHashSet<Path> roms = new LinkedHashSet<Path>();
        LinkedHashSet<String> libraries = new LinkedHashSet<String>();
        if (__suiteManager != null) {
            NanoCoatFactory.unblend(roms, libraries, "", __suiteManager);
        }
        if (!roms.isEmpty()) {
            cp2 = new StringBuilder("-Xroms");
            for (Path rom : roms) {
                cp2.append(File.pathSeparator);
                cp2.append(rom.toAbsolutePath().normalize());
            }
            execArgs.add(cp2.toString());
        }
        if (!libraries.isEmpty()) {
            cp2 = new StringBuilder("-Xlibraries");
            for (String library : libraries) {
                cp2.append(File.pathSeparator);
                cp2.append(library);
            }
            execArgs.add(cp2.toString());
        }
        if (__classpath != null) {
            cp2 = new StringBuilder();
            for (VMClassLibrary lib : __classpath) {
                if (cp2.length() > 0) {
                    cp2.append(File.pathSeparator);
                }
                if (lib.path() != null) {
                    cp2.append(lib.path().toAbsolutePath().normalize());
                    continue;
                }
                cp2.append(lib.name());
            }
            execArgs.add("-classpath");
            execArgs.add(cp2.toString());
        }
        if (__sysProps != null) {
            for (Map.Entry<String, String> sysProp : __sysProps.entrySet()) {
                execArgs.add(String.format("-D%s=%s", sysProp.getKey(), sysProp.getValue()));
            }
        }
        if (__mainClass != null) {
            execArgs.add(__mainClass);
            if (__args != null) {
                execArgs.addAll(Arrays.asList(__args));
            }
        }
        Debugging.debugNote("Exec: %s %s", execPath, execArgs);
        return new NanoCoatVirtualMachine(execPath, execArgs);
    }

    public static void unblend(Set<Path> __outRoms, Set<String> __outLibs, String __prefix, VMSuiteManager ... __in) throws NullPointerException, VMException {
        if (__outRoms == null || __outLibs == null || __in == null) {
            throw new NullPointerException("NARG");
        }
        for (VMSuiteManager suite : __in) {
            if (suite instanceof ArraySuiteManager) {
                ArraySuiteManager arraySuite = (ArraySuiteManager)suite;
                for (VMClassLibrary lib : arraySuite) {
                    NanoCoatFactory.unblend(__outRoms, __outLibs, __prefix, lib);
                }
                continue;
            }
            throw Debugging.todo(suite.getClass());
        }
    }

    public static void unblend(Set<Path> __outRoms, Set<String> __outLibs, String __prefix, VMClassLibrary ... __in) throws NullPointerException, VMException {
        if (__outRoms == null || __outLibs == null || __in == null) {
            throw new NullPointerException("NARG");
        }
        for (VMClassLibrary lib : __in) {
            if (lib instanceof NameOverrideClassLibrary) {
                NameOverrideClassLibrary rename = (NameOverrideClassLibrary)lib;
                NanoCoatFactory.unblend(__outRoms, __outLibs, String.format("?mv?%s?", rename.name), rename.base);
                continue;
            }
            if (lib instanceof ResourceBasedClassLibrary) {
                Path jarPath;
                ResourceBasedClassLibrary rcLib = (ResourceBasedClassLibrary)lib;
                try {
                    jarPath = Paths.get(rcLib.actingclass.getProtectionDomain().getCodeSource().getLocation().toURI().getPath(), new String[0]);
                }
                catch (URISyntaxException __e) {
                    throw new VMException(__e.getMessage(), __e);
                }
                String prefix = rcLib.prefix;
                if (prefix.startsWith("/SQUIRRELJME.SQC/") || prefix.startsWith("/SQUIRRELJME-DEBUG.SQC/")) {
                    __outRoms.add(jarPath);
                    continue;
                }
                __outLibs.add(String.format("?rc?%s?%s?%s", rcLib.prefix, rcLib.name, jarPath.toAbsolutePath().normalize()));
                continue;
            }
            if (lib instanceof JarClassLibrary || lib instanceof DataContainerLibrary) {
                __outLibs.add(lib.path().toAbsolutePath().normalize().toString());
                continue;
            }
            throw Debugging.todo(lib.getClass());
        }
    }
}

