/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.vm.nanocoat;

import cc.squirreljme.emulator.vm.VMException;
import cc.squirreljme.emulator.vm.VirtualMachine;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class NanoCoatVirtualMachine
implements VirtualMachine {
    protected final List<String> execArgs;
    protected final Path execPath;

    public NanoCoatVirtualMachine(Path __execPath, List<String> __execArgs) throws NullPointerException {
        if (__execPath == null || __execArgs == null) {
            throw new NullPointerException("NARG");
        }
        this.execPath = __execPath;
        this.execArgs = new ArrayList<String>(__execArgs);
    }

    @Override
    public int runVm() throws VMException {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.execPath.toAbsolutePath().normalize().toString());
        args.addAll(this.execArgs);
        ProcessBuilder builder = new ProcessBuilder(args);
        builder.redirectInput(ProcessBuilder.Redirect.INHERIT);
        builder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        builder.redirectError(ProcessBuilder.Redirect.INHERIT);
        builder.directory(Paths.get(System.getProperty("user.dir"), new String[0]).toAbsolutePath().normalize().toFile());
        Process process = null;
        try {
            process = builder.start();
            int n2 = process.waitFor();
            return n2;
        }
        catch (IOException | InterruptedException __e) {
            throw new VMException(__e.getMessage(), __e);
        }
        finally {
            if (process != null) {
                process.destroyForcibly();
            }
        }
    }

    @Override
    public void setTraceBits(boolean __or, int __bits) {
    }
}

