/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.vm.springcoat;

import cc.squirreljme.vm.springcoat.SpringThread;

public class CallbackThread
implements AutoCloseable {
    private final SpringThread _thread;
    private int _openCount;
    private Thread _openBy;

    public CallbackThread(SpringThread __thread) throws NullPointerException {
        if (__thread == null) {
            throw new NullPointerException("NARG");
        }
        this._thread = __thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean canOpen() {
        Thread current = Thread.currentThread();
        CallbackThread callbackThread = this;
        synchronized (callbackThread) {
            return this._openBy == current || this._openCount == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IllegalStateException {
        Thread currentThread = Thread.currentThread();
        CallbackThread callbackThread = this;
        synchronized (callbackThread) {
            if (this._openBy != currentThread) {
                throw new IllegalStateException("Closed by wrong thread.");
            }
            if (--this._openCount == 0) {
                this._openBy = null;
            }
        }
    }

    public boolean noDebugSuspend() {
        return this._thread.noDebugSuspend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void open() throws IllegalStateException {
        Thread current = Thread.currentThread();
        CallbackThread callbackThread = this;
        synchronized (callbackThread) {
            Thread openBy = this._openBy;
            if (openBy != null && openBy != current) {
                throw new IllegalStateException("Opened by other thread.");
            }
            ++this._openCount;
            this._openBy = current;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SpringThread thread() throws IllegalStateException {
        CallbackThread callbackThread = this;
        synchronized (callbackThread) {
            if (this._openCount <= 0 || Thread.currentThread() != this._openBy) {
                throw new IllegalStateException("Not owned by thread.");
            }
            return this._thread;
        }
    }
}

