/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.vm.springcoat;

import cc.squirreljme.jdwp.host.JDWPHostController;
import cc.squirreljme.jdwp.host.trips.JDWPGlobalTrip;
import cc.squirreljme.jdwp.host.trips.JDWPTripVmState;
import cc.squirreljme.jvm.mle.brackets.TracePointBracket;
import cc.squirreljme.runtime.cldc.debug.CallTraceElement;
import cc.squirreljme.vm.springcoat.MLEDispatcher;
import cc.squirreljme.vm.springcoat.MLEFunction;
import cc.squirreljme.vm.springcoat.MLEObjects;
import cc.squirreljme.vm.springcoat.SpringObject;
import cc.squirreljme.vm.springcoat.SpringSimpleObject;
import cc.squirreljme.vm.springcoat.SpringThreadWorker;
import cc.squirreljme.vm.springcoat.brackets.TracePointObject;
import cc.squirreljme.vm.springcoat.exceptions.SpringMLECallError;

public enum MLEDebug implements MLEFunction
{
    BREAKPOINT("breakpoint:()V"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            JDWPHostController jdwp = __thread.machine.taskManager().jdwpController;
            if (jdwp != null) {
                jdwp.trip(JDWPTripVmState.class, JDWPGlobalTrip.VM_STATE).userDefined(__thread.thread);
            }
            return null;
        }
    }
    ,
    GET_THROWABLE_TRACE("getThrowableTrace:(Ljava/lang/Throwable;)[Lcc/squirreljme/jvm/mle/brackets/TracePointBracket;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            SpringObject object = (SpringObject)__args[0];
            if (!(object instanceof SpringSimpleObject) || object.type().isAssignableFrom(__thread.resolveClass("java/lang/Throwable"))) {
                throw new SpringMLECallError("Not a Throwable.");
            }
            return ((SpringSimpleObject)object).fieldByNameAndType(false, "_stackTrace", "[Lcc/squirreljme/jvm/mle/brackets/TracePointBracket;").get();
        }
    }
    ,
    POINT_ADDRESS("pointAddress:(Lcc/squirreljme/jvm/mle/brackets/TracePointBracket;)J"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return MLEObjects.debugTrace(__args[0]).getTrace().address();
        }
    }
    ,
    POINT_CLASS("pointClass:(Lcc/squirreljme/jvm/mle/brackets/TracePointBracket;)Ljava/lang/String;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return __thread.asVMObject(MLEObjects.debugTrace(__args[0]).getTrace().className());
        }
    }
    ,
    POINT_FILE("pointFile:(Lcc/squirreljme/jvm/mle/brackets/TracePointBracket;)Ljava/lang/String;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return __thread.asVMObject(MLEObjects.debugTrace(__args[0]).getTrace().file());
        }
    }
    ,
    POINT_JAVA_ADDRESS("pointJavaAddress:(Lcc/squirreljme/jvm/mle/brackets/TracePointBracket;)I"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return MLEObjects.debugTrace(__args[0]).getTrace().byteCodeAddress();
        }
    }
    ,
    POINT_JAVA_OPERATION("pointJavaOperation:(Lcc/squirreljme/jvm/mle/brackets/TracePointBracket;)I"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return MLEObjects.debugTrace(__args[0]).getTrace().byteCodeInstruction();
        }
    }
    ,
    POINT_LINE("pointLine:(Lcc/squirreljme/jvm/mle/brackets/TracePointBracket;)I"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return MLEObjects.debugTrace(__args[0]).getTrace().line();
        }
    }
    ,
    POINT_METHOD_NAME("pointMethodName:(Lcc/squirreljme/jvm/mle/brackets/TracePointBracket;)Ljava/lang/String;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return __thread.asVMObject(MLEObjects.debugTrace(__args[0]).getTrace().methodName());
        }
    }
    ,
    POINT_METHOD_TYPE("pointMethodType:(Lcc/squirreljme/jvm/mle/brackets/TracePointBracket;)Ljava/lang/String;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return __thread.asVMObject(MLEObjects.debugTrace(__args[0]).getTrace().methodDescriptor());
        }
    }
    ,
    TRACE_STACK("traceStack:()[Lcc/squirreljme/jvm/mle/brackets/TracePointBracket;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            System.err.println("*******************************");
            __thread.thread.printStackTrace(System.err);
            System.err.println("*******************************");
            System.err.flush();
            CallTraceElement[] trace = __thread.thread.getStackTrace();
            int n2 = trace.length;
            SpringObject[] rv = new TracePointObject[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                rv[i2] = new TracePointObject(__thread.machine, trace[i2]);
            }
            return __thread.asVMObjectArray(__thread.loadClass("[Lcc/squirreljme/jvm/mle/brackets/TracePointBracket;"), rv);
        }
    }
    ,
    TRACE_THROWABLE(MLEDispatcher.methodKey("traceThrowable", TracePointBracket[].class, Throwable.class)){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return TRACE_STACK.handle(__thread, new Object[0]);
        }
    }
    ,
    VERBOSE("verbose:(I)I"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return __thread.verbose().add(__thread.thread.numFrames() - 1, (Integer)__args[0]);
        }
    }
    ,
    VERBOSE_INTERNAL_THREAD("verboseInternalThread:(I)I"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            __thread.machine._verboseInternal = (Integer)__args[0];
            return Integer.MIN_VALUE;
        }
    }
    ,
    VERBOSE_STOP("verboseStop:(I)V"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            int id = (Integer)__args[0];
            if (id == Integer.MIN_VALUE) {
                __thread.machine._verboseInternal = 0;
            } else {
                __thread.verbose().remove(id);
            }
            return null;
        }
    };

    protected final String key;

    private MLEDebug(String __key) throws NullPointerException {
        if (__key == null) {
            throw new NullPointerException("NARG");
        }
        this.key = __key;
    }

    @Override
    public String key() {
        return this.key;
    }
}

