/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.vm.springcoat;

import cc.squirreljme.emulator.terminal.InputTerminalPipe;
import cc.squirreljme.emulator.vm.VMSuiteManager;
import cc.squirreljme.jvm.manifest.JavaManifest;
import cc.squirreljme.jvm.mle.brackets.JarPackageBracket;
import cc.squirreljme.jvm.mle.brackets.PipeBracket;
import cc.squirreljme.vm.RawVMClassLibrary;
import cc.squirreljme.vm.VMClassLibrary;
import cc.squirreljme.vm.springcoat.MLEDispatcher;
import cc.squirreljme.vm.springcoat.MLEFunction;
import cc.squirreljme.vm.springcoat.MLEObjects;
import cc.squirreljme.vm.springcoat.SpringArrayObjectByte;
import cc.squirreljme.vm.springcoat.SpringNullObject;
import cc.squirreljme.vm.springcoat.SpringObject;
import cc.squirreljme.vm.springcoat.SpringThreadWorker;
import cc.squirreljme.vm.springcoat.brackets.JarPackageObject;
import cc.squirreljme.vm.springcoat.brackets.PipeObject;
import cc.squirreljme.vm.springcoat.exceptions.SpringMLECallError;
import cc.squirreljme.vm.springcoat.exceptions.SpringVirtualMachineException;
import java.io.IOException;
import java.io.InputStream;

public enum MLEJarPackage implements MLEFunction
{
    CLASS_PATH("classPath:()[Lcc/squirreljme/jvm/mle/brackets/JarPackageBracket;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            VMClassLibrary[] springPath = __thread.machine.classloader.classPath();
            int n2 = springPath.length;
            SpringObject[] rv = new SpringObject[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                rv[i2] = new JarPackageObject(__thread.machine, springPath[i2]);
            }
            return __thread.asVMObjectArray(__thread.resolveClass("[Lcc/squirreljme/jvm/mle/brackets/JarPackageBracket;"), rv);
        }
    }
    ,
    EQUALS("equals:(Lcc/squirreljme/jvm/mle/brackets/JarPackageBracket;Lcc/squirreljme/jvm/mle/brackets/JarPackageBracket;)Z"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return MLEObjects.jarPackage(__args[0]).library() == MLEObjects.jarPackage(__args[1]).library();
        }
    }
    ,
    LIBRARIES("libraries:()[Lcc/squirreljme/jvm/mle/brackets/JarPackageBracket;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            VMSuiteManager suites = __thread.machine.suites;
            String[] names = suites.listLibraryNames();
            int n2 = names.length;
            SpringObject[] result = new SpringObject[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                result[i2] = new JarPackageObject(__thread.machine, suites.loadLibrary(names[i2]));
            }
            return __thread.asVMObjectArray(__thread.resolveClass("[Lcc/squirreljme/jvm/mle/brackets/JarPackageBracket;"), result);
        }
    }
    ,
    LIBRARY_ID("libraryId:(Lcc/squirreljme/jvm/mle/brackets/JarPackageBracket;)I"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return __thread.machine.suites.libraryId(MLEObjects.jarPackage(__args[0]).library());
        }
    }
    ,
    LIBRARY_PATH("libraryPath:(Lcc/squirreljme/jvm/mle/brackets/JarPackageBracket;)Ljava/lang/String;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return MLEObjects.jarPackage(__args[0]).library().name();
        }
    }
    ,
    OPEN_RESOURCE(MLEDispatcher.methodKey("openResourcePipe", PipeBracket.class, JarPackageBracket.class, String.class)){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            JarPackageObject jar = MLEObjects.jarPackage(__args[0]);
            String rcName = __thread.asNativeObject(String.class, __args[1]);
            if (rcName == null) {
                throw new SpringMLECallError("Null resource string.");
            }
            try {
                InputStream in = jar.library().resourceAsStream(rcName);
                if (in == null) {
                    return SpringNullObject.NULL;
                }
                return new PipeObject(__thread.machine, new InputTerminalPipe(in));
            }
            catch (IOException e2) {
                throw new SpringVirtualMachineException("Failed to read resource", e2);
            }
        }
    }
    ,
    PREFIX_CODE("prefixCode:(Lcc/squirreljme/jvm/mle/brackets/JarPackageBracket;)I"){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            if (__args[0] == null) {
                throw new SpringMLECallError("No JAR specified.");
            }
            JarPackageObject __jar = MLEObjects.jarPackage(__args[0]);
            try (InputStream in = __jar.library().resourceAsStream("META-INF/MANIFEST.MF");){
                if (in == null) {
                    Integer n2 = -1;
                    return n2;
                }
                JavaManifest manifest = new JavaManifest(in);
                String value = manifest.getMainAttributes().getValue("X-SquirrelJME-PrefixCode");
                if (value == null) {
                    Integer n3 = -1;
                    return n3;
                }
                if (value.length() < 2) {
                    Integer n4 = -1;
                    return n4;
                }
                char a2 = value.charAt(0);
                char b2 = value.charAt(1);
                Integer n5 = Character.digit(a2, 36) * 36 + Character.digit(b2, 36);
                return n5;
            }
            catch (IOException ignored) {
                return -1;
            }
        }
    }
    ,
    RAW_DATA("rawData:(Lcc/squirreljme/jvm/mle/brackets/JarPackageBracket;I[BII)I"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            if (__args[0] == null) {
                throw new SpringMLECallError("No JAR specified.");
            }
            JarPackageObject __jar = MLEObjects.jarPackage(__args[0]);
            int __jarOffset = (Integer)__args[1];
            byte[] __b = ((SpringArrayObjectByte)__args[2]).array();
            int __o = (Integer)__args[3];
            int __l = (Integer)__args[4];
            if (__jarOffset < 0 || __b == null || __o < 0 || __l < 0 || __o + __l > __b.length) {
                throw new SpringMLECallError("Invalid parameters.");
            }
            RawVMClassLibrary lib = MLEObjects.libraryRaw(__jar.library());
            if (lib == null) {
                return -1;
            }
            try {
                lib.rawData(__jarOffset, __b, __o, __l);
                return __l;
            }
            catch (Throwable __t) {
                __t.printStackTrace();
                return -1;
            }
        }
    }
    ,
    RAW_SIZE("rawSize:(Lcc/squirreljme/jvm/mle/brackets/JarPackageBracket;)I"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            if (__args[0] == null) {
                throw new SpringMLECallError("No JAR specified.");
            }
            JarPackageObject jar = MLEObjects.jarPackage(__args[0]);
            RawVMClassLibrary lib = MLEObjects.libraryRaw(jar.library());
            if (lib == null) {
                return -1;
            }
            try {
                return lib.rawSize();
            }
            catch (Throwable __t) {
                __t.printStackTrace();
                return -1;
            }
        }
    };

    protected final String key;

    private MLEJarPackage(String __key) throws NullPointerException {
        if (__key == null) {
            throw new NullPointerException("NARG");
        }
        this.key = __key;
    }

    @Override
    public String key() {
        return this.key;
    }
}

