/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.vm.springcoat;

import cc.squirreljme.jvm.mle.MidiShelf;
import cc.squirreljme.jvm.mle.brackets.MidiDeviceBracket;
import cc.squirreljme.jvm.mle.brackets.MidiPortBracket;
import cc.squirreljme.jvm.mle.exceptions.MLECallError;
import cc.squirreljme.vm.springcoat.MLEFunction;
import cc.squirreljme.vm.springcoat.MLEObjects;
import cc.squirreljme.vm.springcoat.SpringArrayObject;
import cc.squirreljme.vm.springcoat.SpringArrayObjectByte;
import cc.squirreljme.vm.springcoat.SpringNullObject;
import cc.squirreljme.vm.springcoat.SpringThreadWorker;
import cc.squirreljme.vm.springcoat.brackets.MidiDeviceObject;
import cc.squirreljme.vm.springcoat.brackets.MidiPortObject;
import cc.squirreljme.vm.springcoat.exceptions.SpringMLECallError;

public enum MLEMidi implements MLEFunction
{
    DATA_RECEIVE("dataReceive:(Lcc/squirreljme/jvm/mle/brackets/MidiPortBracket;[BII)I"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            try {
                MidiPortBracket port = MLEObjects.midiPort(__args[0]);
                SpringArrayObjectByte buf = (SpringArrayObjectByte)__args[1];
                int off = (Integer)__args[2];
                int len = (Integer)__args[3];
                return MidiShelf.dataReceive(port, buf.array(), off, len);
            }
            catch (MLECallError e2) {
                throw new SpringMLECallError(e2.getMessage(), e2);
            }
        }
    }
    ,
    DATA_TRANSMIT("dataTransmit:(Lcc/squirreljme/jvm/mle/brackets/MidiPortBracket;[BII)V"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            try {
                if (__args[0] == SpringNullObject.NULL || __args[1] == SpringNullObject.NULL) {
                    throw new SpringMLECallError("Null arguments.");
                }
                MidiPortBracket port = MLEObjects.midiPort(__args[0]);
                SpringArrayObjectByte buf = (SpringArrayObjectByte)__args[1];
                int off = (Integer)__args[2];
                int len = (Integer)__args[3];
                MidiShelf.dataTransmit(port, buf.array(), off, len);
                return null;
            }
            catch (MLECallError e2) {
                throw new SpringMLECallError(e2.getMessage(), e2);
            }
        }
    }
    ,
    DEVICE_NAME("deviceName:(Lcc/squirreljme/jvm/mle/brackets/MidiDeviceBracket;)Ljava/lang/String;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            try {
                MidiDeviceBracket device = MLEObjects.midiDevice(__args[0]);
                return MidiShelf.deviceName(device);
            }
            catch (MLECallError e2) {
                throw new SpringMLECallError(e2.getMessage(), e2);
            }
        }
    }
    ,
    DEVICES("devices:()[Lcc/squirreljme/jvm/mle/brackets/MidiDeviceBracket;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            try {
                MidiDeviceBracket[] devices = MidiShelf.devices();
                int len = devices.length;
                SpringArrayObject result = __thread.allocateArray(__thread.resolveClass("[Lcc/squirreljme/jvm/mle/brackets/MidiDeviceBracket;"), len);
                for (int i2 = 0; i2 < len; ++i2) {
                    result.set(i2, new MidiDeviceObject(__thread.machine, devices[i2]));
                }
                return result;
            }
            catch (MLECallError e2) {
                throw new SpringMLECallError(e2.getMessage(), e2);
            }
        }
    }
    ,
    PORTS("ports:(Lcc/squirreljme/jvm/mle/brackets/MidiDeviceBracket;Z)[Lcc/squirreljme/jvm/mle/brackets/MidiPortBracket;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            try {
                MidiDeviceBracket device = MLEObjects.midiDevice(__args[0]);
                boolean isTransmit = (Integer)__args[1] != 0;
                MidiPortBracket[] ports = MidiShelf.ports(device, isTransmit);
                int len = ports.length;
                SpringArrayObject result = __thread.allocateArray(__thread.resolveClass("[Lcc/squirreljme/jvm/mle/brackets/MidiPortBracket;"), len);
                for (int i2 = 0; i2 < len; ++i2) {
                    result.set(i2, new MidiPortObject(__thread.machine, ports[i2]));
                }
                return result;
            }
            catch (MLECallError e2) {
                throw new SpringMLECallError(e2.getMessage(), e2);
            }
        }
    };

    protected final String key;

    private MLEMidi(String __key) throws NullPointerException {
        if (__key == null) {
            throw new NullPointerException("NARG");
        }
        this.key = __key;
    }

    @Override
    public String key() {
        return this.key;
    }
}

