/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.vm.springcoat;

import cc.squirreljme.jvm.mle.ObjectShelf;
import cc.squirreljme.jvm.mle.exceptions.MLECallError;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.vm.springcoat.MLEDispatcher;
import cc.squirreljme.vm.springcoat.MLEFunction;
import cc.squirreljme.vm.springcoat.MLEObjects;
import cc.squirreljme.vm.springcoat.MLEThread;
import cc.squirreljme.vm.springcoat.SpringArrayObject;
import cc.squirreljme.vm.springcoat.SpringArrayObjectBoolean;
import cc.squirreljme.vm.springcoat.SpringArrayObjectByte;
import cc.squirreljme.vm.springcoat.SpringArrayObjectChar;
import cc.squirreljme.vm.springcoat.SpringArrayObjectDouble;
import cc.squirreljme.vm.springcoat.SpringArrayObjectFloat;
import cc.squirreljme.vm.springcoat.SpringArrayObjectInteger;
import cc.squirreljme.vm.springcoat.SpringArrayObjectLong;
import cc.squirreljme.vm.springcoat.SpringArrayObjectShort;
import cc.squirreljme.vm.springcoat.SpringClass;
import cc.squirreljme.vm.springcoat.SpringNullObject;
import cc.squirreljme.vm.springcoat.SpringObject;
import cc.squirreljme.vm.springcoat.SpringThread;
import cc.squirreljme.vm.springcoat.SpringThreadWorker;
import cc.squirreljme.vm.springcoat.exceptions.SpringMLECallError;
import net.multiphasicapps.classfile.MethodDescriptor;

public enum MLEObject implements MLEFunction
{
    ARRAY_CHECK_STORE("arrayCheckStore:(Ljava/lang/Object;Ljava/lang/Object;)Z"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            if (__args[0] == null || __args[0] == SpringNullObject.NULL) {
                throw new SpringMLECallError("Null object.");
            }
            if (!(__args[0] instanceof SpringObject)) {
                throw new SpringMLECallError(String.format("Object not valid? %s (%s)", __args[0], __args[0].getClass()));
            }
            SpringObject array = (SpringObject)__args[0];
            SpringClass arrayType = array.type();
            if (arrayType.dimensions() <= 0) {
                throw new SpringMLECallError("Object not an array? " + array);
            }
            if (__args[1] == null || __args[1] == SpringNullObject.NULL) {
                return true;
            }
            if (!(__args[1] instanceof SpringObject)) {
                throw new SpringMLECallError(String.format("Value is not an object? %s [for array %s]", __args[1], array));
            }
            SpringObject value = (SpringObject)__args[1];
            SpringClass targetType = value.type();
            return arrayType.componentType().isAssignableFrom(targetType);
        }
    }
    ,
    ARRAY_CLONE(MLEDispatcher.methodKey("arrayClone", Object.class, Object.class)){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            SpringArrayObject array = MLEObjects.array(__args[0]);
            int n2 = array.length();
            SpringArrayObject cloned = __thread.allocateArray(array.type(), n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                cloned.set(i2, array.get(Object.class, i2));
            }
            return cloned;
        }
    }
    ,
    ARRAY_COPY_BOOLEAN("arrayCopy:([ZI[ZII)V"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            MLEObject.__arrayCopy(SpringArrayObjectBoolean.class, __args[0], (Integer)__args[1], __args[2], (Integer)__args[3], (Integer)__args[4]);
            return null;
        }
    }
    ,
    ARRAY_COPY_BYTE("arrayCopy:([BI[BII)V"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            MLEObject.__arrayCopy(SpringArrayObjectByte.class, __args[0], (Integer)__args[1], __args[2], (Integer)__args[3], (Integer)__args[4]);
            return null;
        }
    }
    ,
    ARRAY_COPY_SHORT("arrayCopy:([SI[SII)V"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            MLEObject.__arrayCopy(SpringArrayObjectShort.class, __args[0], (Integer)__args[1], __args[2], (Integer)__args[3], (Integer)__args[4]);
            return null;
        }
    }
    ,
    ARRAY_COPY_CHAR("arrayCopy:([CI[CII)V"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            MLEObject.__arrayCopy(SpringArrayObjectChar.class, __args[0], (Integer)__args[1], __args[2], (Integer)__args[3], (Integer)__args[4]);
            return null;
        }
    }
    ,
    ARRAY_COPY_INTEGER("arrayCopy:([II[III)V"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            MLEObject.__arrayCopy(SpringArrayObjectInteger.class, __args[0], (Integer)__args[1], __args[2], (Integer)__args[3], (Integer)__args[4]);
            return null;
        }
    }
    ,
    ARRAY_COPY_LONG("arrayCopy:([JI[JII)V"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            MLEObject.__arrayCopy(SpringArrayObjectLong.class, __args[0], (Integer)__args[1], __args[2], (Integer)__args[3], (Integer)__args[4]);
            return null;
        }
    }
    ,
    ARRAY_COPY_FLOAT("arrayCopy:([FI[FII)V"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            MLEObject.__arrayCopy(SpringArrayObjectFloat.class, __args[0], (Integer)__args[1], __args[2], (Integer)__args[3], (Integer)__args[4]);
            return null;
        }
    }
    ,
    ARRAY_COPY_DOUBLE("arrayCopy:([DI[DII)V"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            MLEObject.__arrayCopy(SpringArrayObjectDouble.class, __args[0], (Integer)__args[1], __args[2], (Integer)__args[3], (Integer)__args[4]);
            return null;
        }
    }
    ,
    ARRAY_FILL_BOOLEAN("arrayFill:([ZIIZ)V"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            MLEObject.__arrayFill(SpringArrayObjectBoolean.class, __args[0], (Integer)__args[1], (Integer)__args[2], __args[3]);
            return null;
        }
    }
    ,
    ARRAY_FILL_BYTE("arrayFill:([BIIB)V"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            MLEObject.__arrayFill(SpringArrayObjectByte.class, __args[0], (Integer)__args[1], (Integer)__args[2], __args[3]);
            return null;
        }
    }
    ,
    ARRAY_FILL_SHORT("arrayFill:([SIIS)V"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            MLEObject.__arrayFill(SpringArrayObjectShort.class, __args[0], (Integer)__args[1], (Integer)__args[2], __args[3]);
            return null;
        }
    }
    ,
    ARRAY_FILL_CHAR("arrayFill:([CIIC)V"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            MLEObject.__arrayFill(SpringArrayObjectChar.class, __args[0], (Integer)__args[1], (Integer)__args[2], __args[3]);
            return null;
        }
    }
    ,
    ARRAY_FILL_INT("arrayFill:([IIII)V"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            MLEObject.__arrayFill(SpringArrayObjectInteger.class, __args[0], (Integer)__args[1], (Integer)__args[2], __args[3]);
            return null;
        }
    }
    ,
    ARRAY_FILL_LONG("arrayFill:([JIIJ)V"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            MLEObject.__arrayFill(SpringArrayObjectLong.class, __args[0], (Integer)__args[1], (Integer)__args[2], __args[3]);
            return null;
        }
    }
    ,
    ARRAY_FILL_FLOAT("arrayFill:([FIIF)V"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            MLEObject.__arrayFill(SpringArrayObjectFloat.class, __args[0], (Integer)__args[1], (Integer)__args[2], __args[3]);
            return null;
        }
    }
    ,
    ARRAY_FILL_DOUBLE("arrayFill:([DIID)V"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            MLEObject.__arrayFill(SpringArrayObjectDouble.class, __args[0], (Integer)__args[1], (Integer)__args[2], __args[3]);
            return null;
        }
    }
    ,
    ARRAY_INTS_TO_BYTES("arrayIntsToBytes:([II[BII)V"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            SpringArrayObjectInteger source = MLEObjects.notNull(SpringArrayObjectInteger.class, __args[0]);
            int sourceOff = (Integer)__args[1];
            SpringArrayObjectByte dest = MLEObjects.notNull(SpringArrayObjectByte.class, __args[2]);
            int destOff = (Integer)__args[3];
            int len = (Integer)__args[4];
            ObjectShelf.arrayIntsToBytes(source.array(), sourceOff, dest.array(), destOff, len);
            return null;
        }
    }
    ,
    ARRAY_LENGTH("arrayLength:(Ljava/lang/Object;)I"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            SpringObject object = MLEObjects.notNull(__args[0]);
            if (object instanceof SpringArrayObject) {
                return ((SpringArrayObject)object).length();
            }
            return -1;
        }
    }
    ,
    ARRAY_NEW("arrayNew:(Ljava/lang/Class;I)Ljava/lang/Object;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            int len = (Integer)__args[1];
            if (len < 0) {
                throw new SpringMLECallError("Negative array size.");
            }
            SpringClass type = MLEObjects.type(__args[0]);
            if (!type.isArray()) {
                throw new SpringMLECallError("Type not an array.");
            }
            return __thread.allocateArray(type, len);
        }
    }
    ,
    HOLDS_LOCK("holdsLock:(Ljava/lang/Thread;Ljava/lang/Object;)Z"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            SpringThread vmThread = MLEObjects.threadVm(MLEThread.TO_VM_THREAD.handle(__thread, __args[0])).getThread();
            SpringObject target = (SpringObject)__args[1];
            if (target == null || target == SpringNullObject.NULL) {
                throw new SpringMLECallError("Target object is null.");
            }
            return target.monitor().isHeldBy(vmThread);
        }
    }
    ,
    IDENTITY_HASH_CODE("identityHashCode:(Ljava/lang/Object;)I"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            SpringObject object = (SpringObject)__args[0];
            return System.identityHashCode(MLEObjects.notNull(object));
        }
    }
    ,
    IS_ARRAY("isInstance:(Ljava/lang/Object;Z"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            SpringObject object = MLEObjects.notNull(__args[0]);
            if (object instanceof SpringArrayObject) {
                return 1;
            }
            return 0;
        }
    }
    ,
    IS_INSTANCE("isInstance:(Ljava/lang/Object;Ljava/lang/Class;)Z"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            throw Debugging.todo();
        }
    }
    ,
    NEW_INSTANCE("newInstance:(Ljava/lang/Class;)Ljava/lang/Object;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            SpringClass type = MLEObjects.type(__args[0]);
            if (type.isArray()) {
                throw new SpringMLECallError("Cannot newInstance array");
            }
            return __thread.newInstance(type, new MethodDescriptor("()V"), new Object[0]);
        }
    }
    ,
    NOTIFY("notify:(Ljava/lang/Object;Z)I"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            boolean notifyAll;
            SpringObject target = MLEObjects.notNull(__args[0]);
            boolean bl2 = notifyAll = (Integer)__args[1] != 0;
            if (__thread.verboseCheck(4096)) {
                __thread.verboseEmit("Monitor Notify: %s on %s (%s)", target, __thread, notifyAll ? "all" : "once");
            }
            return target.monitor().monitorNotify(__thread.thread, notifyAll);
        }
    }
    ,
    WAIT("wait:(Ljava/lang/Object;JI)I"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            SpringObject target = MLEObjects.notNull(__args[0]);
            long ms = (Long)__args[1];
            int ns = (Integer)__args[2];
            if (__thread.verboseCheck(2048)) {
                __thread.verboseEmit("Monitor Wait: %s on %s (for %d ms %d ns)", target, __thread, ms, ns);
            }
            return target.monitor().monitorWait(__thread.thread, ms, ns);
        }
    };

    protected final String key;

    private MLEObject(String __key) throws NullPointerException {
        if (__key == null) {
            throw new NullPointerException("NARG");
        }
        this.key = __key;
    }

    @Override
    public String key() {
        return this.key;
    }

    static <A extends SpringArrayObject> void __arrayCopy(Class<A> __classy, Object __src, int __srcOff, Object __dest, int __destOff, int __len) throws SpringMLECallError {
        if (!__classy.isInstance(__src) || !__classy.isInstance(__dest)) {
            throw new SpringMLECallError("Null array.");
        }
        if (__srcOff < 0 || __destOff < 0 || __len < 0) {
            throw new SpringMLECallError("Negative offset or length.");
        }
        try {
            System.arraycopy(((SpringArrayObject)__src).array(), __srcOff, ((SpringArrayObject)__dest).array(), __destOff, __len);
        }
        catch (ArrayStoreException | IndexOutOfBoundsException | NullPointerException e2) {
            throw new SpringMLECallError("Invalid copy.", e2);
        }
    }

    static <A extends SpringArrayObject> void __arrayFill(Class<A> __type, Object __b, int __o, int __l, Object __v) throws MLECallError {
        if (__b == null || __v == null) {
            throw new SpringMLECallError("NARG");
        }
        if (!__type.isInstance(__b)) {
            throw new SpringMLECallError("Not a " + __type);
        }
        SpringArrayObject array = (SpringArrayObject)__type.cast(__b);
        if (__o < 0 || __l < 0 || __o + __l > array.length()) {
            throw new SpringMLECallError("IOOB");
        }
        for (int i2 = 0; i2 < __l; ++i2) {
            array.set(__o + i2, __v);
        }
    }
}

