/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.vm.springcoat;

import cc.squirreljme.jvm.mle.RuntimeShelf;
import cc.squirreljme.jvm.mle.exceptions.MLECallError;
import cc.squirreljme.runtime.cldc.lang.LineEndingUtils;
import cc.squirreljme.vm.springcoat.MLEFunction;
import cc.squirreljme.vm.springcoat.MLEObjects;
import cc.squirreljme.vm.springcoat.SpringThreadWorker;
import cc.squirreljme.vm.springcoat.exceptions.SpringMLECallError;

public enum MLERuntime implements MLEFunction
{
    BROWSE_LOCAL("browseLocal:(ZLjava/lang/String;)V"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            try {
                RuntimeShelf.browseLocal((Integer)__args[0] != 0, MLEObjects.string(__args[1]));
            }
            catch (MLECallError __e) {
                throw new SpringMLECallError(__e.getMessage(), __e);
            }
            return null;
        }
    }
    ,
    BYTE_ORDER("byteOrder:()I"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return (byte)0;
        }
    }
    ,
    CURRENT_TIME_MILLIS("currentTimeMillis:()J"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return System.currentTimeMillis();
        }
    }
    ,
    ENCODING("encoding:()I"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return (byte)1;
        }
    }
    ,
    EXIT("exit:(I)V"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            __thread.machine.exit((Integer)__args[0]);
            return null;
        }
    }
    ,
    GARBAGE_COLLECT("garbageCollect:()V"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            Runtime.getRuntime().gc();
            return null;
        }
    }
    ,
    LINE_ENDING("lineEnding:()I"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return LineEndingUtils.toType(System.getProperty("line.separator"));
        }
    }
    ,
    LOCALE("locale:()I"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            String country = System.getProperty("user.country", "unknown");
            String lang = System.getProperty("user.language", "unknown");
            switch (country) {
                case "US": {
                    switch (lang) {
                        case "en": {
                            return (byte)1;
                        }
                    }
                    return (byte)0;
                }
            }
            return (byte)0;
        }
    }
    ,
    MEMORY_PROFILE("memoryProfile:()I"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return (byte)0;
        }
    }
    ,
    NANO_TIME("nanoTime:()J"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return System.nanoTime();
        }
    }
    ,
    PHONE_MODEL("phoneModel:()I"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return (byte)0;
        }
    }
    ,
    SYSTEM_ENV("systemEnv:(Ljava/lang/String;)Ljava/lang/String;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            String key = __thread.asNativeObject(String.class, __args[0]);
            if (key == null) {
                throw new SpringMLECallError("Null key.");
            }
            return __thread.asVMObject(RuntimeShelf.systemEnv(key));
        }
    }
    ,
    SYSTEM_PROPERTY("systemProperty:(Ljava/lang/String;)Ljava/lang/String;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            String key = __thread.asNativeObject(String.class, __args[0]);
            if (key == null) {
                throw new SpringMLECallError("Null key.");
            }
            return __thread.machine._sysproperties.get(key);
        }
    }
    ,
    VM_DESCRIPTION("vmDescription:(I)Ljava/lang/String;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            int index = (Integer)__args[0];
            if (index < 0 || index >= 15) {
                throw new SpringMLECallError("Index out of range: " + index);
            }
            switch (index) {
                case 6: {
                    return null;
                }
                case 9: {
                    return "springcoat/" + System.getProperty("os.arch");
                }
                case 7: {
                    return System.getProperty("os.name");
                }
                case 8: {
                    return System.getProperty("os.version");
                }
                case 4: {
                    return "xer@multiphasicapps.net";
                }
                case 14: {
                    return "non-native pure interpreter";
                }
                case 2: {
                    return __thread.machine.tasks.vmName();
                }
                case 1: {
                    return __thread.machine.tasks.vmVersion();
                }
                case 5: {
                    return "https://squirreljme.cc/";
                }
                case 3: {
                    return "Stephanie Gawroriski";
                }
                case 13: {
                    return System.getProperty("file.separator");
                }
            }
            return null;
        }
    }
    ,
    VM_STATISTIC("vmStatistic:(I)J"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            int index = (Integer)__args[0];
            if (index < 0 || index >= 5) {
                throw new SpringMLECallError("Index out of range: " + index);
            }
            try {
                return RuntimeShelf.vmStatistic(index);
            }
            catch (MLECallError e2) {
                throw new SpringMLECallError(e2.getMessage(), e2);
            }
        }
    }
    ,
    VM_TYPE("vmType:()I"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return (byte)2;
        }
    };

    protected final String key;

    private MLERuntime(String __key) throws NullPointerException {
        if (__key == null) {
            throw new NullPointerException("NARG");
        }
        this.key = __key;
    }

    @Override
    public String key() {
        return this.key;
    }
}

