/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.vm.springcoat;

import cc.squirreljme.vm.springcoat.MLEFunction;
import cc.squirreljme.vm.springcoat.MLEObjects;
import cc.squirreljme.vm.springcoat.SpringArrayObjectChar;
import cc.squirreljme.vm.springcoat.SpringStringObject;
import cc.squirreljme.vm.springcoat.SpringThreadWorker;
import cc.squirreljme.vm.springcoat.exceptions.SpringMLECallError;
import java.util.Map;

public enum MLEString implements MLEFunction
{
    CHAR_AT("stringCharAt:(Ljava/lang/String;I)C"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            SpringStringObject object = MLEObjects.notNull(SpringStringObject.class, __args[0]);
            int index = (Integer)__args[1];
            try {
                return Character.valueOf(object.toString().charAt(index));
            }
            catch (IndexOutOfBoundsException __e) {
                throw new SpringMLECallError("Index out of bounds.", __e);
            }
        }
    }
    ,
    EQUALS("stringEquals:(Ljava/lang/String;Ljava/lang/String;)Z"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            SpringStringObject a2 = MLEObjects.notNull(SpringStringObject.class, __args[0]);
            SpringStringObject b2 = MLEObjects.notNull(SpringStringObject.class, __args[1]);
            return a2.toString().equals(b2.toString()) ? 1 : 0;
        }
    }
    ,
    HASH("stringHash:(Ljava/lang/String;)I"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            SpringStringObject object = MLEObjects.notNull(SpringStringObject.class, __args[0]);
            return object.toString().hashCode();
        }
    }
    ,
    INIT("stringInit:(Ljava/lang/String;)V"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            SpringStringObject object = MLEObjects.notNull(SpringStringObject.class, __args[0]);
            object.optional("");
            return null;
        }
    }
    ,
    INIT_CHAR("stringInit:(Ljava/lang/String;[CII)V"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            SpringStringObject object = MLEObjects.notNull(SpringStringObject.class, __args[0]);
            SpringArrayObjectChar c2 = MLEObjects.notNull(SpringArrayObjectChar.class, __args[1]);
            int o2 = (Integer)__args[2];
            int l2 = (Integer)__args[3];
            try {
                object.set(new String(c2.array(), o2, l2));
            }
            catch (IndexOutOfBoundsException | NullPointerException __e) {
                throw new SpringMLECallError("Characters not valid.", __e);
            }
            return null;
        }
    }
    ,
    INIT_STRING("stringInit:(Ljava/lang/String;Ljava/lang/String;)V"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            SpringStringObject object = MLEObjects.notNull(SpringStringObject.class, __args[0]);
            SpringStringObject string = MLEObjects.notNull(SpringStringObject.class, __args[1]);
            try {
                object.set(string.toString());
            }
            catch (NullPointerException __e) {
                throw new SpringMLECallError("String not valid.", __e);
            }
            return null;
        }
    }
    ,
    IS_INTERN("stringIsIntern:(Ljava/lang/String;)Z"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            Map<String, SpringStringObject> stringMap;
            SpringStringObject object = MLEObjects.notNull(SpringStringObject.class, __args[0]);
            Map<String, SpringStringObject> map = stringMap = __thread.machine.__stringMap();
            synchronized (map) {
                return stringMap.containsValue(object) ? 1 : 0;
            }
        }
    }
    ,
    LENGTH("stringLength:(Ljava/lang/String;)I"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            SpringStringObject object = MLEObjects.notNull(SpringStringObject.class, __args[0]);
            return object.toString().length();
        }
    }
    ,
    TO_CHAR("stringToChar:(Ljava/lang/String;I[CII)V"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            SpringStringObject source = MLEObjects.notNull(SpringStringObject.class, __args[0]);
            int sourceOff = (Integer)__args[1];
            SpringArrayObjectChar dest = MLEObjects.notNull(SpringArrayObjectChar.class, __args[2]);
            int destOff = (Integer)__args[3];
            int len = (Integer)__args[4];
            try {
                source.toString().getChars(sourceOff, sourceOff + len, dest.array(), destOff);
            }
            catch (IndexOutOfBoundsException __e) {
                throw new SpringMLECallError("Out of bounds.", __e);
            }
            return null;
        }
    }
    ,
    VALUE_OF_CHAR("stringValueOf:(Z[CII)Ljava/lang/String;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            boolean intern = (Integer)__args[0] != 0;
            SpringArrayObjectChar c2 = MLEObjects.notNull(SpringArrayObjectChar.class, __args[1]);
            int o2 = (Integer)__args[2];
            int l2 = (Integer)__args[3];
            try {
                return __thread.stringObject(intern, new String(c2.array(), o2, l2));
            }
            catch (IndexOutOfBoundsException | NullPointerException __e) {
                throw new SpringMLECallError("String not valid.", __e);
            }
        }
    }
    ,
    VALUE_OF_STRING("stringValueOf:(ZLjava/lang/String;)Ljava/lang/String;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            boolean intern = (Integer)__args[0] != 0;
            SpringStringObject string = MLEObjects.notNull(SpringStringObject.class, __args[1]);
            return __thread.stringObject(intern, string.toString());
        }
    };

    protected final String key;

    private MLEString(String __key) throws NullPointerException {
        if (__key == null) {
            throw new NullPointerException("NARG");
        }
        this.key = __key;
    }

    @Override
    public String key() {
        return this.key;
    }
}

