/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.vm.springcoat;

import cc.squirreljme.emulator.MLECallWouldFail;
import cc.squirreljme.runtime.cldc.debug.CallTraceElement;
import cc.squirreljme.vm.VMClassLibrary;
import cc.squirreljme.vm.springcoat.CallTraceStorage;
import cc.squirreljme.vm.springcoat.MLEFunction;
import cc.squirreljme.vm.springcoat.MLEObjects;
import cc.squirreljme.vm.springcoat.SpringArrayObjectByte;
import cc.squirreljme.vm.springcoat.SpringArrayObjectGeneric;
import cc.squirreljme.vm.springcoat.SpringMachine;
import cc.squirreljme.vm.springcoat.SpringObject;
import cc.squirreljme.vm.springcoat.SpringThreadWorker;
import cc.squirreljme.vm.springcoat.brackets.TracePointObject;
import cc.squirreljme.vm.springcoat.exceptions.SpringMLECallError;
import java.util.LinkedHashMap;

public enum MLETask implements MLEFunction
{
    ACTIVE("active:()[Lcc/squirreljme/jvm/mle/brackets/TaskBracket;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            SpringMachine[] tasks = __thread.machine.taskManager().tasks();
            int n2 = tasks.length;
            SpringObject[] result = new SpringObject[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                result[i2] = tasks[i2].taskObject(__thread.machine);
            }
            return __thread.asVMObjectArray(__thread.resolveClass("[Lcc/squirreljme/jvm/mle/brackets/TaskBracket;"), result);
        }
    }
    ,
    CURRENT("current:()Lcc/squirreljme/jvm/mle/brackets/TaskBracket;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return __thread.machine.taskObject(__thread.machine);
        }
    }
    ,
    EQUALS("equals:(Lcc/squirreljme/jvm/mle/brackets/TaskBracket;Lcc/squirreljme/jvm/mle/brackets/TaskBracket;)Z"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return MLEObjects.task(__args[0]).getMachine() == MLEObjects.task(__args[1]).getMachine();
        }
    }
    ,
    EXIT_CODE("exitCode:(Lcc/squirreljme/jvm/mle/brackets/TaskBracket;)I"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return MLEObjects.task(__args[0]).getMachine().getExitCode();
        }
    }
    ,
    GET_TRACE("getTrace:(Lcc/squirreljme/jvm/mle/brackets/TaskBracket;[Ljava/lang/String;)[Lcc/squirreljme/jvm/mle/brackets/TracePointBracket;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            if (!(__args[1] instanceof SpringArrayObjectGeneric)) {
                throw new SpringMLECallError("Not an array.");
            }
            SpringMachine machine = MLEObjects.task(__args[0]).getMachine();
            SpringArrayObjectGeneric array = (SpringArrayObjectGeneric)__args[1];
            if (array.length() <= 0) {
                throw new SpringMLECallError("Empty array.");
            }
            CallTraceStorage storage = machine.getTrace();
            if (storage == null) {
                return null;
            }
            array.set(0, __thread.asVMObject(storage.message));
            CallTraceElement[] inTraces = storage.trace();
            int len = inTraces.length;
            SpringObject[] outTraces = new SpringObject[len];
            for (int i2 = 0; i2 < len; ++i2) {
                outTraces[i2] = new TracePointObject(__thread.machine, inTraces[i2]);
            }
            return __thread.asVMObjectArray(__thread.loadClass("[Lcc/squirreljme/jvm/mle/brackets/TracePointBracket;"), outTraces);
        }
    }
    ,
    READ("read:(Lcc/squirreljme/jvm/mle/brackets/TaskBracket;I[BII)I"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            if (!(__args[2] instanceof SpringArrayObjectByte)) {
                throw new SpringMLECallError("Not a byte array.");
            }
            SpringMachine machine = MLEObjects.task(__args[0]).getMachine();
            int fd = (Integer)__args[1];
            SpringArrayObjectByte buf = (SpringArrayObjectByte)__args[2];
            int off = (Integer)__args[3];
            int len = (Integer)__args[4];
            try {
                return machine.terminalPipes.mleRead(fd, buf.array(), off, len);
            }
            catch (MLECallWouldFail e2) {
                throw new SpringMLECallError(e2.getMessage(), e2);
            }
        }
    }
    ,
    START("start:([Lcc/squirreljme/jvm/mle/brackets/JarPackageBracket;Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;II)Lcc/squirreljme/jvm/mle/brackets/TaskBracket;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            if (!(__args[0] instanceof SpringArrayObjectGeneric)) {
                throw new SpringMLECallError("Classpath not array.");
            }
            if (!(__args[2] instanceof SpringArrayObjectGeneric)) {
                throw new SpringMLECallError("Main Args not array.");
            }
            if (!(__args[3] instanceof SpringArrayObjectGeneric)) {
                throw new SpringMLECallError("SysProps not array.");
            }
            SpringArrayObjectGeneric rawClasspath = (SpringArrayObjectGeneric)__args[0];
            String mainClass = __thread.asNativeObject(String.class, __args[1]);
            SpringArrayObjectGeneric rawMainArgs = (SpringArrayObjectGeneric)__args[2];
            SpringArrayObjectGeneric rawSysProps = (SpringArrayObjectGeneric)__args[3];
            int stdOutMode = (Integer)__args[4];
            int stdErrMode = (Integer)__args[5];
            if (mainClass == null) {
                throw new SpringMLECallError("No main class.");
            }
            if (rawClasspath.length() < 1) {
                throw new SpringMLECallError("Classpath is empty.");
            }
            if (rawSysProps.length() % 2 != 0) {
                throw new SpringMLECallError("SysProps not in pairs.");
            }
            if (stdOutMode < 0 || stdErrMode < 0 || stdOutMode >= 3 || stdErrMode >= 3) {
                throw new SpringMLECallError("Invalid pipe mode.");
            }
            int numClasspath = rawClasspath.length();
            VMClassLibrary[] classpath = new VMClassLibrary[numClasspath];
            for (int i2 = 0; i2 < numClasspath; ++i2) {
                classpath[i2] = MLEObjects.jarPackage(rawClasspath.get(SpringObject.class, i2)).library();
            }
            if (classpath[0] != __thread.machine.classLoader().rootLibrary()) {
                throw new SpringMLECallError("RootLib is not the same.");
            }
            int numMainArgs = rawMainArgs.length();
            String[] mainArgs = new String[numMainArgs];
            for (int i3 = 0; i3 < numMainArgs; ++i3) {
                String s2 = __thread.asNativeObject(String.class, rawMainArgs.get(SpringObject.class, i3));
                if (s2 == null) {
                    throw new SpringMLECallError("Null mainArg: " + i3);
                }
                mainArgs[i3] = s2;
            }
            int numSysProps = rawSysProps.length();
            String[] sysProps = new String[numSysProps];
            for (int i4 = 0; i4 < numSysProps; ++i4) {
                String s3 = __thread.asNativeObject(String.class, rawSysProps.get(SpringObject.class, i4));
                if (s3 == null) {
                    throw new SpringMLECallError("Null sysProp: " + i4);
                }
                sysProps[i4] = s3;
            }
            LinkedHashMap<String, String> sysPropsMap = new LinkedHashMap<String, String>();
            for (int i5 = 0; i5 < numSysProps; i5 += 2) {
                sysPropsMap.put(sysProps[i5], sysProps[i5 + 1]);
            }
            SpringMachine newMachine = __thread.machine.taskManager().startTask(classpath, mainClass, mainArgs, sysPropsMap, stdOutMode, stdErrMode, true, false);
            return newMachine.taskObject(__thread.machine);
        }
    }
    ,
    STATUS("status:(Lcc/squirreljme/jvm/mle/brackets/TaskBracket;)I"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            SpringMachine machine = MLEObjects.task(__args[0]).getMachine();
            if (machine.isExiting()) {
                return (byte)0;
            }
            return (byte)1;
        }
    };

    protected final String key;

    private MLETask(String __key) throws NullPointerException {
        if (__key == null) {
            throw new NullPointerException("NARG");
        }
        this.key = __key;
    }

    @Override
    public String key() {
        return this.key;
    }
}

