/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.vm.springcoat;

import cc.squirreljme.emulator.profiler.ProfiledFrame;
import cc.squirreljme.jdwp.host.JDWPHostController;
import cc.squirreljme.jdwp.host.trips.JDWPGlobalTrip;
import cc.squirreljme.jdwp.host.trips.JDWPTripThread;
import cc.squirreljme.jdwp.host.trips.JDWPTripVmState;
import cc.squirreljme.runtime.cldc.debug.CallTraceElement;
import cc.squirreljme.vm.springcoat.MLEFunction;
import cc.squirreljme.vm.springcoat.MLEObjects;
import cc.squirreljme.vm.springcoat.SpringArrayObjectGeneric;
import cc.squirreljme.vm.springcoat.SpringFieldStorage;
import cc.squirreljme.vm.springcoat.SpringMachine;
import cc.squirreljme.vm.springcoat.SpringNullObject;
import cc.squirreljme.vm.springcoat.SpringObject;
import cc.squirreljme.vm.springcoat.SpringSimpleObject;
import cc.squirreljme.vm.springcoat.SpringThread;
import cc.squirreljme.vm.springcoat.SpringThreadFrame;
import cc.squirreljme.vm.springcoat.SpringThreadWorker;
import cc.squirreljme.vm.springcoat.brackets.VMThreadObject;
import cc.squirreljme.vm.springcoat.exceptions.SpringMLECallError;
import net.multiphasicapps.classfile.ClassName;
import net.multiphasicapps.classfile.MethodNameAndType;

public enum MLEThread implements MLEFunction
{
    ALIVE_THREAD_COUNT("aliveThreadCount:(ZZ)I"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            SpringMachine machine;
            boolean includeMain = (Integer)__args[0] != 0;
            boolean includeDaemon = (Integer)__args[1] != 0;
            int count = 0;
            SpringMachine springMachine = machine = __thread.machine;
            synchronized (springMachine) {
                for (SpringThread thread : machine.getThreads()) {
                    if (thread.isTerminated() || thread.numFrames() == 0) continue;
                    boolean isMain = thread.isMain();
                    boolean isDaemon = thread.isDaemon();
                    if (!(includeMain && isMain || includeDaemon && isDaemon) && (isMain || isDaemon)) continue;
                    ++count;
                }
            }
            return count;
        }
    }
    ,
    CREATE_VM_THREAD("createVMThread:(Ljava/lang/Thread;Ljava/lang/String;)Lcc/squirreljme/jvm/mle/brackets/VMThreadBracket;"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            SpringMachine machine;
            SpringSimpleObject javaThread = MLEObjects.threadJava(__thread, __args[0]);
            String name = __args[1] == null || __args[1] == SpringNullObject.NULL ? null : __thread.asNativeObject(String.class, __args[1]);
            SpringThread target = null;
            SpringMachine springMachine = machine = __thread.machine;
            synchronized (springMachine) {
                SpringThread[] threads;
                for (SpringThread thread : threads = machine.getThreads()) {
                    SpringObject instance;
                    try {
                        instance = thread.threadInstance();
                    }
                    catch (IllegalStateException ignored) {
                        continue;
                    }
                    if (javaThread != instance) continue;
                    target = thread;
                    break;
                }
                if (threads.length == 1 && !threads[0].hasThreadInstance()) {
                    target = threads[0];
                }
                if (target == null) {
                    target = machine.createThread(name, false, false);
                }
            }
            if (__thread.verboseCheck(16384)) {
                __thread.verboseEmit("New Thread: %s", target);
            }
            if (__thread.verboseCheck(8192)) {
                target._initVerboseFlags = __thread.verbose().activeFlags();
            }
            VMThreadObject vmThread = new VMThreadObject(machine, target);
            target.setThreadInstance(javaThread);
            target.setVMThread(vmThread);
            JDWPHostController jdwp = target.machine().taskManager().jdwpController;
            if (jdwp != null) {
                if (target.machine().rootVm && target.isMain()) {
                    jdwp.trip(JDWPTripVmState.class, JDWPGlobalTrip.VM_STATE).alive(target, true);
                }
                jdwp.trip(JDWPTripThread.class, JDWPGlobalTrip.THREAD).alive(target, true);
            }
            return vmThread;
        }
    }
    ,
    CURRENT_EXIT_CODE("currentExitCode:()I"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return __thread.machine.getExitCode();
        }
    }
    ,
    CURRENT_JAVA_THREAD("currentJavaThread:()Ljava/lang/Thread;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return __thread.thread.threadInstance();
        }
    }
    ,
    CURRENT_VM_THREAD("currentVMThread:()Lcc/squirreljme/jvm/mle/brackets/VMThreadBracket;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return new VMThreadObject(__thread.machine, __thread.thread);
        }
    }
    ,
    EQUALS("equals:(Lcc/squirreljme/jvm/mle/brackets/VMThreadBracket;Lcc/squirreljme/jvm/mle/brackets/VMThreadBracket;)Z"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return MLEObjects.threadVm(__args[0]).getThread() == MLEObjects.threadVm(__args[1]).getThread();
        }
    }
    ,
    JAVA_THREAD_CLEAR_INTERRUPT("javaThreadClearInterrupt:(Ljava/lang/Thread;)Z"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            SpringFieldStorage field = MLEObjects.threadJava(__thread, __args[0]).fieldByNameAndType(false, "_interrupted", "Z");
            Object old = field.get();
            field.set(false);
            return old;
        }
    }
    ,
    JAVA_THREAD_IS_STARTED("javaThreadIsStarted:(Ljava/lang/Thread;)Z"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return MLEObjects.threadJava(__thread, __args[0]).fieldByNameAndType(false, "_started", "Z").get();
        }
    }
    ,
    JAVA_THREAD_RUNNABLE("javaThreadRunnable:(Ljava/lang/Thread;)Ljava/lang/Runnable;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return MLEObjects.threadJava(__thread, __args[0]).fieldByNameAndType(false, "_runnable", "Ljava/lang/Runnable;").get();
        }
    }
    ,
    JAVA_THREAD_SET_DAEMON("javaThreadSetDaemon:(Ljava/lang/Thread;)V"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            SpringThread vmThread;
            SpringThread springThread = vmThread = MLEObjects.threadVm(TO_VM_THREAD.handle(__thread, __args[0])).getThread();
            synchronized (springThread) {
                if (vmThread.isTerminated() || vmThread.numFrames() > 0) {
                    throw new SpringMLECallError("Thread is started.");
                }
                vmThread.setDaemon();
            }
            return null;
        }
    }
    ,
    MODEL("model:()I"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return (byte)2;
        }
    }
    ,
    RUN_PROCESS_MAIN("runProcessMain:()V"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            __thread.runProcessMain();
            return null;
        }
    }
    ,
    SET_CURRENT_EXIT_CODE("setCurrentExitCode:(I)V"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            int exitCode = (Integer)__args[0];
            __thread.machine.setExitCode(exitCode);
            return null;
        }
    }
    ,
    SET_TRACE("setTrace:(Ljava/lang/String;[Lcc/squirreljme/jvm/mle/brackets/TracePointBracket;)V"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            if (!(__args[1] instanceof SpringArrayObjectGeneric)) {
                throw new SpringMLECallError("Wrong trace array type.");
            }
            SpringObject[] gen = ((SpringArrayObjectGeneric)__args[1]).array();
            String message = __thread.asNativeObject(String.class, __args[0]);
            if (message == null) {
                throw new SpringMLECallError("No message set.");
            }
            int n2 = gen.length;
            CallTraceElement[] trace = new CallTraceElement[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                trace[i2] = MLEObjects.debugTrace(gen[i2]).getTrace();
            }
            __thread.machine.storeTrace(message, trace);
            return null;
        }
    }
    ,
    SLEEP("sleep:(II)Z"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            int ms = (Integer)__args[0];
            int ns = (Integer)__args[1];
            if (ms < 0 || ns < 0 || ns > 1000000000) {
                throw new SpringMLECallError("Out of range time.");
            }
            SpringThreadFrame currentFrame = __thread.thread.currentFrame();
            ProfiledFrame profiler = currentFrame == null ? null : currentFrame._profiler;
            boolean interrupted = false;
            try {
                __thread.thread.setStatus(1);
                if (profiler != null) {
                    profiler.sleep(true, System.nanoTime());
                }
                if (ms == 0 && ns == 0) {
                    Thread.yield();
                } else {
                    try {
                        Thread.sleep(ms, ns);
                    }
                    catch (InterruptedException ignored) {
                        interrupted = true;
                    }
                }
            }
            finally {
                __thread.thread.setStatus(0);
                if (profiler != null) {
                    profiler.sleep(false, System.nanoTime());
                }
            }
            return interrupted;
        }
    }
    ,
    TO_JAVA_THREAD("toJavaThread:(Lcc/squirreljme/jvm/mle/brackets/VMThreadBracket;)Ljava/lang/Thread;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            VMThreadObject vmThread = MLEObjects.threadVm(__args[0]);
            return vmThread.getThread().threadInstance();
        }
    }
    ,
    TO_VM_THREAD("toVMThread:(Ljava/lang/Thread;)Lcc/squirreljme/jvm/mle/brackets/VMThreadBracket;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return MLEObjects.threadJava(__thread, __args[0]).fieldByField(__thread.resolveClass("java/lang/Thread").lookupField(false, "_vmThread", "Lcc/squirreljme/jvm/mle/brackets/VMThreadBracket;")).get();
        }
    }
    ,
    VM_THREAD_ID("vmThreadId:(Lcc/squirreljme/jvm/mle/brackets/VMThreadBracket;)I"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return MLEObjects.threadVm((Object)__args[0]).getThread().id;
        }
    }
    ,
    VM_THREAD_INTERRUPT("vmThreadInterrupt:(Lcc/squirreljme/jvm/mle/brackets/VMThreadBracket;)V"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            VMThreadObject vmThread = MLEObjects.threadVm(__args[0]);
            vmThread.getThread().hardInterrupt();
            return null;
        }
    }
    ,
    VM_THREAD_IS_ALIVE("vmThreadIsAlive:(Lcc/squirreljme/jvm/mle/brackets/VMThreadBracket;)Z"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            SpringThread thread = MLEObjects.threadVm(__args[0]).getThread();
            return thread._worker != null && !thread.isTerminated();
        }
    }
    ,
    VM_THREAD_IS_MAIN("vmThreadIsMain:(Lcc/squirreljme/jvm/mle/brackets/VMThreadBracket;)Z"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return MLEObjects.threadVm(__args[0]).getThread().isMain();
        }
    }
    ,
    VM_THREAD_IS_STARTED("vmThreadIsStarted:(Lcc/squirreljme/jvm/mle/brackets/VMThreadBracket;)Z"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            SpringThread thread = MLEObjects.threadVm(__args[0]).getThread();
            return thread._worker != null;
        }
    }
    ,
    VM_THREAD_SET_PRIORITY("vmThreadSetPriority:(Lcc/squirreljme/jvm/mle/brackets/VMThreadBracket;I)V"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            SpringThread thread = MLEObjects.threadVm(__args[0]).getThread();
            int priority = (Integer)__args[1];
            if (priority < 1 || priority > 10) {
                throw new SpringMLECallError("Thread priority out of range.");
            }
            try {
                if (thread._worker == null) {
                    thread._initPriority = priority;
                } else {
                    thread._worker.setPriority(priority);
                }
            }
            catch (IllegalArgumentException | SecurityException e2) {
                throw new SpringMLECallError("Could not set priority.", e2);
            }
            return null;
        }
    }
    ,
    VM_THREAD_START("vmThreadStart:(Lcc/squirreljme/jvm/mle/brackets/VMThreadBracket;)Z"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            SpringThread target = MLEObjects.threadVm(__args[0]).getThread();
            SpringThreadWorker worker = new SpringThreadWorker(__thread.machine, target, false);
            if (target._initVerboseFlags != 0) {
                worker.verbose().add(0, target._initVerboseFlags);
            }
            target.enterFrame(worker.loadClass(_START_CLASS).lookupMethod(true, _BASE_THREAD_METHOD), new Object[0]);
            try {
                worker.start();
                return true;
            }
            catch (IllegalThreadStateException ignored) {
                return false;
            }
        }
    }
    ,
    VM_THREAD_TASK("vmThreadTask:(Lcc/squirreljme/jvm/mle/brackets/VMThreadBracket;)Lcc/squirreljme/jvm/mle/brackets/TaskBracket;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return MLEObjects.threadVm(__args[0]).getThread().machine().taskObject(__thread.machine);
        }
    }
    ,
    WAIT_FOR_UPDATE("waitForUpdate:(I)Z"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            SpringMachine machine;
            int ms = (Integer)__args[0];
            if (ms < 0) {
                throw new SpringMLECallError("Negative milliseconds");
            }
            if (ms == 0) {
                Thread.yield();
                return false;
            }
            SpringMachine springMachine = machine = __thread.machine;
            synchronized (springMachine) {
                try {
                    machine.wait(ms);
                }
                catch (InterruptedException e2) {
                    return true;
                }
            }
            return false;
        }
    };

    static final ClassName _START_CLASS;
    static final MethodNameAndType _BASE_THREAD_METHOD;
    protected final String key;

    private MLEThread(String __key) throws NullPointerException {
        if (__key == null) {
            throw new NullPointerException("NARG");
        }
        this.key = __key;
    }

    @Override
    public String key() {
        return this.key;
    }

    static {
        _START_CLASS = new ClassName("java/lang/__Start__");
        _BASE_THREAD_METHOD = new MethodNameAndType("__base", "()V");
    }
}

