/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.vm.springcoat;

import cc.squirreljme.jvm.mle.brackets.JarPackageBracket;
import cc.squirreljme.vm.springcoat.MLEDispatcher;
import cc.squirreljme.vm.springcoat.MLEFunction;
import cc.squirreljme.vm.springcoat.MLEObjects;
import cc.squirreljme.vm.springcoat.SpringClass;
import cc.squirreljme.vm.springcoat.SpringNullObject;
import cc.squirreljme.vm.springcoat.SpringObject;
import cc.squirreljme.vm.springcoat.SpringThreadWorker;
import cc.squirreljme.vm.springcoat.brackets.JarPackageObject;
import cc.squirreljme.vm.springcoat.exceptions.SpringClassNotFoundException;
import cc.squirreljme.vm.springcoat.exceptions.SpringMLECallError;
import java.util.Objects;
import net.multiphasicapps.classfile.ClassName;
import net.multiphasicapps.classfile.MethodNameAndType;
import net.multiphasicapps.classfile.PrimitiveType;

public enum MLEType implements MLEFunction
{
    BINARY_NAME("binaryName:(Ljava/lang/Class;)Ljava/lang/String;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return __thread.asVMObject(MLEObjects.type(__args[0]).name().binaryName().toString());
        }
    }
    ,
    BINARY_PACKAGE_NAME("binaryPackageName:(Ljava/lang/Class;)Ljava/lang/String;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return __thread.asVMObject(MLEObjects.type(__args[0]).name().binaryName().inPackage().toString());
        }
    }
    ,
    COMPONENT("component:(Ljava/lang/Class;)Ljava/lang/Class;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            SpringClass type = MLEObjects.type(__args[0]);
            if (!type.isArray()) {
                throw new SpringMLECallError("Not an array type.");
            }
            return type.componentType();
        }
    }
    ,
    COMPONENT_ROOT("componentRoot:(Ljava/lang/Class;)Ljava/lang/Class;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            SpringClass type = MLEObjects.type(__args[0]);
            if (!type.isArray()) {
                throw new SpringMLECallError("Not an array type.");
            }
            while (type.isArray()) {
                type = type.componentType();
            }
            return type;
        }
    }
    ,
    ENUM_VALUES("enumValues:(Ljava/lang/Class;)[Ljava/lang/Enum;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            SpringClass type = MLEObjects.type(__args[0]);
            if (!type.isEnum()) {
                throw new SpringMLECallError("Not an enumeration type");
            }
            return __thread.invokeMethod(true, type.name(), new MethodNameAndType("values", "()" + type.name().field().addDimensions(1)), new Object[0]);
        }
    }
    ,
    EQUALS("equals:(Ljava/lang/Class;Ljava/lang/Class;)Z"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return Objects.equals(MLEObjects.type(__args[0]), MLEObjects.type(__args[1]));
        }
    }
    ,
    FIND_TYPE("findType:(Ljava/lang/String;)Ljava/lang/Class;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            SpringObject name = MLEObjects.notNull(__args[0]);
            try {
                return __thread.loadClass(__thread.asNativeObject(String.class, name));
            }
            catch (SpringClassNotFoundException e2) {
                return null;
            }
        }
    }
    ,
    IN_JAR(MLEDispatcher.methodKey("inJar", JarPackageBracket.class, Class.class)){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return new JarPackageObject(__thread.machine, MLEObjects.type(__args[0]).inJar());
        }
    }
    ,
    INTERFACES("interfaces:(Ljava/lang/Class;)[Ljava/lang/Class;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            SpringClass type = MLEObjects.type(__args[0]);
            SpringClass[] interfaces = type.interfaceClasses();
            int n2 = interfaces.length;
            SpringObject[] rv = new SpringObject[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                rv[i2] = interfaces[i2];
            }
            return __thread.asVMObjectArray(__thread.resolveClass("[Ljava/lang/Class;"), rv);
        }
    }
    ,
    IS_ARRAY("isArray:(Ljava/lang/Class;)Z"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return MLEObjects.type(__args[0]).isArray();
        }
    }
    ,
    IS_ASSIGNABLE_FROM("isAssignableFrom:(Ljava/lang/Class;Ljava/lang/Class;)Z"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            if (MLEObjects.type(__args[0]).isAssignableFrom(MLEObjects.type(__args[1]))) {
                return 1;
            }
            return 0;
        }
    }
    ,
    IS_ENUM("isEnum:(Ljava/lang/Class;)Z"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return MLEObjects.type(__args[0]).isEnum();
        }
    }
    ,
    IS_INTERFACE("isInterface:(Ljava/lang/Class;)Z"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return MLEObjects.type(__args[0]).flags().isInterface();
        }
    }
    ,
    IS_PRIMITIVE("isPrimitive:(Ljava/lang/Class;)Z"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return MLEObjects.type(__args[0]).name().isPrimitive();
        }
    }
    ,
    OBJECT_TYPE("objectType:(Ljava/lang/Object;)Ljava/lang/Class;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return __thread.loadClass(MLEObjects.notNull(__args[0]).type().name().toString());
        }
    }
    ,
    RUNTIME_NAME("runtimeName:(Ljava/lang/Class;)Ljava/lang/String;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return MLEObjects.type(__args[0]).name().toRuntimeString();
        }
    }
    ,
    SUPER_CLASS("superClass:(Ljava/lang/Class;)Ljava/lang/Class;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            SpringClass superClass = MLEObjects.type(__args[0]).superClass();
            if (superClass == null) {
                return SpringNullObject.NULL;
            }
            return superClass;
        }
    }
    ,
    TYPE_OF_BOOLEAN("typeOfBoolean:()Ljava/lang/Class;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return __thread.loadClass(ClassName.fromPrimitiveType(PrimitiveType.BOOLEAN));
        }
    }
    ,
    TYPE_OF_BYTE("typeOfByte:()Ljava/lang/Class;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return __thread.loadClass(ClassName.fromPrimitiveType(PrimitiveType.BYTE));
        }
    }
    ,
    TYPE_OF_CHARACTER("typeOfCharacter:()Ljava/lang/Class;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return __thread.loadClass(ClassName.fromPrimitiveType(PrimitiveType.CHARACTER));
        }
    }
    ,
    TYPE_OF_DOUBLE("typeOfDouble:()Ljava/lang/Class;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return __thread.loadClass(ClassName.fromPrimitiveType(PrimitiveType.DOUBLE));
        }
    }
    ,
    TYPE_OF_FLOAT("typeOfFloat:()Ljava/lang/Class;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return __thread.loadClass(ClassName.fromPrimitiveType(PrimitiveType.FLOAT));
        }
    }
    ,
    TYPE_OF_INTEGER("typeOfInteger:()Ljava/lang/Class;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return __thread.loadClass(ClassName.fromPrimitiveType(PrimitiveType.INTEGER));
        }
    }
    ,
    TYPE_OF_LONG("typeOfLong:()Ljava/lang/Class;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return __thread.loadClass(ClassName.fromPrimitiveType(PrimitiveType.LONG));
        }
    }
    ,
    TYPE_OF_SHORT("typeOfShort:()Ljava/lang/Class;"){

        @Override
        public Object handle(SpringThreadWorker __thread, Object ... __args) {
            return __thread.loadClass(ClassName.fromPrimitiveType(PrimitiveType.SHORT));
        }
    };

    protected final String key;

    private MLEType(String __key) throws NullPointerException {
        if (__key == null) {
            throw new NullPointerException("NARG");
        }
        this.key = __key;
    }

    @Override
    public String key() {
        return this.key;
    }
}

