/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.vm.springcoat;

import cc.squirreljme.vm.springcoat.SpringArray;
import cc.squirreljme.vm.springcoat.SpringClass;
import cc.squirreljme.vm.springcoat.SpringMonitor;
import cc.squirreljme.vm.springcoat.SpringObject;
import cc.squirreljme.vm.springcoat.exceptions.SpringArrayIndexOutOfBoundsException;
import cc.squirreljme.vm.springcoat.exceptions.SpringArrayStoreException;
import cc.squirreljme.vm.springcoat.exceptions.SpringNegativeArraySizeException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public abstract class SpringArrayObject
implements SpringArray,
SpringObject {
    protected final SpringMonitor monitor = new SpringMonitor();
    protected final SpringClass selftype;
    protected final SpringClass component;
    protected final int length;
    private Reference<String> _string;

    public SpringArrayObject(SpringClass __self, int __l) throws IllegalArgumentException, NullPointerException, SpringNegativeArraySizeException {
        if (__self == null) {
            throw new NullPointerException("NARG");
        }
        if (!__self.isArray()) {
            throw new IllegalArgumentException("Type not an array: " + __self);
        }
        if (__l < 0) {
            throw new SpringNegativeArraySizeException(String.format("BK01 %d", __l));
        }
        this.selftype = __self;
        this.component = __self.componentType();
        this.length = __l;
    }

    @Override
    public abstract Object array();

    @Override
    public abstract <C> C get(Class<C> var1, int var2) throws NullPointerException, SpringArrayIndexOutOfBoundsException;

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public abstract void set(int var1, Object var2) throws SpringArrayStoreException, SpringArrayIndexOutOfBoundsException;

    @Override
    public final int length() {
        return this.length;
    }

    @Override
    public final SpringMonitor monitor() {
        return this.monitor;
    }

    public final String toString() {
        String rv;
        Reference<String> ref = this._string;
        if (ref == null || null == (rv = ref.get())) {
            rv = String.format("%s@%08x", this.selftype.name(), System.identityHashCode(this));
            this._string = new WeakReference<String>(rv);
        }
        return rv;
    }

    @Override
    public final SpringClass type() {
        return this.selftype;
    }
}

