/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.vm.springcoat;

import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.vm.springcoat.CallbackThread;
import cc.squirreljme.vm.springcoat.MethodInvokeException;
import cc.squirreljme.vm.springcoat.SpringMachine;
import cc.squirreljme.vm.springcoat.SpringObject;
import cc.squirreljme.vm.springcoat.exceptions.SpringMLECallError;
import net.multiphasicapps.classfile.ClassName;
import net.multiphasicapps.classfile.MethodNameAndType;

public abstract class SpringCallbackAdapter {
    private static final MethodNameAndType _PRINT_STACK_TRACE_NAT = new MethodNameAndType("printStackTrace", "()V");
    private static final ClassName _THROWABLE_CLASS = new ClassName("java/lang/Throwable");
    protected final ClassName callbackClass;
    protected final SpringObject target;
    protected final SpringMachine machine;

    protected SpringCallbackAdapter(ClassName __callbackClass, SpringMachine __machine, SpringObject __target) throws NullPointerException {
        if (__callbackClass == null || __machine == null || __target == null) {
            throw new NullPointerException("NARG");
        }
        this.callbackClass = __callbackClass;
        this.machine = __machine;
        this.target = __target;
    }

    protected final Object invokeCallback(MethodNameAndType __nat, Object ... __args) throws NullPointerException {
        if (__nat == null || __args == null) {
            throw new NullPointerException("NARG");
        }
        int argLen = __args.length;
        Object[] callArgs = new Object[argLen + 1];
        System.arraycopy(__args, 0, callArgs, 1, argLen);
        callArgs[0] = this.target;
        try (CallbackThread cb2 = this.machine.obtainCallbackThread(true);){
            Object result = cb2.thread().invokeMethod(false, this.callbackClass, __nat, callArgs);
            if (result instanceof MethodInvokeException) {
                MethodInvokeException mie = (MethodInvokeException)result;
                Debugging.debugNote("--------------------------------");
                Debugging.debugNote("Callback exception: %s", mie.exception);
                mie.printStackTrace(System.err);
                Debugging.debugNote("Within VM:");
                cb2.thread().invokeMethod(false, _THROWABLE_CLASS, _PRINT_STACK_TRACE_NAT, mie.exception);
                Debugging.debugNote("--------------------------------");
                throw new SpringMLECallError("Callback threw exception!");
            }
            Object object = result;
            return object;
        }
    }
}

