/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.vm.springcoat;

import cc.squirreljme.emulator.vm.VMException;
import cc.squirreljme.runtime.cldc.util.StreamUtils;
import cc.squirreljme.vm.VMClassLibrary;
import cc.squirreljme.vm.springcoat.SpringClass;
import cc.squirreljme.vm.springcoat.SpringException;
import cc.squirreljme.vm.springcoat.SpringMachine;
import cc.squirreljme.vm.springcoat.SpringVMClass;
import cc.squirreljme.vm.springcoat.exceptions.SpringClassFormatException;
import cc.squirreljme.vm.springcoat.exceptions.SpringClassNotFoundException;
import cc.squirreljme.vm.springcoat.exceptions.SpringVirtualMachineException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.multiphasicapps.classfile.ClassFile;
import net.multiphasicapps.classfile.ClassName;
import net.multiphasicapps.classfile.InvalidClassFormatException;

public final class SpringClassLoader {
    protected final Object loaderlock = new Object();
    private final VMClassLibrary[] _classpath;
    private final Map<ClassName, SpringClass> _classes = new HashMap<ClassName, SpringClass>();
    private final Reference<SpringClassLoader> _machineRef = new WeakReference<SpringClassLoader>(this);
    private volatile Reference<SpringMachine> _machine;
    private int _nexcsi = 1;

    public SpringClassLoader(VMClassLibrary ... __classpath) throws NullPointerException {
        __classpath = __classpath == null ? new VMClassLibrary[]{} : (VMClassLibrary[])__classpath.clone();
        for (VMClassLibrary b2 : __classpath) {
            if (b2 != null) continue;
            throw new NullPointerException("NARG");
        }
        this._classpath = __classpath;
    }

    public final VMClassLibrary bootLibrary() {
        VMClassLibrary[] classpath = this._classpath;
        if (classpath.length == 0) {
            throw new VMException("There is no classpath.");
        }
        if (classpath.length == 1) {
            return classpath[0];
        }
        return classpath[classpath.length - 1];
    }

    public final Object classLoadingLock() {
        return this.loaderlock;
    }

    public final VMClassLibrary[] classPath() {
        return (VMClassLibrary[])this._classpath.clone();
    }

    public final VMClassLibrary findLibrary(String __n) throws NullPointerException {
        if (__n == null) {
            throw new NullPointerException("NARG");
        }
        for (VMClassLibrary lib : this._classpath) {
            if (!__n.equals(lib.name())) continue;
            return lib;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SpringClass loadClass(ClassName __cn) throws NullPointerException, SpringClassFormatException, SpringClassNotFoundException {
        if (__cn == null) {
            throw new NullPointerException("NARG");
        }
        Map<ClassName, SpringClass> classes = this._classes;
        Object object = this.loaderlock;
        synchronized (object) {
            ClassFile cf2;
            SpringClass rv;
            SpringClassLoader springClassLoader = this;
            synchronized (springClassLoader) {
                rv = classes.get(__cn);
            }
            if (rv != null) {
                return rv;
            }
            VMClassLibrary[] inJar = new VMClassLibrary[1];
            try {
                cf2 = this.loadClassFile(__cn, inJar);
            }
            catch (InvalidClassFormatException e2) {
                throw new InvalidClassFormatException(String.format("BK12 %s", __cn), e2);
            }
            ClassName supername = cf2.superName();
            SpringClass superclass = supername == null ? null : this.loadClass(supername);
            ClassName[] interfacenames = cf2.interfaceNames().toArray();
            int numinterfaces = interfacenames.length;
            SpringClass[] interfaceclasses = new SpringClass[numinterfaces];
            for (int i2 = 0; i2 < numinterfaces; ++i2) {
                interfaceclasses[i2] = this.loadClass(interfacenames[i2]);
            }
            SpringClass component = null;
            if (__cn.isArray()) {
                component = this.loadClass(__cn.componentType());
            }
            rv = new SpringVMClass(superclass, interfaceclasses, cf2, component, inJar[0], this._machineRef);
            SpringClassLoader springClassLoader2 = this;
            synchronized (springClassLoader2) {
                classes.put(__cn, rv);
            }
            return rv;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final ClassFile loadClassFile(ClassName __cn, VMClassLibrary[] __ij) throws NullPointerException, SpringClassFormatException, SpringClassNotFoundException {
        if (__cn == null) {
            throw new NullPointerException("NARG");
        }
        if (__cn.isPrimitive()) return ClassFile.special(__cn.field());
        if (__cn.isArray()) {
            return ClassFile.special(__cn.field());
        }
        String fileform = __cn.toString() + ".class";
        byte[] data = null;
        for (VMClassLibrary b2 : this._classpath) {
            try (InputStream in = b2.resourceAsStream(fileform);){
                if (in == null) continue;
                data = StreamUtils.readAll(in);
                if (__ij == null || __ij.length <= 0) break;
                __ij[0] = b2;
                break;
            }
            catch (IOException e2) {
                throw new SpringException("BK13", e2);
            }
        }
        if (data == null) {
            throw new SpringClassNotFoundException(__cn, String.format("BK14 %s %s", __cn, fileform));
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(data);){
            ClassFile classFile = ClassFile.decode(bais);
            return classFile;
        }
        catch (IOException e3) {
            throw new SpringVirtualMachineException(String.format("BK15 %s", __cn), e3);
        }
        catch (InvalidClassFormatException e4) {
            throw new SpringClassFormatException(__cn, String.format("BK16 %s", __cn), e4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SpringClass[] loadedClasses() {
        SpringClassLoader springClassLoader = this;
        synchronized (springClassLoader) {
            Collection<SpringClass> classes = this._classes.values();
            return classes.toArray(new SpringClass[classes.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SpringMachine machine() throws IllegalStateException {
        SpringClassLoader springClassLoader = this;
        synchronized (springClassLoader) {
            if (this._machine == null) {
                throw new IllegalStateException("No machine set.");
            }
            SpringMachine rv = this._machine.get();
            if (rv == null) {
                throw new IllegalStateException("Owner GCed.");
            }
            return rv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerClass(ClassName __name, SpringClass __class) throws NullPointerException {
        if (__name == null || __class == null) {
            throw new NullPointerException("NARG");
        }
        SpringClassLoader springClassLoader = this;
        synchronized (springClassLoader) {
            this._classes.put(__name, __class);
        }
    }

    public final VMClassLibrary rootLibrary() {
        return this._classpath[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void __bind(SpringMachine __machine) throws IllegalStateException, NullPointerException {
        if (__machine == null) {
            throw new NullPointerException("NARG");
        }
        SpringClassLoader springClassLoader = this;
        synchronized (springClassLoader) {
            if (null != this._machine) {
                throw new IllegalStateException("Classloader already bound.");
            }
            this._machine = new WeakReference<SpringMachine>(__machine);
        }
    }
}

