/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.vm.springcoat;

import cc.squirreljme.emulator.profiler.ProfilerSnapshot;
import cc.squirreljme.emulator.terminal.TerminalPipeManager;
import cc.squirreljme.emulator.vm.VMResourceAccess;
import cc.squirreljme.emulator.vm.VMSuiteManager;
import cc.squirreljme.emulator.vm.VirtualMachine;
import cc.squirreljme.jvm.mle.BucketShelf;
import cc.squirreljme.jvm.mle.exceptions.MLECallError;
import cc.squirreljme.runtime.cldc.debug.CallTraceElement;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.vm.springcoat.CallTraceStorage;
import cc.squirreljme.vm.springcoat.CallbackThread;
import cc.squirreljme.vm.springcoat.CallbackThreader;
import cc.squirreljme.vm.springcoat.GlobalState;
import cc.squirreljme.vm.springcoat.SpringClassLoader;
import cc.squirreljme.vm.springcoat.SpringObject;
import cc.squirreljme.vm.springcoat.SpringStringObject;
import cc.squirreljme.vm.springcoat.SpringTaskManager;
import cc.squirreljme.vm.springcoat.SpringThread;
import cc.squirreljme.vm.springcoat.SpringThreadWorker;
import cc.squirreljme.vm.springcoat.SpringVisClass;
import cc.squirreljme.vm.springcoat.SpringVisObject;
import cc.squirreljme.vm.springcoat.brackets.BucketObject;
import cc.squirreljme.vm.springcoat.brackets.TaskObject;
import cc.squirreljme.vm.springcoat.exceptions.SpringMLECallError;
import cc.squirreljme.vm.springcoat.exceptions.SpringMachineExitException;
import cc.squirreljme.vm.springcoat.exceptions.SpringVirtualMachineException;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import net.multiphasicapps.classfile.ClassName;
import net.multiphasicapps.classfile.MethodDescriptor;
import net.multiphasicapps.classfile.MethodNameAndType;

public final class SpringMachine
implements Runnable,
VirtualMachine {
    public static final int EXIT_CODE_FATAL_EXCEPTION = 123;
    private static final ClassName _START_CLASS = new ClassName("java/lang/__Start__");
    private static final MethodNameAndType _MAIN_THREAD_METHOD = new MethodNameAndType("__main", "()V");
    private static final ClassName _THREAD_CLASS = new ClassName("java/lang/Thread");
    private static final MethodDescriptor _THREAD_NEW = new MethodDescriptor("(Ljava/lang/String;)V");
    private static volatile int _nextVmNumber = 1;
    protected final SpringClassLoader classloader;
    protected final VMResourceAccess resourceaccessor;
    protected final String bootClass;
    protected final VMSuiteManager suites;
    protected final SpringTaskManager tasks;
    protected final GlobalState globalState;
    protected final ProfilerSnapshot profiler;
    protected final TerminalPipeManager terminalPipes;
    protected final String vmId;
    protected final boolean rootVm;
    private final CallbackThreader _cbThreader = new CallbackThreader();
    private final List<SpringThread> _threads = new ArrayList<SpringThread>();
    private final Map<String, SpringStringObject> _strings = new HashMap<String, SpringStringObject>();
    private final Map<ClassName, SpringObject> _classobjects = new HashMap<ClassName, SpringObject>();
    private final Map<SpringObject, ClassName> _namesbyclass = new HashMap<SpringObject, ClassName>();
    private final Map<SpringMachine, Reference<TaskObject>> _taskObject = new WeakHashMap<SpringMachine, Reference<TaskObject>>();
    private final String[] _args;
    final Map<String, String> _sysproperties;
    private final Map<Class<?>, Reference<SpringVisClass>> _visClasses = new LinkedHashMap();
    private final Map<Object, SpringVisObject> _visObjects = new WeakHashMap<Object, SpringVisObject>();
    private final Collection<CallbackThread> _cbThreads = new LinkedList<CallbackThread>();
    private final BucketObject[] _buckets = new BucketObject[2];
    volatile int _verboseInternal;
    private volatile int _nextthreadid;
    private volatile boolean _exiting;
    private int _exitcode;
    private CallTraceStorage _storedTrace;
    volatile int _globalTrace;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpringMachine(VMSuiteManager __sm, SpringClassLoader __cl, SpringTaskManager __tm, String __bootcl, ProfilerSnapshot __profiler, Map<String, String> __sprops, GlobalState __gs, TerminalPipeManager __pipes, boolean __rootVm, String ... __args) throws NullPointerException {
        if (__cl == null || __sm == null || __pipes == null) {
            throw new NullPointerException("NARG");
        }
        __cl.__bind(this);
        this.rootVm = __rootVm;
        this.suites = __sm;
        this.classloader = __cl;
        this.tasks = __tm;
        this.bootClass = __bootcl;
        this.globalState = __gs;
        this.terminalPipes = __pipes;
        this._args = __args == null ? new String[]{} : (String[])__args.clone();
        this.profiler = __profiler != null ? __profiler : new ProfilerSnapshot();
        this._sysproperties = __sprops == null ? new HashMap<String, String>() : new HashMap<String, String>(__sprops);
        this.resourceaccessor = new VMResourceAccess(__sm);
        Class<SpringMachine> clazz = SpringMachine.class;
        synchronized (SpringMachine.class) {
            this.vmId = String.format("%s#%d@%08x", __cl.bootLibrary().name(), _nextVmNumber++, System.identityHashCode(this));
            // ** MonitorExit[var11_11] (shouldn't be in output)
            return;
        }
    }

    public BucketObject bucket(int __id) {
        BucketObject[] buckets = this._buckets;
        if (__id < 0 || __id >= buckets.length) {
            throw new SpringMLECallError("IOOB");
        }
        BucketObject result = buckets[__id];
        if (result != null) {
            return result;
        }
        try {
            buckets[__id] = result = new BucketObject(this, BucketShelf.bucket(__id));
            return result;
        }
        catch (MLECallError __e) {
            throw new SpringMLECallError(__e.getMessage(), __e);
        }
    }

    public final SpringClassLoader classLoader() {
        return this.classloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SpringThread createThread(String __n, boolean __main, boolean __noDebugSuspend) {
        List<SpringThread> threads = this._threads;
        SpringMachine springMachine = this;
        synchronized (springMachine) {
            String usedName = __n != null ? __n : "hwThread-" + this.numThreads();
            int v2 = ++this._nextthreadid;
            SpringThread rv = new SpringThread(new WeakReference<SpringMachine>(this), this._nextthreadid, this.tasks.nextThreadId(), __main, usedName, this.profiler.measureThread(String.format("VM_%s-%d-%s", this.vmId, v2, usedName)), __noDebugSuspend);
            this.notifyAll();
            threads.add(rv);
            return rv;
        }
    }

    public final void exit(int __code) throws SpringMachineExitException {
        this.exitNoException(__code);
        throw new SpringMachineExitException(__code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void exitCheck() throws SpringMachineExitException {
        SpringMachine springMachine = this;
        synchronized (springMachine) {
            if (this._exiting) {
                throw new SpringMachineExitException(this._exitcode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void exitNoException(int __code) throws SpringMachineExitException {
        SpringMachine springMachine = this;
        synchronized (springMachine) {
            this._exitcode = __code;
            this._exiting = true;
            try {
                this.terminalPipes.closeAll();
            }
            catch (IOException e2) {
                throw new SpringVirtualMachineException("Could not close pipes.", e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getExitCode() {
        SpringMachine springMachine = this;
        synchronized (springMachine) {
            return this._exitcode;
        }
    }

    public final String[] getMainArguments() {
        return (String[])this._args.clone();
    }

    public final SpringThread getCurrentThread() throws NullPointerException {
        return this.getThread(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SpringThread getThread(Thread __realThread) throws NullPointerException {
        if (__realThread == null) {
            throw new NullPointerException("NARG");
        }
        SpringMachine springMachine = this;
        synchronized (springMachine) {
            for (SpringThread t2 : this.getThreads()) {
                SpringThreadWorker worker = t2._worker;
                if (worker == null || worker != __realThread) continue;
                return t2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SpringThread getThread(int __id) throws NoSuchElementException {
        SpringMachine springMachine = this;
        synchronized (springMachine) {
            for (SpringThread t2 : this.getThreads()) {
                if (t2.id != __id) continue;
                return t2;
            }
        }
        throw new NoSuchElementException("No such thread ID: " + __id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SpringThread[] getThreads() {
        ArrayList<SpringThread> rv = new ArrayList<SpringThread>();
        List<SpringThread> threads = this._threads;
        SpringMachine springMachine = this;
        synchronized (springMachine) {
            Iterator<SpringThread> it = threads.iterator();
            while (it.hasNext()) {
                SpringThread thread = it.next();
                if (thread.isTerminated()) {
                    it.remove();
                    this.notifyAll();
                    continue;
                }
                rv.add(thread);
            }
            if (!this.isExiting() && threads.isEmpty()) {
                this.exitNoException(this.getExitCode());
            }
        }
        return rv.toArray(new SpringThread[rv.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CallTraceStorage getTrace() {
        SpringMachine springMachine = this;
        synchronized (springMachine) {
            return this._storedTrace;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isExiting() {
        SpringMachine springMachine = this;
        synchronized (springMachine) {
            return this._exiting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int numThreads() {
        List<SpringThread> threads = this._threads;
        SpringMachine springMachine = this;
        synchronized (springMachine) {
            return threads.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CallbackThread obtainCallbackThread(boolean __noDebugSuspend) throws NullPointerException {
        CallbackThread rv = null;
        Collection<CallbackThread> cbThreads = this._cbThreads;
        SpringMachine springMachine = this;
        synchronized (springMachine) {
            for (CallbackThread thread : cbThreads) {
                if (!thread.canOpen() || thread.noDebugSuspend() != __noDebugSuspend) continue;
                rv = thread;
                break;
            }
            if (rv != null) {
                rv.open();
                return rv;
            }
        }
        String name = "callback#" + cbThreads.size();
        SpringThread thread = this.createThread(name, false, __noDebugSuspend);
        SpringThreadWorker worker = new SpringThreadWorker(this, thread, false);
        if (this._verboseInternal != 0) {
            worker.verbose().add(0, this._verboseInternal);
        }
        thread.setDaemon();
        thread.enterBlankFrame();
        SpringObject jvmThread = worker.newInstance(_THREAD_CLASS, _THREAD_NEW, worker.asVMObject(name));
        thread.setThreadInstance(jvmThread);
        SpringMachine springMachine2 = this;
        synchronized (springMachine2) {
            rv = new CallbackThread(thread);
            cbThreads.add(rv);
            rv.open();
            return rv;
        }
    }

    public final VMResourceAccess resourceAccess() {
        return this.resourceaccessor;
    }

    @Override
    public final void run() {
        SpringThreadWorker worker;
        SpringThread mainThread = this.createThread("main", true, false);
        mainThread._worker = worker = new SpringThreadWorker(this, mainThread, true);
        mainThread.enterFrame(worker.loadClass(_START_CLASS).lookupMethod(true, _MAIN_THREAD_METHOD), new Object[0]);
        worker.newInstance(new ClassName("java/lang/Thread"), new MethodDescriptor("(Ljava/lang/String;)V"), worker.asVMObject("main"));
        worker.run();
    }

    @Override
    public final int runVm() {
        try {
            this.run();
            Debugging.debugNote("VM exited normally: %d", this.getExitCode());
            return this.getExitCode();
        }
        catch (SpringMachineExitException e2) {
            Debugging.debugNote("VM Exited via exception: %d", e2.code());
            return e2.code();
        }
        catch (Error | RuntimeException e3) {
            PrintStream err = System.err;
            err.println("****************************");
            err.println("*** EXTERNAL STACK TRACE ***");
            e3.printStackTrace(err);
            err.println();
            err.println("****************************");
            if (e3 instanceof Error) {
                throw (Error)e3;
            }
            return 123;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setExitCode(int __exitCode) {
        SpringMachine springMachine = this;
        synchronized (springMachine) {
            this._exitcode = __exitCode;
        }
    }

    @Override
    public void setTraceBits(boolean __or, int __bits) {
        this._globalTrace = __or ? (this._globalTrace |= __bits) : __bits;
    }

    public void signalThreadTerminate(SpringThread __thread) {
        this.getThreads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeTrace(String __message, CallTraceElement ... __trace) throws NullPointerException {
        if (__message == null || __trace == null) {
            throw new NullPointerException("NARG");
        }
        SpringMachine springMachine = this;
        synchronized (springMachine) {
            this._storedTrace = new CallTraceStorage(__message, __trace);
        }
    }

    public final VMSuiteManager suiteManager() {
        return this.suites;
    }

    public final TaskObject taskObject(SpringMachine __for) throws NullPointerException {
        TaskObject rv;
        Map<SpringMachine, Reference<TaskObject>> taskObjects = this._taskObject;
        Reference<TaskObject> ref = taskObjects.get(__for);
        TaskObject taskObject = rv = ref != null ? ref.get() : null;
        if (rv == null) {
            rv = new TaskObject(this);
            taskObjects.put(__for, new WeakReference<TaskObject>(rv));
        }
        return rv;
    }

    public final SpringTaskManager taskManager() {
        return this.tasks;
    }

    public final String toString() {
        return this.vmId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpringVisClass virtualizeClass(Class<?> __class) throws NullPointerException {
        if (__class == null) {
            throw new NullPointerException("NARG");
        }
        Map<Class<?>, Reference<SpringVisClass>> visClasses = this._visClasses;
        SpringMachine springMachine = this;
        synchronized (springMachine) {
            Reference<SpringVisClass> ref = visClasses.get(__class);
            SpringVisClass result = null;
            if (ref == null || (result = ref.get()) == null) {
                result = new SpringVisClass(this, __class);
                visClasses.put(__class, new WeakReference<SpringVisClass>(result));
                this.classloader.registerClass(result.visName, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpringVisObject virtualizeObject(Object __in) throws NullPointerException {
        if (__in == null) {
            throw new NullPointerException("NARG");
        }
        Map<Object, SpringVisObject> visObjects = this._visObjects;
        SpringMachine springMachine = this;
        synchronized (springMachine) {
            SpringVisObject result = visObjects.get(__in);
            if (result != null) {
                return result;
            }
            result = new SpringVisObject(this, __in);
            visObjects.put(__in, result);
            return result;
        }
    }

    public static final void longToInt(int __dx, int[] __v, long __l) {
        __v[__dx] = (int)(__l >>> 32);
        __v[__dx + 1] = (int)__l;
    }

    final Map<ClassName, SpringObject> __classObjectMap() {
        return this._classobjects;
    }

    final Map<SpringObject, ClassName> __classObjectToNameMap() {
        return this._namesbyclass;
    }

    final Map<String, SpringStringObject> __stringMap() {
        return this._strings;
    }
}

