/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.vm.springcoat;

import cc.squirreljme.emulator.profiler.ProfiledFrame;
import cc.squirreljme.vm.springcoat.SpringThread;
import cc.squirreljme.vm.springcoat.SpringThreadFrame;
import cc.squirreljme.vm.springcoat.exceptions.SpringIllegalMonitorStateException;

public final class SpringMonitor {
    volatile SpringThread _owner;
    volatile int _waitcount;
    volatile int _notifycount;
    private int _count;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enter(SpringThread __t) throws NullPointerException {
        if (__t == null) {
            throw new NullPointerException("NARG");
        }
        while (true) {
            SpringMonitor springMonitor = this;
            synchronized (springMonitor) {
                SpringThread owner = this._owner;
                if (owner == null) {
                    this._owner = __t;
                    this._count = 1;
                    return;
                }
                if (owner == __t) {
                    ++this._count;
                    return;
                }
                try {
                    SpringMonitor.__changeState(__t, true);
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    SpringMonitor.__changeState(__t, false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void exit(SpringThread __t, boolean __notify) throws NullPointerException, SpringIllegalMonitorStateException {
        if (__t == null) {
            throw new NullPointerException("NARG");
        }
        SpringMonitor springMonitor = this;
        synchronized (springMonitor) {
            if (this._owner != __t) {
                throw new SpringIllegalMonitorStateException("BK1c");
            }
            int count = this._count;
            if (count <= 0) {
                throw new SpringIllegalMonitorStateException(String.format("BK1d %d", count));
            }
            this._count = --count;
            if (count <= 0) {
                this._owner = null;
                if (__notify) {
                    this.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHeldBy(SpringThread __vmThread) throws NullPointerException {
        if (__vmThread == null) {
            throw new NullPointerException("NARG");
        }
        SpringMonitor springMonitor = this;
        synchronized (springMonitor) {
            return this._owner == __vmThread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int monitorNotify(SpringThread __by, boolean __all) throws NullPointerException {
        if (__by == null) {
            throw new NullPointerException("NARG");
        }
        SpringMonitor springMonitor = this;
        synchronized (springMonitor) {
            if (this._owner != __by) {
                return -1;
            }
            int waitcount = this._waitcount;
            if (waitcount == 0) {
                return 0;
            }
            int notifycount = this._notifycount;
            this._notifycount = Math.min(waitcount, __all ? waitcount : notifycount + 1);
            this.notifyAll();
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int monitorWait(SpringThread __by, long __ms, int __ns) throws NullPointerException {
        if (__by == null) {
            throw new NullPointerException("NARG");
        }
        SpringMonitor springMonitor = this;
        synchronized (springMonitor) {
            if (this._owner != __by) {
                return -1;
            }
            ++this._waitcount;
            this.exit(__by, true);
            boolean waitforever = __ms == 0L && __ns == 0;
            boolean interrupted = false;
            boolean expired = false;
            long end = waitforever ? Long.MAX_VALUE : System.nanoTime() + __ms * 1000000L + (long)__ns;
            while (true) {
                int nownotifycount = this._notifycount;
                int nowwaitcount = this._waitcount;
                if (interrupted || expired || nownotifycount > 0) {
                    if (!interrupted && !expired) {
                        --this._notifycount;
                    }
                    int waitcount = this._waitcount;
                    this._waitcount = --waitcount;
                    if (this._notifycount > waitcount) {
                        this._notifycount = waitcount;
                    }
                    this.enter(__by);
                    if (interrupted) {
                        return 0;
                    }
                    return 1;
                }
                try {
                    SpringMonitor.__changeState(__by, true);
                    if (!waitforever) {
                        long rem = end - System.nanoTime();
                        if (rem <= 0L) {
                            expired = true;
                            continue;
                        }
                        this.wait(rem / 1000000L, (int)(rem % 1000000L));
                        continue;
                    }
                    this.wait();
                    continue;
                }
                catch (InterruptedException e2) {
                    interrupted = true;
                    continue;
                }
                finally {
                    SpringMonitor.__changeState(__by, false);
                    continue;
                }
                break;
            }
        }
    }

    private static void __changeState(SpringThread __thread, boolean __wait) {
        ProfiledFrame profiler;
        SpringThreadFrame currentFrame = __thread.currentFrame();
        ProfiledFrame profiledFrame = profiler = currentFrame == null ? null : currentFrame._profiler;
        if (__wait) {
            __thread.setStatus(2);
            if (profiler != null) {
                profiler.sleep(true, System.nanoTime());
            }
        } else {
            __thread.setStatus(0);
            if (profiler != null) {
                profiler.sleep(false, System.nanoTime());
            }
        }
    }
}

