/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.vm.springcoat;

import cc.squirreljme.emulator.profiler.ProfilerSnapshot;
import cc.squirreljme.emulator.terminal.TerminalPipeManager;
import cc.squirreljme.emulator.vm.VMSuiteManager;
import cc.squirreljme.jdwp.host.JDWPHostBinding;
import cc.squirreljme.jdwp.host.JDWPHostController;
import cc.squirreljme.jdwp.host.JDWPHostState;
import cc.squirreljme.jdwp.host.views.JDWPView;
import cc.squirreljme.jdwp.host.views.JDWPViewKind;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.vm.VMClassLibrary;
import cc.squirreljme.vm.springcoat.DebugViewFrame;
import cc.squirreljme.vm.springcoat.DebugViewObject;
import cc.squirreljme.vm.springcoat.DebugViewThread;
import cc.squirreljme.vm.springcoat.DebugViewThreadGroup;
import cc.squirreljme.vm.springcoat.DebugViewType;
import cc.squirreljme.vm.springcoat.GlobalState;
import cc.squirreljme.vm.springcoat.SpringClassLoader;
import cc.squirreljme.vm.springcoat.SpringMachine;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public final class SpringTaskManager
implements JDWPHostBinding {
    protected final VMSuiteManager suites;
    protected final ProfilerSnapshot profiler;
    protected final GlobalState globalState;
    private final ReferenceQueue<SpringMachine> _machineGc = new ReferenceQueue();
    private final Collection<Reference<SpringMachine>> _machines = new LinkedList<Reference<SpringMachine>>();
    protected JDWPHostController jdwpController;
    private volatile int _nextThreadId;

    public SpringTaskManager(VMSuiteManager __sm, ProfilerSnapshot __ps) throws NullPointerException {
        if (__sm == null) {
            throw new NullPointerException("NARG");
        }
        this.suites = __sm;
        this.profiler = __ps == null ? new ProfilerSnapshot() : __ps;
        this.globalState = new GlobalState();
    }

    @Override
    public String[] debuggerLibraries() {
        return this.suites.listLibraryNames();
    }

    @Override
    public Object[] debuggerThreadGroups() {
        return this.tasks();
    }

    @Override
    public <V extends JDWPView> V debuggerView(Class<V> __type, JDWPViewKind __kind, Reference<JDWPHostState> __state) throws NullPointerException {
        switch (__kind) {
            case FRAME: {
                return (V)((JDWPView)__type.cast(new DebugViewFrame(__state)));
            }
            case OBJECT: {
                return (V)((JDWPView)__type.cast(new DebugViewObject(__state)));
            }
            case THREAD: {
                return (V)((JDWPView)__type.cast(new DebugViewThread(__state)));
            }
            case THREAD_GROUP: {
                return (V)((JDWPView)__type.cast(new DebugViewThreadGroup()));
            }
            case TYPE: {
                return (V)((JDWPView)__type.cast(new DebugViewType(__state)));
            }
        }
        throw Debugging.oops(new Object[]{__kind});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int nextThreadId() {
        SpringTaskManager springTaskManager = this;
        synchronized (springTaskManager) {
            return ++this._nextThreadId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpringMachine startTask(VMClassLibrary[] __classpath, String __mainClass, String[] __mainArgs, Map<String, String> __sysProps, int __stdOutMode, int __stdErrMode, boolean __forkThread, boolean __rootVm) throws NullPointerException {
        if (__classpath == null || __mainClass == null || __mainArgs == null || __sysProps == null) {
            throw new NullPointerException("NARG");
        }
        TerminalPipeManager pipes = new TerminalPipeManager();
        pipes.registerByType(1, __stdOutMode);
        pipes.registerByType(2, __stdErrMode);
        SpringClassLoader classloader = new SpringClassLoader(__classpath);
        SpringMachine machine = new SpringMachine(this.suites, classloader, this, __mainClass, this.profiler, new LinkedHashMap<String, String>(__sysProps), this.globalState, pipes, __rootVm, __mainArgs);
        SpringTaskManager springTaskManager = this;
        synchronized (springTaskManager) {
            this._machines.add(new WeakReference<SpringMachine>(machine, this._machineGc));
        }
        if (__forkThread) {
            Thread fork = new Thread(machine, String.format("%s-%s-main", classloader.bootLibrary().name(), __mainClass));
            fork.start();
        }
        return machine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SpringMachine[] tasks() {
        ArrayList<SpringMachine> result = new ArrayList<SpringMachine>();
        Collection<Reference<SpringMachine>> machines = this._machines;
        SpringTaskManager springTaskManager = this;
        synchronized (springTaskManager) {
            ReferenceQueue<SpringMachine> gc = this._machineGc;
            Reference<SpringMachine> ref = gc.poll();
            while (ref != null) {
                machines.remove(ref);
                ref = gc.poll();
            }
            Iterator<Reference<SpringMachine>> it = machines.iterator();
            while (it.hasNext()) {
                Reference<SpringMachine> ref2 = it.next();
                SpringMachine machine = ref2.get();
                if (machine == null) {
                    it.remove();
                    continue;
                }
                result.add(machine);
            }
        }
        return result.toArray(new SpringMachine[result.size()]);
    }

    @Override
    public String vmDescription() {
        return "SquirrelJME SpringCoat " + this.vmVersion();
    }

    @Override
    public String vmName() {
        return "SquirrelJME SpringCoat VM";
    }

    @Override
    public String vmVersion() {
        return "0.3.0";
    }
}

