/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.vm.springcoat;

import cc.squirreljme.emulator.profiler.ProfiledThread;
import cc.squirreljme.jdwp.host.JDWPHostController;
import cc.squirreljme.jdwp.host.JDWPHostStepTracker;
import cc.squirreljme.jdwp.host.JDWPHostThreadSuspension;
import cc.squirreljme.jdwp.host.trips.JDWPGlobalTrip;
import cc.squirreljme.jdwp.host.trips.JDWPTripThread;
import cc.squirreljme.runtime.cldc.debug.CallTraceElement;
import cc.squirreljme.runtime.cldc.debug.CallTraceUtils;
import cc.squirreljme.vm.springcoat.SpringMachine;
import cc.squirreljme.vm.springcoat.SpringMethod;
import cc.squirreljme.vm.springcoat.SpringObject;
import cc.squirreljme.vm.springcoat.SpringThreadFrame;
import cc.squirreljme.vm.springcoat.SpringThreadFrames;
import cc.squirreljme.vm.springcoat.SpringThreadWorker;
import cc.squirreljme.vm.springcoat.brackets.VMThreadObject;
import cc.squirreljme.vm.springcoat.exceptions.SpringVirtualMachineException;
import java.io.PrintStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import net.multiphasicapps.classfile.ClassName;
import net.multiphasicapps.classfile.MethodNameAndType;

public final class SpringThread {
    public static final int MAX_STACK_DEPTH = 64;
    protected final int id;
    protected final boolean main;
    protected final String name;
    protected final ProfiledThread profiler;
    protected final JDWPHostThreadSuspension debuggerSuspension = new JDWPHostThreadSuspension();
    protected final Reference<SpringMachine> machineRef;
    protected final int uniqueId;
    private final SpringThreadFrames _frames = new SpringThreadFrames();
    public final boolean noDebugSuspend;
    int _initVerboseFlags;
    int _initPriority = -1;
    int _status;
    private SpringObject _threadInstance;
    private VMThreadObject _vmThread;
    private Reference<String> _string;
    private volatile boolean _hadoneframe;
    volatile boolean _daemon;
    volatile boolean _signaledexit;
    volatile SpringThreadWorker _worker;
    private volatile boolean _terminate;
    volatile JDWPHostStepTracker _stepTracker;

    SpringThread(Reference<SpringMachine> __machRef, int __id, int __uniqueId, boolean __main, String __n, ProfiledThread __profiler, boolean __noDebugSuspend) throws NullPointerException {
        if (__n == null) {
            throw new NullPointerException("NARG");
        }
        this.machineRef = __machRef;
        this.id = __id;
        this.uniqueId = __uniqueId;
        this.main = __main;
        this.name = __n;
        this.profiler = __profiler;
        this.noDebugSuspend = __noDebugSuspend;
    }

    public final SpringThreadFrame currentFrame() {
        return this._frames.current();
    }

    public final SpringThreadFrame enterBlankFrame() {
        if (this.isTerminated()) {
            throw new SpringVirtualMachineException("Cannot enter frame on terminated thread.");
        }
        SpringThreadFrame frame = this._frames.enterBlank();
        this._hadoneframe = true;
        return frame;
    }

    public final SpringThreadFrame enterFrame(SpringMethod __m, Object ... __args) throws NullPointerException, SpringVirtualMachineException {
        if (__m == null) {
            throw new NullPointerException("NARG");
        }
        if (this.isTerminated()) {
            throw new SpringVirtualMachineException("Cannot enter frame on terminated thread.");
        }
        if (__args == null) {
            __args = new Object[]{};
        }
        if (__m.isAbstract()) {
            throw new SpringVirtualMachineException(String.format("BK1k %s %s", __m.inClass(), __m.nameAndType()));
        }
        SpringThreadWorker worker = this._worker;
        Object[] vmArgs = Arrays.copyOf(__args, __args.length);
        if (worker != null) {
            int n2 = __args.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                vmArgs[i2] = worker.asVMObject(vmArgs[i2], true);
            }
        }
        SpringThreadFrame rv = this._frames.enter(this._worker.loadClass(__m.inClass()), __m, vmArgs);
        rv._profiler = this.profiler.enterFrame(__m.inClass().toString(), __m.nameAndType().name().toString(), __m.nameAndType().type().toString(), System.nanoTime());
        this._hadoneframe = true;
        if (__m.flags().isSynchronized()) {
            SpringObject monitor;
            if (__m.flags().isStatic()) {
                if (worker == null) {
                    throw new SpringVirtualMachineException("BK1l");
                }
                monitor = (SpringObject)worker.asVMObject(__m.inClass(), true);
            } else {
                if (__args.length <= 0) {
                    throw new SpringVirtualMachineException("BK1m");
                }
                Object argzero = __args[0];
                if (!(argzero instanceof SpringObject)) {
                    throw new SpringVirtualMachineException("BK1n");
                }
                monitor = (SpringObject)argzero;
            }
            rv._monitor = monitor;
            monitor.monitor().enter(this);
        }
        return rv;
    }

    public final void exitAllFrames() {
        this._frames.exitAll();
    }

    public final SpringThreadFrame[] frames() {
        return this._frames.all();
    }

    public final CallTraceElement[] getStackTrace() {
        SpringThreadFrame[] frames = this._frames.all();
        int n2 = frames.length;
        CallTraceElement[] rv = new CallTraceElement[n2];
        int i2 = n2 - 1;
        int write = 0;
        while (i2 >= 0) {
            CallTraceElement trace;
            SpringThreadFrame frame = frames[i2];
            if (frame.isBlank()) {
                trace = new CallTraceElement("<guard>", "<guard>", null, 0L, null, -1);
            } else {
                SpringMethod inMethod = frame.method();
                int pc = frame.lastExecutedPc();
                trace = new CallTraceElement(inMethod.inClass().toString(), inMethod.name().toString(), inMethod.nameAndType().type().toString(), 0L, inMethod.infile, inMethod.byteCode().lineOfAddress(pc), inMethod.byteCode().getByAddress(pc).operation(), pc);
            }
            rv[write] = trace;
            --i2;
            ++write;
        }
        return rv;
    }

    public final void hardInterrupt() {
        SpringThreadWorker worker = this._worker;
        if (worker == null) {
            throw new IllegalStateException("Cannot interrupt thread with no worker.");
        }
        Thread signal = this._worker.signalinstead;
        if (signal != null) {
            signal.interrupt();
        } else {
            worker.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasThreadInstance() {
        SpringThread springThread = this;
        synchronized (springThread) {
            return this._threadInstance != null;
        }
    }

    public final Object invokeMethod(boolean __static, ClassName __cl, MethodNameAndType __nat, Object ... __args) throws NullPointerException {
        if (__cl == null || __nat == null || __args == null) {
            throw new NullPointerException("NARG");
        }
        return this._worker.invokeMethod(__static, __cl, __nat, __args);
    }

    public SpringMachine machine() {
        SpringThreadWorker worker = this._worker;
        return worker == null ? this.machineRef.get() : worker.machine;
    }

    public final boolean isDaemon() {
        return this._daemon;
    }

    public final boolean isExitOkay() {
        return this._daemon || this._terminate;
    }

    public final boolean isMain() {
        return this.main;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isTerminated() {
        SpringThread springThread = this;
        synchronized (springThread) {
            return this._terminate;
        }
    }

    public final String name() {
        return this.name;
    }

    public final int numFrames() {
        return this._frames.count();
    }

    public final SpringThreadFrame popFrame() throws SpringVirtualMachineException {
        SpringObject monitor;
        SpringThreadFrame rv = this._frames.pop();
        if (!rv.isblank) {
            this.profiler.exitFrame(System.nanoTime());
        }
        if ((monitor = rv._monitor) != null) {
            monitor.monitor().exit(this, true);
        }
        return rv;
    }

    public final void printStackTrace(PrintStream __ps) throws NullPointerException {
        if (__ps == null) {
            throw new NullPointerException("NARG");
        }
        CallTraceUtils.printStackTrace((Appendable)__ps, String.format("SpringThread #%d: %s", this.id, this.name), this.getStackTrace(), null, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDaemon() {
        SpringThread springThread = this;
        synchronized (springThread) {
            this._daemon = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(int __status) {
        SpringThread springThread = this;
        synchronized (springThread) {
            this._status = __status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setThreadInstance(SpringObject __object) throws IllegalStateException, NullPointerException {
        if (__object == null) {
            throw new NullPointerException("NARG");
        }
        SpringThread springThread = this;
        synchronized (springThread) {
            if (this._threadInstance != null) {
                throw new IllegalStateException("Thread has an instance.");
            }
            this._threadInstance = __object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setVMThread(VMThreadObject __vmThread) throws IllegalStateException, NullPointerException {
        if (__vmThread == null) {
            throw new NullPointerException("NARG");
        }
        SpringThread springThread = this;
        synchronized (springThread) {
            if (this._vmThread != null) {
                throw new IllegalStateException("Thread has VM Thread.");
            }
            this._vmThread = __vmThread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void terminate() {
        JDWPHostController jdwp;
        SpringThread springThread = this;
        synchronized (springThread) {
            this._terminate = true;
        }
        SpringThreadWorker worker = this._worker;
        if (worker != null) {
            worker.machine.signalThreadTerminate(this);
        }
        if ((jdwp = this.machine().taskManager().jdwpController) != null) {
            jdwp.trip(JDWPTripThread.class, JDWPGlobalTrip.THREAD).alive(this, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SpringObject threadInstance() throws IllegalStateException {
        SpringObject rv;
        SpringThread springThread = this;
        synchronized (springThread) {
            rv = this._threadInstance;
        }
        if (rv == null) {
            throw new IllegalStateException("Thread has no instance.");
        }
        return rv;
    }

    public final String toString() {
        String rv;
        Reference<String> ref = this._string;
        if (ref == null || null == (rv = ref.get())) {
            rv = String.format("Thread-%d: %s", this.id, this.name);
            this._string = new WeakReference<String>(rv);
        }
        return rv;
    }
}

