/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.vm.springcoat;

import cc.squirreljme.emulator.profiler.ProfiledFrame;
import cc.squirreljme.vm.springcoat.SpringClass;
import cc.squirreljme.vm.springcoat.SpringMethod;
import cc.squirreljme.vm.springcoat.SpringNullObject;
import cc.squirreljme.vm.springcoat.SpringObject;
import cc.squirreljme.vm.springcoat.SpringStackTop;
import cc.squirreljme.vm.springcoat.exceptions.SpringNullPointerException;
import cc.squirreljme.vm.springcoat.exceptions.SpringVirtualMachineException;
import net.multiphasicapps.classfile.ByteCode;

public class SpringThreadFrame {
    public final int level;
    protected final SpringMethod method;
    protected final ByteCode code;
    protected final SpringObject thisobject;
    protected final boolean isblank;
    protected final SpringClass springClass;
    private final Object[] _locals;
    private final Object[] _stack;
    volatile ProfiledFrame _profiler;
    private volatile int _stacktop;
    private volatile int _pc;
    private volatile int _lastexecpc;
    private volatile int _execcount;
    private SpringObject _tossedexception;
    volatile SpringObject _monitor;

    SpringThreadFrame(int __level) {
        this.level = __level;
        this.method = null;
        this.springClass = null;
        this.code = null;
        this.thisobject = null;
        this.isblank = true;
        this._locals = new Object[0];
        this._stack = new Object[2];
    }

    SpringThreadFrame(int __level, SpringClass __cl, SpringMethod __m, Object ... __args) throws NullPointerException {
        ByteCode code;
        if (__cl == null || __m == null) {
            throw new NullPointerException("NARG");
        }
        __args = __args == null ? new Object[]{} : (Object[])__args.clone();
        this.level = __level;
        this.isblank = false;
        this.method = __m;
        this.springClass = __cl;
        this.code = code = __m.byteCode();
        Object[] locals = new Object[code.maxLocals()];
        this._locals = locals;
        this._stack = new Object[code.maxStack()];
        int n2 = __args.length;
        int o2 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object av2;
            locals[o2++] = av2 = __args[i2];
            if (!(av2 instanceof Long) && !(av2 instanceof Double)) continue;
            locals[o2++] = SpringStackTop.TOP;
        }
        this.thisobject = __m.flags().isStatic() ? null : (SpringObject)__args[0];
    }

    public final ByteCode byteCode() {
        return this.code;
    }

    public final void clearStack() {
        this._stacktop = 0;
    }

    public final int incrementExecCount() {
        return this._execcount++;
    }

    public final boolean isBlank() {
        return this.isblank;
    }

    public final int lastExecutedPc() {
        ByteCode code = this.code;
        if (code == null) {
            return -1;
        }
        return this._lastexecpc;
    }

    public final int lastExecutedPcIndex() {
        ByteCode code = this.code;
        if (code == null) {
            return -1;
        }
        return code.addressToIndex(this._lastexecpc);
    }

    public final int lastExecutedPcSourceLine() {
        ByteCode code = this.code;
        if (code == null) {
            return -1;
        }
        return code.lineOfAddress(this._lastexecpc);
    }

    public final <C> C loadLocal(Class<C> __cl, int __dx) throws NullPointerException {
        return __cl.cast(this._locals[__dx]);
    }

    public final void loadToStack(Class<?> __cl, int __dx) {
        Object[] locals = this._locals;
        Object pushy = locals[__dx];
        if (!__cl.isInstance(pushy)) {
            throw new SpringVirtualMachineException(String.format("BK1p %s %d %s %s %s", pushy, __dx, __cl, pushy, pushy == null ? "null" : pushy.getClass()));
        }
        this.pushToStack(pushy);
    }

    public final SpringMethod method() {
        return this.method;
    }

    public final int numLocals() {
        return this._locals.length;
    }

    public final int pc() {
        ByteCode code = this.code;
        if (code == null) {
            return -1;
        }
        return this._pc;
    }

    public final int pcIndex() {
        ByteCode code = this.code;
        if (code == null) {
            return -1;
        }
        return code.addressToIndex(this._pc);
    }

    public final int pcSourceLine() {
        if (this.code == null) {
            return -1;
        }
        return this.code.lineOfAddress(this._pc);
    }

    public final Object popFromStack() throws SpringVirtualMachineException {
        Object[] stack = this._stack;
        int stacktop = this._stacktop;
        if (stacktop <= 0) {
            throw new SpringVirtualMachineException(String.format("BK1q %d %d", stacktop, stack.length));
        }
        Object rv = stack[--stacktop];
        stack[stacktop] = null;
        this._stacktop = stacktop;
        if (rv == null) {
            throw new SpringVirtualMachineException("BK1r");
        }
        if (rv == SpringStackTop.TOP && !((rv = this.popFromStack()) instanceof Long) && !(rv instanceof Double)) {
            throw new SpringVirtualMachineException(String.format("BK1s %d %d", stacktop, stack.length));
        }
        return rv;
    }

    public final <C> C popFromStack(Class<C> __cl) throws NullPointerException, SpringVirtualMachineException {
        if (__cl == null) {
            throw new NullPointerException("NARG");
        }
        Object rv = this.popFromStack();
        if (!__cl.isInstance(rv)) {
            throw new SpringVirtualMachineException(String.format("BK1t %s %s", rv == null ? null : rv.getClass(), __cl));
        }
        return __cl.cast(rv);
    }

    public final <C> C popFromStackNotNull(Class<C> __cl) throws NullPointerException, SpringNullPointerException, SpringVirtualMachineException {
        if (__cl == null) {
            throw new NullPointerException("NARG");
        }
        Object rv = this.popFromStack();
        if (rv == SpringNullObject.NULL || rv instanceof SpringNullObject) {
            throw new SpringNullPointerException("BK1u");
        }
        if (!__cl.isInstance(rv)) {
            throw new SpringVirtualMachineException(String.format("BK1v %s %s", rv == null ? null : rv.getClass(), __cl));
        }
        return __cl.cast(rv);
    }

    public final void pushToStack(Object __v) throws NullPointerException, SpringVirtualMachineException {
        if (__v == null) {
            throw new NullPointerException("NARG");
        }
        int stacktop = this._stacktop;
        Object[] stack = this._stack;
        if (stacktop >= stack.length) {
            throw new SpringVirtualMachineException(String.format("BK1w %s %d %d", __v, stacktop, stack.length));
        }
        stack[stacktop++] = __v;
        this._stacktop = stacktop;
        if (__v instanceof Long || __v instanceof Double) {
            this.pushToStack(SpringStackTop.TOP);
        }
    }

    public final void setLastExecutedPc(int __pc) {
        this._lastexecpc = __pc;
    }

    public final void setPc(int __pc) {
        this._pc = __pc;
    }

    public final void storeLocal(int __dx, Object __v) throws NullPointerException {
        if (__v == null) {
            throw new NullPointerException("NARG");
        }
        this._locals[__dx] = __v;
    }

    public final SpringObject thisObject() {
        return this.thisobject;
    }

    public final SpringObject tossedException() {
        return this._tossedexception;
    }

    public final void tossException(SpringObject __o) {
        this._tossedexception = __o;
    }
}

