/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.vm.springcoat;

import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.vm.springcoat.CallbackThread;
import cc.squirreljme.vm.springcoat.SpringArray;
import cc.squirreljme.vm.springcoat.SpringClass;
import cc.squirreljme.vm.springcoat.SpringException;
import cc.squirreljme.vm.springcoat.SpringMachine;
import cc.squirreljme.vm.springcoat.SpringObject;
import cc.squirreljme.vm.springcoat.SpringProxyObject;
import cc.squirreljme.vm.springcoat.SpringThread;
import cc.squirreljme.vm.springcoat.SpringThreadWorker;
import cc.squirreljme.vm.springcoat.SpringVisClass;
import cc.squirreljme.vm.springcoat.SpringVisProxy;
import cc.squirreljme.vm.springcoat.exceptions.SpringArrayIndexOutOfBoundsException;
import cc.squirreljme.vm.springcoat.exceptions.SpringArrayStoreException;
import cc.squirreljme.vm.springcoat.exceptions.SpringClassNotFoundException;
import cc.squirreljme.vm.springcoat.exceptions.SpringFatalException;
import cc.squirreljme.vm.springcoat.exceptions.SpringNoSuchMethodException;
import cc.squirreljme.vm.springcoat.exceptions.SpringUnmappableObjectException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import net.multiphasicapps.classfile.ClassName;
import net.multiphasicapps.classfile.FieldDescriptor;
import net.multiphasicapps.classfile.MethodDescriptor;
import net.multiphasicapps.classfile.MethodNameAndType;
import net.multiphasicapps.classfile.PrimitiveType;

public class SpringVisObject
extends SpringProxyObject
implements SpringArray,
SpringObject {
    protected final Object real;
    protected final Class<?> realClass;
    private volatile SpringVisClass _visClass;

    public SpringVisObject(SpringMachine __machine, Object __real) throws NullPointerException {
        super(new ClassName(__real.getClass().getName().replace('.', '/')), __machine);
        if (__machine == null || __real == null) {
            throw new NullPointerException("NARG");
        }
        this.real = __real;
        this.realClass = __real.getClass();
    }

    @Override
    public Object array() {
        throw Debugging.todo();
    }

    @Override
    public <C> C get(Class<C> __cl, int __dx) throws NullPointerException, SpringArrayIndexOutOfBoundsException {
        if (__cl == null) {
            throw new NullPointerException("NARG");
        }
        SpringMachine machine = this.machine;
        SpringThread contextThread = machine.getCurrentThread();
        try (CallbackThread callbackThread = contextThread == null ? machine.obtainCallbackThread(true) : null;){
            SpringThreadWorker worker;
            if (contextThread == null) {
                contextThread = callbackThread.thread();
            }
            if ((worker = contextThread._worker) == null) {
                throw new SpringFatalException(String.format("No worker thread for %s", contextThread));
            }
            C c2 = __cl.cast(SpringVisObject.asVm(worker, this.realClass.getComponentType(), Array.get(this.real, __dx)));
            return c2;
        }
    }

    @Override
    public boolean isArray() {
        return this.realClass.isArray();
    }

    @Override
    public void set(int __dx, Object __v) throws SpringArrayStoreException, SpringArrayIndexOutOfBoundsException {
        throw Debugging.todo();
    }

    @Override
    public int length() {
        if (!this.isArray()) {
            return -1;
        }
        return Array.getLength(this.real);
    }

    @Override
    protected Object invokeProxy(SpringThreadWorker __thread, MethodNameAndType __method, Object[] __args) throws NullPointerException {
        if (__thread == null || __method == null) {
            throw new NullPointerException("NARG");
        }
        if ("getClass:()Ljava/lang/Class;".equals(__method.toString())) {
            return __thread.asVMObject(this.type());
        }
        SpringClass superClass = this.type().superClass();
        try {
            superClass.lookupMethod(false, __method);
            int n2 = __args.length;
            Object[] args = new Object[n2 + 1];
            args[0] = this;
            for (int i2 = 0; i2 < n2; ++i2) {
                args[i2 + 1] = __args[i2];
            }
            return __thread.invokeMethod(false, superClass.name(), __method, args);
        }
        catch (SpringNoSuchMethodException n2) {
            Method realMethod;
            Class[] realTypes = SpringVisObject.realType(__method.type());
            Class<?> realClass = this.realClass;
            try {
                realMethod = realClass.getMethod(__method.name().toString(), realTypes);
            }
            catch (NoSuchMethodException __e) {
                throw new SpringNoSuchMethodException(String.format("No real %s::%s", realClass.getName(), __method), __e);
            }
            int n3 = realTypes.length;
            Object[] realArgs = new Object[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                realArgs[i3] = SpringVisObject.asNative(__thread, __method.type().argument(i3), __args[i3]);
            }
            try {
                Object result = realMethod.invoke(this.real, realArgs);
                if (realMethod.getReturnType() != Void.TYPE) {
                    return SpringVisObject.asVm(__thread, realMethod.getReturnType(), result);
                }
                return null;
            }
            catch (InvocationTargetException __e) {
                throw SpringException.convert(__e.getCause());
            }
            catch (IllegalAccessException __e) {
                throw new SpringFatalException(String.format("Could not invoke real %s::%s", realClass.getName(), __method), __e);
            }
            catch (IllegalArgumentException __e) {
                __e.printStackTrace(System.err);
                throw Debugging.todo(__thread, __method, Arrays.asList(__args), Arrays.asList(realTypes), Arrays.asList(realArgs));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpringClass type() {
        SpringVisObject springVisObject = this;
        synchronized (springVisObject) {
            SpringVisClass result = this._visClass;
            if (result != null) {
                return result;
            }
            this._visClass = result = this.machine.virtualizeClass(this.real.getClass());
            return result;
        }
    }

    public static Object asNative(SpringThreadWorker __thread, FieldDescriptor __context, Object __in) throws NullPointerException {
        if (__thread == null) {
            throw new NullPointerException("NARG");
        }
        if (__context != null && __context.primitiveType() == PrimitiveType.BOOLEAN) {
            return (Integer)__in != 0;
        }
        try {
            if (__in instanceof SpringVisObject) {
                return ((SpringVisObject)__in).real;
            }
            return __thread.asNativeObject(__in);
        }
        catch (SpringUnmappableObjectException __e) {
            if (__in instanceof Throwable) {
                return SpringException.convert((Throwable)__in);
            }
            if (!(__in instanceof SpringObject)) {
                throw new SpringFatalException(String.format("Cannot asNative(%s)", __in), __e);
            }
            return SpringVisProxy.of(__thread.machine, (SpringObject)__in);
        }
    }

    public static <T> T asNative(SpringThreadWorker __thread, Class<T> __as, Object __in) {
        if (__thread == null || __as == null) {
            throw new NullPointerException("NARG");
        }
        if (__as == Boolean.class) {
            return __as.cast((Integer)__in != 0);
        }
        return __as.cast(SpringVisObject.asNative(__thread, ClassName.fromRuntimeName(__as.getName()).field(), __in));
    }

    public static Object asVm(SpringThreadWorker __thread, Class<?> __context, Object __in) throws NullPointerException {
        if (__thread == null) {
            throw new NullPointerException("NARG");
        }
        try {
            return __thread.asVMObject(__in);
        }
        catch (SpringUnmappableObjectException __ignored) {
            return __thread.machine.virtualizeObject(__in);
        }
    }

    public static Class<?> realType(FieldDescriptor __type) throws NullPointerException {
        if (__type == null) {
            throw new NullPointerException("NARG");
        }
        if (__type.isPrimitive()) {
            switch (__type.primitiveType()) {
                case BYTE: {
                    return Byte.TYPE;
                }
                case CHARACTER: {
                    return Character.TYPE;
                }
                case DOUBLE: {
                    return Double.TYPE;
                }
                case FLOAT: {
                    return Float.TYPE;
                }
                case INTEGER: {
                    return Integer.TYPE;
                }
                case LONG: {
                    return Long.TYPE;
                }
                case SHORT: {
                    return Short.TYPE;
                }
                case BOOLEAN: {
                    return Boolean.TYPE;
                }
            }
        }
        if (__type.isArray()) {
            Class<?> component = SpringVisObject.realType(__type.componentType());
            return Array.newInstance(component, 0).getClass();
        }
        try {
            return Class.forName(__type.className().toRuntimeString());
        }
        catch (ClassNotFoundException __e) {
            throw new SpringClassNotFoundException(__type.className(), (Throwable)__e);
        }
    }

    public static Class<?>[] realType(MethodDescriptor __type) throws NullPointerException {
        if (__type == null) {
            throw new NullPointerException("NARG");
        }
        int n2 = __type.argumentCount();
        Class[] result = new Class[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            result[i2] = SpringVisObject.realType(__type.argument(i2));
        }
        return result;
    }

    public static FieldDescriptor vmType(SpringMachine __machine, Class<?> __type) {
        if (__machine == null || __type == null) {
            throw new NullPointerException("NARG");
        }
        if (__type == Void.TYPE) {
            return null;
        }
        if (__type == Boolean.TYPE) {
            return ClassName.fromPrimitiveType(PrimitiveType.BOOLEAN).field();
        }
        if (__type == Byte.TYPE) {
            return ClassName.fromPrimitiveType(PrimitiveType.BYTE).field();
        }
        if (__type == Short.TYPE) {
            return ClassName.fromPrimitiveType(PrimitiveType.SHORT).field();
        }
        if (__type == Character.TYPE) {
            return ClassName.fromPrimitiveType(PrimitiveType.CHARACTER).field();
        }
        if (__type == Integer.TYPE) {
            return ClassName.fromPrimitiveType(PrimitiveType.INTEGER).field();
        }
        if (__type == Long.TYPE) {
            return ClassName.fromPrimitiveType(PrimitiveType.LONG).field();
        }
        if (__type == Float.TYPE) {
            return ClassName.fromPrimitiveType(PrimitiveType.FLOAT).field();
        }
        if (__type == Double.TYPE) {
            return ClassName.fromPrimitiveType(PrimitiveType.DOUBLE).field();
        }
        return ClassName.fromRuntimeName(__type.getName()).field();
    }

    public static MethodDescriptor vmTypes(SpringMachine __machine, Class<?> __rVal, Class<?>[] __args) throws NullPointerException {
        if (__machine == null || __rVal == null || __args == null) {
            throw new NullPointerException("NARG");
        }
        return new MethodDescriptor(SpringVisObject.vmType(__machine, __rVal), SpringVisObject.vmTypes(__machine, __args));
    }

    public static FieldDescriptor[] vmTypes(SpringMachine __machine, Class<?>[] __args) {
        if (__machine == null || __args == null) {
            throw new NullPointerException("NARG");
        }
        int n2 = __args.length;
        FieldDescriptor[] result = new FieldDescriptor[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            result[i2] = SpringVisObject.vmType(__machine, __args[i2]);
        }
        return result;
    }
}

