/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.vm.springcoat;

import cc.squirreljme.jvm.mle.exceptions.MLECallError;
import cc.squirreljme.vm.springcoat.CallbackThread;
import cc.squirreljme.vm.springcoat.MethodInvokeException;
import cc.squirreljme.vm.springcoat.SpringClass;
import cc.squirreljme.vm.springcoat.SpringMachine;
import cc.squirreljme.vm.springcoat.SpringObject;
import cc.squirreljme.vm.springcoat.SpringThread;
import cc.squirreljme.vm.springcoat.SpringThreadWorker;
import cc.squirreljme.vm.springcoat.SpringVisObject;
import cc.squirreljme.vm.springcoat.exceptions.SpringFatalException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import net.multiphasicapps.classfile.MethodName;
import net.multiphasicapps.classfile.MethodNameAndType;

public class SpringVisProxy
implements InvocationHandler {
    protected final SpringMachine machine;
    protected final SpringObject vmObject;

    private SpringVisProxy(SpringMachine __machine, SpringObject __vmObject) throws NullPointerException {
        if (__machine == null || __vmObject == null) {
            throw new NullPointerException("NARG");
        }
        this.machine = __machine;
        this.vmObject = __vmObject;
    }

    @Override
    public Object invoke(Object __proxy, Method __method, Object[] __args) throws Throwable {
        SpringMachine machine = this.machine;
        SpringThread contextThread = machine.getCurrentThread();
        try (CallbackThread callbackThread = contextThread == null ? machine.obtainCallbackThread(true) : null;){
            SpringThreadWorker worker;
            if (contextThread == null) {
                contextThread = callbackThread.thread();
            }
            if ((worker = contextThread._worker) == null) {
                throw new SpringFatalException(String.format("No worker thread for %s", contextThread));
            }
            MethodNameAndType nat = new MethodNameAndType(new MethodName(__method.getName()), SpringVisObject.vmTypes(machine, __method.getReturnType(), __method.getParameterTypes()));
            int n2 = __args == null ? 0 : __args.length;
            Object[] vmArgs = new Object[n2 + 1];
            vmArgs[0] = this.vmObject;
            for (int i2 = 0; i2 < n2; ++i2) {
                vmArgs[i2 + 1] = SpringVisObject.asVm(worker, null, __args[i2]);
            }
            Object result = contextThread.invokeMethod(false, this.vmObject.type().name(), nat, vmArgs);
            if (result instanceof MethodInvokeException) {
                MethodInvokeException t2 = (MethodInvokeException)result;
                t2.printStackTrace();
                t2.printVmTrace(System.err);
                throw new MLECallError(String.format("VM Exception: %s %s", t2.getMessage(), t2.exception), t2);
            }
            if (result != null) {
                Object object = SpringVisObject.asNative(worker, nat.type().returnValue(), result);
                return object;
            }
            Object var13_17 = null;
            return var13_17;
        }
    }

    public static Object of(SpringMachine __machine, SpringObject __vmObject) throws NullPointerException {
        if (__machine == null || __vmObject == null) {
            throw new NullPointerException("NARG");
        }
        ArrayList interfaces = new ArrayList();
        for (SpringClass vmClass : __vmObject.type().interfaceClasses()) {
            try {
                Class<?> realClass = Class.forName(vmClass.name().toRuntimeString());
                if (!realClass.isInterface()) continue;
                interfaces.add(realClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return Proxy.newProxyInstance(SpringVisProxy.class.getClassLoader(), interfaces.toArray(new Class[interfaces.size()]), (InvocationHandler)new SpringVisProxy(__machine, __vmObject));
    }
}

