/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.vm.springcoat;

import cc.squirreljme.vm.springcoat.SpringClass;
import cc.squirreljme.vm.springcoat.SpringObject;
import cc.squirreljme.vm.springcoat.SpringSimpleObject;
import cc.squirreljme.vm.springcoat.exceptions.SpringMLECallError;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public class SpringWeakObject
extends SpringSimpleObject {
    private volatile boolean _beenInit;
    private volatile Reference<SpringObject> _ref;
    private volatile SpringObject _queue;

    public SpringWeakObject(SpringClass __cl) throws NullPointerException {
        super(__cl);
        if (!"java/lang/ref/WeakReference".equals(__cl.name().toString())) {
            throw new SpringMLECallError("Invalid WeakReference Init");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpringObject clear() {
        SpringWeakObject springWeakObject = this;
        synchronized (springWeakObject) {
            Reference<SpringObject> ref = this._ref;
            if (ref == null) {
                return null;
            }
            this._ref = null;
            ref.enqueue();
            SpringObject queue = this._queue;
            this._queue = null;
            return queue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpringObject get() {
        SpringWeakObject springWeakObject = this;
        synchronized (springWeakObject) {
            Reference<SpringObject> ref = this._ref;
            if (ref == null) {
                return null;
            }
            return ref.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(SpringObject __value, SpringObject __queue) throws NullPointerException {
        if (__value == null) {
            throw new NullPointerException("NARG");
        }
        SpringWeakObject springWeakObject = this;
        synchronized (springWeakObject) {
            if (this._beenInit) {
                throw new SpringMLECallError("WeakReference init twice!");
            }
            this._beenInit = true;
            this._ref = new WeakReference<SpringObject>(__value);
            this._queue = __queue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnqueued() {
        SpringWeakObject springWeakObject = this;
        synchronized (springWeakObject) {
            if (!this._beenInit) {
                return false;
            }
            Reference<SpringObject> ref = this._ref;
            if (ref != null) {
                return ref.isEnqueued();
            }
            return this._queue == null;
        }
    }
}

