/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.vm.standalone.hosted;

import cc.squirreljme.emulator.vm.VMException;
import cc.squirreljme.jdwp.host.JDWPHostFactory;
import java.io.Closeable;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import net.multiphasicapps.io.ForwardInputToOutput;

public class HostedJDWPProxy
implements Closeable {
    public final int port;
    protected final JDWPHostFactory jdwpFactory;
    protected final ServerSocket server;
    protected final Thread threadAccept;
    private volatile ForwardInputToOutput _in;
    private volatile ForwardInputToOutput _out;

    public HostedJDWPProxy(JDWPHostFactory __jdwpFactory) throws VMException, NullPointerException {
        ServerSocket server;
        if (__jdwpFactory == null) {
            throw new NullPointerException("NARG");
        }
        this.jdwpFactory = __jdwpFactory;
        Runtime.getRuntime().addShutdownHook(new Thread(this::kill, "JDWPProxyKiller"));
        try {
            server = new ServerSocket(0);
        }
        catch (IOException __e) {
            throw new VMException(__e.getMessage(), __e);
        }
        this.server = server;
        this.port = server.getLocalPort();
        Thread threadAccept = new Thread(this::proxyAccept, "JDWPAccept");
        threadAccept.setDaemon(true);
        this.threadAccept = threadAccept;
        threadAccept.start();
    }

    @Override
    public void close() throws IOException {
        if (this.threadAccept != null) {
            this.threadAccept.interrupt();
        }
        if (this._in != null) {
            this._in.close();
        }
        if (this._out != null) {
            this._out.close();
        }
        if (this.server != null) {
            this.server.close();
        }
        if (this.jdwpFactory != null) {
            this.jdwpFactory.in().close();
            this.jdwpFactory.out().close();
        }
    }

    protected void kill() {
        try {
            this.close();
        }
        catch (IOException __e) {
            __e.printStackTrace();
        }
    }

    protected void proxyAccept() {
        try {
            ForwardInputToOutput out;
            ForwardInputToOutput in;
            Socket socket = this.server.accept();
            socket.setTcpNoDelay(true);
            socket.setKeepAlive(true);
            this._in = in = new ForwardInputToOutput(socket.getInputStream(), this.jdwpFactory.out());
            this._out = out = new ForwardInputToOutput(this.jdwpFactory.in(), socket.getOutputStream());
            in.runThread("JDWPProxyIn");
            out.runThread("JDWPProxyOut");
        }
        catch (IOException __e) {
            __e.printStackTrace();
        }
    }
}

