/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.vm.standalone.hosted;

import cc.squirreljme.emulator.EmulatedTaskShelf;
import cc.squirreljme.emulator.NativeBinding;
import cc.squirreljme.emulator.vm.VMException;
import cc.squirreljme.emulator.vm.VMSuiteManager;
import cc.squirreljme.emulator.vm.VirtualMachine;
import cc.squirreljme.jdwp.host.JDWPHostFactory;
import cc.squirreljme.jvm.mle.RuntimeShelf;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.vm.NameOverrideClassLibrary;
import cc.squirreljme.vm.VMClassLibrary;
import cc.squirreljme.vm.standalone.hosted.HostedCleanup;
import cc.squirreljme.vm.standalone.hosted.HostedJDWPProxy;
import cc.squirreljme.vm.standalone.hosted.HostedUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;

public class HostedVirtualMachine
implements VirtualMachine {
    protected final ProcessBuilder builder;
    protected final Map<String, String> actualSysProps;
    protected final String mainClass;
    protected final VMSuiteManager suiteManager;
    protected final JDWPHostFactory jdwpFactory;
    private final VMClassLibrary[] _classPath;
    private final String[] _mainArgs;

    public HostedVirtualMachine(JDWPHostFactory __jdwp, VMSuiteManager __suiteManager, VMClassLibrary[] __classPath, String __mainClass, Map<String, String> __sysProps, String ... __args) throws NullPointerException {
        ProcessBuilder builder;
        if (__suiteManager == null || __classPath == null || __mainClass == null) {
            throw new NullPointerException("NARG");
        }
        this.builder = builder = new ProcessBuilder(new String[0]);
        builder.redirectInput(ProcessBuilder.Redirect.INHERIT);
        builder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        builder.redirectError(ProcessBuilder.Redirect.INHERIT);
        Map<String, String> env = builder.environment();
        LinkedHashMap<String, String> actualSysProps = new LinkedHashMap<String, String>();
        this.actualSysProps = actualSysProps;
        if (__sysProps != null) {
            actualSysProps.putAll(__sysProps);
        }
        actualSysProps.put("squirreljme.hosted.libraries", "");
        actualSysProps.put("squirreljme.hosted.classpath", "");
        actualSysProps.put("squirreljme.hosted.vm.classpath", "");
        actualSysProps.put("squirreljme.hosted.vm.supportpath", "");
        this.jdwpFactory = __jdwp;
        this.suiteManager = __suiteManager;
        this.mainClass = __mainClass;
        this._classPath = (VMClassLibrary[])__classPath.clone();
        this._mainArgs = __args != null ? (String[])__args.clone() : new String[]{};
    }

    @Override
    public int runVm() throws VMException {
        ProcessBuilder builder = this.builder;
        Path tempJars = null;
        Process process = null;
        try {
            int exitCode;
            JDWPHostFactory jdwpFactory;
            tempJars = Files.createTempDirectory("squirreljme-hosted-jars", new FileAttribute[0]);
            Runtime.getRuntime().addShutdownHook(new Thread(new HostedCleanup(tempJars), "hosted-cleanup"));
            Map<String, String> actualSysProps = this.actualSysProps;
            LinkedHashSet<Path> libPaths = new LinkedHashSet<Path>();
            LinkedHashMap<String, Path> jarToPath = new LinkedHashMap<String, Path>();
            for (String libName : this.suiteManager.listLibraryNames()) {
                String actualName;
                VMClassLibrary lib = this.suiteManager.loadLibrary(libName);
                if (lib instanceof NameOverrideClassLibrary) {
                    actualName = lib.name();
                    lib = ((NameOverrideClassLibrary)lib).originalLibrary();
                } else {
                    actualName = lib.name();
                }
                Path path = HostedUtils.implodeJar(tempJars, lib, actualName);
                libPaths.add(path);
                jarToPath.put(actualName, path);
                Path wasPath = lib.path();
                if (wasPath == null) continue;
                String wasRelStr = wasPath.toString();
                String string = wasPath.toAbsolutePath().toString();
                String nowAbsStr = path.toAbsolutePath().toString();
                for (Map.Entry<String, String> entry : this.actualSysProps.entrySet()) {
                    String value = entry.getValue();
                    if (!Objects.equals(value, wasRelStr) && !Objects.equals(value, string)) continue;
                    entry.setValue(nowAbsStr);
                }
            }
            LinkedHashSet<Path> classPaths = new LinkedHashSet<Path>();
            for (VMClassLibrary lib : this._classPath) {
                Path target = (Path)jarToPath.get(lib.name());
                if (target == null) continue;
                classPaths.add(target);
            }
            String classPathString = EmulatedTaskShelf.classpathAsString(classPaths);
            String supportPath = System.getProperty("java.class.path");
            actualSysProps.put("squirreljme.hosted.libraries", EmulatedTaskShelf.classpathAsString(libPaths));
            actualSysProps.put("squirreljme.hosted.vm.classpath", classPathString);
            actualSysProps.put("squirreljme.hosted.vm.supportpath", supportPath);
            actualSysProps.put("squirreljme.hosted.classpath", classPathString);
            Path nativeLib = NativeBinding.loadedLibraryPath();
            if (nativeLib != null) {
                actualSysProps.put("squirreljme.emulator.libpath", nativeLib.toAbsolutePath().toString());
            }
            ArrayList<String> args = new ArrayList<String>();
            Path homeExec = HostedVirtualMachine.findJavaExe();
            if (homeExec != null) {
                args.add(homeExec.toAbsolutePath().normalize().toString());
            } else {
                args.add(Objects.toString(RuntimeShelf.vmDescription(6), "java"));
            }
            String osName = System.getProperty("os.name");
            if (osName != null && (osName.toLowerCase().contains("mac os") || osName.toLowerCase().contains("mac os x")) || osName.toLowerCase().contains("darwin")) {
                args.add("-XstartOnFirstThread");
            }
            if ((jdwpFactory = this.jdwpFactory) != null) {
                String[] proxy = new HostedJDWPProxy(jdwpFactory);
                args.add(String.format("-agentlib:jdwp=transport=dt_socket,server=n,address=localhost:%d,suspend=y", proxy.port));
            }
            for (Map.Entry interruptedException : actualSysProps.entrySet()) {
                args.add(String.format("-D%s=%s", interruptedException.getKey(), interruptedException.getValue()));
            }
            args.add("-classpath");
            args.add(supportPath + File.pathSeparator + classPathString);
            args.add("cc.squirreljme.emulator.NativeBinding");
            args.add(this.mainClass);
            for (String arg : this._mainArgs) {
                if (arg == null) continue;
                args.add(arg);
            }
            builder.command(args);
            if (Debugging.VERBOSE) {
                Debugging.debugNote("Hosted Args: %s", args);
            }
            process = builder.start();
            while (true) {
                try {
                    exitCode = process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            int n2 = exitCode;
            return n2;
        }
        catch (IOException e2) {
            throw new VMException("I/O Error", e2);
        }
        finally {
            if (process != null && process.isAlive()) {
                try {
                    process.destroyForcibly();
                }
                catch (Throwable __e) {
                    __e.printStackTrace();
                }
            }
            new HostedCleanup(tempJars).run();
        }
    }

    @Override
    public void setTraceBits(boolean __or, int __bits) {
    }

    public static Path findJavaExe() {
        Path binPath;
        String javaHomeRaw = System.getProperty("java.home");
        Path javaHome = javaHomeRaw != null ? Paths.get(javaHomeRaw, new String[0]) : null;
        Path javaExeName = System.getProperty("os.name").toLowerCase().contains("windows") ? Paths.get("java.exe", new String[0]) : Paths.get("java", new String[0]);
        Path path = binPath = javaHome != null ? javaHome.resolve("bin").resolve(javaExeName) : null;
        if (binPath != null && Files.exists(binPath, new LinkOption[0]) && Files.isExecutable((Path)binPath)) {
            return binPath;
        }
        return null;
    }
}

