/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.json.spi;

import cc.squirreljme.runtime.cldc.annotation.Api;
import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import com.oracle.json.JsonArrayBuilder;
import com.oracle.json.JsonBuilderFactory;
import com.oracle.json.JsonObjectBuilder;
import com.oracle.json.JsonReader;
import com.oracle.json.JsonReaderFactory;
import com.oracle.json.JsonWriter;
import com.oracle.json.JsonWriterFactory;
import com.oracle.json.stream.JsonGenerator;
import com.oracle.json.stream.JsonGeneratorFactory;
import com.oracle.json.stream.JsonParser;
import com.oracle.json.stream.JsonParserFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;

@Api
public abstract class JsonProvider {
    @SquirrelJMEVendorApi
    static final String DEFAULT_PROVIDER = "net.multiphasicapps.jsr353.ImplProvider";
    private static JsonProvider _jpc;

    @Api
    protected JsonProvider() {
    }

    @Api
    public abstract JsonArrayBuilder createArrayBuilder();

    @Api
    public abstract JsonBuilderFactory createBuilderFactory(Map<String, ?> var1);

    @Api
    public abstract JsonGenerator createGenerator(OutputStream var1);

    @Api
    public abstract JsonGenerator createGenerator(Writer var1);

    @Api
    public abstract JsonGeneratorFactory createGeneratorFactory(Map<String, ?> var1);

    @Api
    public abstract JsonObjectBuilder createObjectBuilder();

    @Api
    public abstract JsonParser createParser(InputStream var1);

    @Api
    public abstract JsonParser createParser(Reader var1);

    @Api
    public abstract JsonParserFactory createParserFactory(Map<String, ?> var1);

    @Api
    public abstract JsonReader createReader(InputStream var1);

    @Api
    public abstract JsonReader createReader(Reader var1);

    @Api
    public abstract JsonReaderFactory createReaderFactory(Map<String, ?> var1);

    @Api
    public abstract JsonWriter createWriter(OutputStream var1);

    @Api
    public abstract JsonWriter createWriter(Writer var1);

    @Api
    public abstract JsonWriterFactory createWriterFactory(Map<String, ?> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api
    public static JsonProvider provider() {
        Class<JsonProvider> clazz = JsonProvider.class;
        synchronized (JsonProvider.class) {
            if (_jpc == null) {
                ServiceLoader<JsonProvider> sl = ServiceLoader.load(JsonProvider.class);
                if (sl != null) {
                    Iterator<JsonProvider> it = sl.iterator();
                    try {
                        while ((_jpc = it.next()) == null) {
                        }
                        // ** MonitorExit[var0] (shouldn't be in output)
                        return _jpc;
                    }
                    catch (NoSuchElementException nsee) {
                        // empty catch block
                    }
                }
                try {
                    Class<?> cl2 = Class.forName(DEFAULT_PROVIDER);
                    Object o2 = cl2.newInstance();
                    if (!(o2 instanceof JsonProvider)) {
                        throw new RuntimeException("Default JsonProvider is not a JsonProvider");
                    }
                    _jpc = (JsonProvider)o2;
                }
                catch (ClassNotFoundException cnfe) {
                    throw new RuntimeException("Could not find default JsonProvider.");
                }
                catch (InstantiationException ie) {
                    throw new RuntimeException("Default JsonProvider could not be initialized.");
                }
                catch (IllegalAccessException iae) {
                    throw new RuntimeException("Default JsonProvider is not accessable (probably not public).");
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _jpc;
        }
    }
}

